/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.security.Principal;
import progress.message.broker.AddrUtil;
import progress.message.broker.AdminQopCache;
import progress.message.broker.AgentAdminSession;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.CWADSMessageHandler;
import progress.message.broker.CheckUnsubscribeDurable;
import progress.message.broker.ClientLGSettingHandler;
import progress.message.broker.Config;
import progress.message.broker.DelDurableSubscriptions;
import progress.message.broker.DelDynamicRoutes;
import progress.message.broker.DelRouting;
import progress.message.broker.DisconnectNoSave;
import progress.message.broker.DisconnectSave;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.Echo;
import progress.message.broker.ForceSyncpoint;
import progress.message.broker.GetActiveTransactions;
import progress.message.broker.GetBrokerLog;
import progress.message.broker.GetConnectionID;
import progress.message.broker.GetConnectionInfo;
import progress.message.broker.GetConnections;
import progress.message.broker.GetDurableSubscriptionUserIds;
import progress.message.broker.GetDurableSubscriptions;
import progress.message.broker.GetDynamicRoutes;
import progress.message.broker.GetInDoubtTransactions;
import progress.message.broker.GetInterbrokerConfig;
import progress.message.broker.GetNeighborSubscriptions;
import progress.message.broker.GetRemoteSubscriptions;
import progress.message.broker.GetRoutingNodeName;
import progress.message.broker.GetStats;
import progress.message.broker.GetStatsInfo;
import progress.message.broker.GetSubjects;
import progress.message.broker.GetSubscriptions;
import progress.message.broker.GetSubscriptionsInfo;
import progress.message.broker.IsOperationAllowed;
import progress.message.broker.PipeSocket;
import progress.message.broker.ReportPublisherBlocked;
import progress.message.broker.ReportPublisherUnblocked;
import progress.message.broker.ReportSenderBlocked;
import progress.message.broker.ReportSenderUnblocked;
import progress.message.broker.ResetBrokerLog;
import progress.message.broker.ResetStats;
import progress.message.broker.ResolveError;
import progress.message.broker.SetRouting;
import progress.message.broker.StartDelivery;
import progress.message.broker.StopDelivery;
import progress.message.broker.Subscribe;
import progress.message.broker.SubscribeEvt;
import progress.message.broker.SubscribeP28;
import progress.message.broker.TunnelingChannel;
import progress.message.broker.Unsubscribe;
import progress.message.broker.UnsubscribeAll;
import progress.message.broker.UnsubscribeDurable;
import progress.message.broker.UnsubscribeP28;
import progress.message.broker.gs.GSRulesAdmin;
import progress.message.broker.parser.ParseException;
import progress.message.broker.parser.TokenMgrError;
import progress.message.broker.prAccessor;
import progress.message.client.EGeneralException;
import progress.message.dd.ClearAdminHandler;
import progress.message.net.ISocket;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.zclient.Connection;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Job;
import progress.message.zclient.Label;
import progress.message.zclient.Message;
import progress.message.zclient.MessageHandler;
import progress.message.zclient.Session;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.Solicitation;
import progress.message.zclient.Subject;

public class AgentAdminConnection
extends Connection
implements IMessageHandler {
    private AgentRegistrar m_agentReg;
    private long m_id;

    public AgentAdminConnection(AgentRegistrar reg, PipeSocket socket, Principal principal) throws IOException, EGeneralException {
        super("Broker", principal, new MessageHandler(null, false, true));
        if (DebugState.GLOBAL_DEBUG_ON) {
            this.debugName("AgentAdminConnection ");
        }
        this.m_socket = socket;
        this.m_agentReg = reg;
        this.m_defaultSession = new AgentAdminSession(this);
        this.m_id = AddrUtil.stringToClientId(Config.BROKER_UID, "Broker");
        this.setDefaultMessageHandler(this.generateDefaultDispatcher());
        Connection.setAdminConnection(this);
    }

    @Override
    public long getClientId() {
        return this.m_id;
    }

    public AgentRegistrar getAgentRegistrar() {
        return this.m_agentReg;
    }

    @Override
    protected ISocket openSocket(String socketType, String host, int port) {
        return this.m_socket;
    }

    void subscribeAdminHandler() {
        Subject adminSubscription = new Subject(Config.getAdminPrefix("*", "*") + ".#");
        try {
            Label lab = new Label();
            lab.setRouteLimit(1);
            lab.setPersistent(false);
            SubscribeEvt evt = new SubscribeEvt(null, this.m_id, adminSubscription, lab);
            this.m_agentReg.subscribe(evt);
        }
        catch (EClientNotRegistered e) {
            throw new EAssertFailure("Could not subscribe admin handler: " + e, e);
        }
        catch (EGeneralException e) {
            throw new EAssertFailure("Could not subscribe admin handler: " + e, e);
        }
        catch (ParseException e) {
            throw new EAssertFailure("Could not set selector : " + e, e);
        }
        catch (TokenMgrError e) {
            throw new EAssertFailure("Could not set selector : " + e, e);
        }
    }

    private MessageHandler generateDefaultDispatcher() throws EGeneralException {
        MessageHandler mh = new MessageHandler(this);
        mh.setName("Default admin handler");
        String prefix = Config.getAdminPrefix("*", "*");
        mh.bind(prefix + ".subscribe", (IMessageHandler)new Subscribe(this.m_agentReg));
        mh.bind(prefix + ".subscribeP28", (IMessageHandler)new SubscribeP28(this.m_agentReg));
        mh.bind(prefix + ".resolveError", (IMessageHandler)new ResolveError(this.m_agentReg));
        mh.bind(prefix + ".getSubscriptions", (IMessageHandler)new GetSubscriptions(this.m_agentReg));
        mh.bind(prefix + ".getSubscriptionsInfo", (IMessageHandler)new GetSubscriptionsInfo(this.m_agentReg));
        mh.bind(prefix + ".getRemoteSubscriptions", (IMessageHandler)new GetRemoteSubscriptions(this.m_agentReg));
        mh.bind(prefix + ".getNeighborSubscriptions", (IMessageHandler)new GetNeighborSubscriptions(this.m_agentReg));
        mh.bind(prefix + ".disconnectSave", (IMessageHandler)new DisconnectSave(this.m_agentReg));
        mh.bind(prefix + ".unsubscribe", (IMessageHandler)new Unsubscribe(this.m_agentReg));
        mh.bind(prefix + ".unsubscribeP28", (IMessageHandler)new UnsubscribeP28(this.m_agentReg));
        mh.bind(prefix + ".unsubscribeAll", (IMessageHandler)new UnsubscribeAll(this.m_agentReg));
        mh.bind(prefix + ".unsubscribeDurable", (IMessageHandler)new UnsubscribeDurable(this.m_agentReg));
        mh.bind(prefix + ".checkUnsubscribeDurable", (IMessageHandler)new CheckUnsubscribeDurable(this.m_agentReg));
        mh.bind(prefix + ".disconnectNoSave", (IMessageHandler)new DisconnectNoSave(this.m_agentReg));
        mh.bind(prefix + ".echo", (IMessageHandler)new Echo(this.m_agentReg));
        mh.bind(prefix + ".forceSyncpoint", (IMessageHandler)new ForceSyncpoint(this.m_agentReg));
        mh.bind(prefix + ".getActiveTransactions", (IMessageHandler)new GetActiveTransactions(this.m_agentReg));
        mh.bind(prefix + ".getInDoubtTransactions", (IMessageHandler)new GetInDoubtTransactions(this.m_agentReg));
        mh.bind(prefix + ".getStats", (IMessageHandler)new GetStats(this.m_agentReg.getStatsManager()));
        mh.bind(prefix + ".getStatsInfo", (IMessageHandler)new GetStatsInfo(this.m_agentReg.getStatsManager()));
        mh.bind(prefix + ".getSubjects", (IMessageHandler)new GetSubjects(this.m_agentReg));
        mh.bind(prefix + ".resetStats", (IMessageHandler)new ResetStats(this.m_agentReg.getStatsManager()));
        mh.bind(prefix + ".isOperationAllowed", (IMessageHandler)new IsOperationAllowed(this.m_agentReg));
        mh.bind(prefix + ".startDelivery", (IMessageHandler)new StartDelivery(this.m_agentReg));
        mh.bind(prefix + ".stopDelivery", (IMessageHandler)new StopDelivery(this.m_agentReg));
        mh.bind(prefix + ".clearTransactionTable", (IMessageHandler)new ClearAdminHandler());
        mh.bind(prefix + ".pubblocked", (IMessageHandler)new ReportPublisherBlocked(this.m_agentReg));
        mh.bind(prefix + ".pubresumed", (IMessageHandler)new ReportPublisherUnblocked(this.m_agentReg));
        mh.bind(prefix + ".sendblocked", (IMessageHandler)new ReportSenderBlocked(this.m_agentReg));
        mh.bind(prefix + ".sendresumed", (IMessageHandler)new ReportSenderUnblocked(this.m_agentReg));
        if (!Config.ENABLE_INTERBROKER) {
            mh.bind(prefix + ".setStaticRouting", (IMessageHandler)new SetRouting(this.m_agentReg));
            mh.bind(prefix + ".delStaticRouting", (IMessageHandler)new DelRouting(this.m_agentReg));
        }
        mh.bind(prefix + ".getDynamicRoutes", (IMessageHandler)new GetDynamicRoutes(this.m_agentReg));
        mh.bind(prefix + ".delDynamicRoutes", (IMessageHandler)new DelDynamicRoutes(this.m_agentReg));
        mh.bind(prefix + ".getConnections", (IMessageHandler)new GetConnections(this.m_agentReg));
        mh.bind(prefix + ".getInterbrokerConfig", (IMessageHandler)new GetInterbrokerConfig());
        mh.bind(prefix + ".tunnelingChannel", (IMessageHandler)new TunnelingChannel(this.m_agentReg));
        mh.bind(prefix + ".getConnectionInfo", (IMessageHandler)new GetConnectionInfo(this.m_agentReg));
        mh.bind(prefix + ".getBrokerLog", (IMessageHandler)new GetBrokerLog(this.m_agentReg));
        mh.bind(prefix + ".resetBrokerLog", (IMessageHandler)new ResetBrokerLog(this.m_agentReg));
        mh.bind(prefix + ".getConnectionID", (IMessageHandler)new GetConnectionID(this.m_agentReg));
        mh.bind(prefix + ".getDurableSubscriptionUserIds", (IMessageHandler)new GetDurableSubscriptionUserIds(this.m_agentReg));
        mh.bind(prefix + ".getDurableSubscriptions", (IMessageHandler)new GetDurableSubscriptions(this.m_agentReg));
        mh.bind(prefix + ".delDurableSubscriptions", (IMessageHandler)new DelDurableSubscriptions(this.m_agentReg));
        mh.bind(prefix + ".getRoutingNodeName", (IMessageHandler)new GetRoutingNodeName(this.m_agentReg));
        mh.bind(prefix + ".gsRulesAdmin", (IMessageHandler)new GSRulesAdmin(this.m_agentReg));
        mh.bind(prefix + ".CWADSUpdate", (IMessageHandler)new CWADSMessageHandler(this.m_agentReg));
        mh.bind(prefix + ".LG", (IMessageHandler)new ClientLGSettingHandler(this.m_agentReg));
        return mh;
    }

    @Override
    public void addJob(long jid, Job j) {
        super.addJob(jid, j);
    }

    @Override
    protected Job getJob(long jid) {
        return super.getJob(jid);
    }

    @Override
    public Job removeJob(long jid) {
        return super.removeJob(jid);
    }

    @Override
    protected Solicitation addSolicitation(Envelope env, MessageHandler mh) {
        return super.addSolicitation(env, mh);
    }

    @Override
    protected void createQopCache() {
        this.m_qopcache = new AdminQopCache(this.m_agentReg.m_regSub);
    }

    @Override
    public void handleMessage(Session session, Envelope envelope) {
        Message msg = envelope.getMessage();
        String subj = msg.getSubject().getSubjectString();
        if (!subj.equals("$SYS.client.brokerConnectionDropped")) {
            SessionConfig.logMessage(prAccessor.getString("STR001") + subj + "'", SessionConfig.getLevelInfo());
        }
    }
}

