/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mf.common.MFException;
import com.sonicsw.mq.common.runtime.IBrowseToken;
import com.sonicsw.mq.common.runtime.IMessageHeaderToken;
import com.sonicsw.mq.common.runtime.impl.RuntimeDataFactory;
import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.net.http.HttpRemoteBroker;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentAdminSession;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BaseAgentQueue;
import progress.message.broker.Config;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.IAgentQueue;
import progress.message.broker.IClientContext;
import progress.message.broker.IQueueInfo;
import progress.message.broker.IRemoteBroker;
import progress.message.broker.ISavableAgentQueue;
import progress.message.broker.PendingQueue;
import progress.message.broker.PublishLimiterNotify;
import progress.message.broker.QElement;
import progress.message.broker.QueueFactory;
import progress.message.broker.RoutingQueue;
import progress.message.broker.SavableQElement;
import progress.message.broker.parser.ParseException;
import progress.message.broker.parser.TokenMgrError;
import progress.message.broker.prAccessor;
import progress.message.client.EGeneralException;
import progress.message.client.ESecurityGeneralException;
import progress.message.gr.RemoteBrokerHelper;
import progress.message.gr.RouteForwarder;
import progress.message.gr.RouterManager;
import progress.message.msg.IMgram;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.util.IndexedList;
import progress.message.util.QueueUtil;
import progress.message.zclient.Envelope;
import progress.message.zclient.Label;
import progress.message.zclient.Message;

public class AgentRoutingQueue
extends BaseAgentQueue
implements IAgentQueue,
ISavableAgentQueue {
    private String m_name;
    private String m_address;
    AgentRegistrar m_reg;
    private Label m_emptyLabel;
    RoutingQueue m_queue;
    private boolean m_global = false;
    private int m_state = 0;
    private boolean m_clustered = false;
    private boolean m_readOnly = false;
    private boolean m_readExclusive = false;
    private boolean m_writeOnly = false;
    private boolean m_writeExclusive = false;
    RouterManager m_routerMgr = null;
    RouteForwarder m_routeForwarder = null;
    RemoteBrokerHelper m_rbHelper = null;
    private Vector m_pendingQueues;
    private Hashtable m_pendingQueuesByName;
    private Hashtable m_remoteBrokersByPendingQueueName;
    private Object m_pendingQueueMutex;
    private int m_nonDelayableReceiverCount = 0;
    private Map<Long, String> m_pendingQueuesByBrowserId;
    private long m_brokerIdentifier = -1L;
    private long m_browserSeqNo = 0L;
    private HashMap<Long, Long> m_browserIdleTimeouts = new HashMap();
    private Map<Long, Long> m_browserInactiveTimeouts = null;
    private PendingQueueBrowserExpirer m_browserExpirer = null;
    private static long DEFAULT_ADMIN_BROWSER_INACTIVE_TIMEOUT = 900000L;
    private Map<Long, HashMap<String, QElement>> m_browseResults = Collections.synchronizedMap(new HashMap());
    Object m_browseLock = new Object();
    private Object m_browserSeqNoLock = new Object();

    public AgentRoutingQueue(String qName, RoutingQueue rq, AgentRegistrar reg) {
        super(DebugState.GLOBAL_DEBUG_ON ? "AgentRoutingQueue " + qName : null);
        this.m_queue = rq;
        this.initInstance(qName, reg);
    }

    @Override
    public synchronized void clearExpiredMsgs() throws InterruptedException {
        this.clearExpiredMsgs(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void clearExpiredMsgs(boolean checkRemoteSubscriptionDeletion) throws InterruptedException {
        this.m_queue.checkForExpiredMsgs(checkRemoteSubscriptionDeletion);
        try {
            Enumeration enu = ((Vector)this.m_pendingQueues.clone()).elements();
            PendingQueue pq = null;
            while (enu.hasMoreElements()) {
                pq = (PendingQueue)enu.nextElement();
                RoutingQueue routingQueue = this.m_queue;
                synchronized (routingQueue) {
                    pq.checkForExpiredMsgs(checkRemoteSubscriptionDeletion);
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.updateQueueStats();
    }

    @Override
    public void onOutstandingLocalClientGetRequests() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void get(long cid, short type, int countParam, boolean isRemoteGetRequest) {
        int count = countParam;
        if (type != 3) {
            throw new EAssertFailure("Receiving messages from the routing queue is not supported.");
        }
        PendingQueue pq = null;
        String pendingQueueName = this.m_pendingQueuesByBrowserId.get(cid);
        if (pendingQueueName != null) {
            Object object = this.m_pendingQueueMutex;
            synchronized (object) {
                pq = (PendingQueue)this.m_pendingQueuesByName.get(pendingQueueName);
            }
        }
        if (pq == null) {
            this.m_pendingQueuesByBrowserId.remove(cid);
            return;
        }
        if (this.checkDebugFlags(16384)) {
            this.debug("BROWSE request from client '" + cid + "' with message count '" + count + "' for pending queue '" + pendingQueueName + "'");
        }
        IMgram m = null;
        try {
            while (pq != null && count > 0 && (m = this.browsePendingQueue(pq, cid, false)) != null) {
                if (m.isGuarenteed()) {
                    m.setReliable();
                }
                this.deliver(m, cid);
                --count;
            }
            if (count > 0) {
                IClientContext cc = null;
                cc = this.m_reg.getClient(cid);
                String uid = cc.getUid();
                String appid = cc.getAppid();
                AgentAdminSession sn = this.m_reg.getAdminSession();
                Message reply = new Message();
                reply.setSubject(QueueUtil.getQueueClientSubject(uid, appid, "endOfBrowse"));
                try {
                    sn.publish(reply, 0, false);
                }
                catch (EGeneralException eGeneralException) {}
            }
        }
        catch (EClientNotRegistered e) {
            return;
        }
        catch (ESecurityGeneralException eSecurityGeneralException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<IMgram> browse(IBrowseToken token, int countParam) throws MFException {
        int count = countParam;
        ArrayList<IMgram> result = new ArrayList<IMgram>();
        long cid = RuntimeDataFactory.getBrowseTokenClientId(token);
        String pendingQueueName = this.m_pendingQueuesByBrowserId.get(cid);
        PendingQueue pq = null;
        if (pendingQueueName != null) {
            Object object = this.m_pendingQueueMutex;
            synchronized (object) {
                pq = (PendingQueue)this.m_pendingQueuesByName.get(pendingQueueName);
            }
        } else {
            MFException mfe = new MFException("Invalid pending queue browser.");
            throw mfe;
        }
        if (pq == null) {
            this.m_pendingQueuesByBrowserId.remove(cid);
            MFException mfe = new MFException("Pending queue \"" + pendingQueueName + "\" no longer exists.");
            throw mfe;
        }
        if (this.checkDebugFlags(16384)) {
            this.debug("BROWSE mgmt request from client with message count '" + count + "' for pending queue '" + pendingQueueName + "'");
        }
        this.updateBrowserIdleTimeout(cid, false);
        HashMap<String, QElement> results = this.m_browseResults.get(cid);
        if (results != null) {
            results.clear();
        }
        IMgram m = null;
        while (pq != null && count > 0 && (m = this.browsePendingQueue(pq, cid, true)) != null) {
            if (m.isGuarenteed()) {
                m.setReliable();
            }
            result.add(m);
            --count;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IMgram browsePendingQueue(PendingQueue pq, long cid, boolean cache) {
        IMgram m = null;
        Object object = this.m_browseLock;
        synchronized (object) {
            m = (IMgram)pq.browse(cid);
            if (cache && m != null) {
                QElement qe = pq.m_theBrowseResultsContainer.m_elem;
                HashMap<String, QElement> results = this.m_browseResults.get(cid);
                if (results == null) {
                    results = new HashMap();
                    this.m_browseResults.put(cid, results);
                }
                results.put(Envelope.getMessageID(m), qe);
            }
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteMessages(ArrayList<IMessageHeaderToken> tokens) throws MFException, InterruptedException {
        int result = 0;
        ArrayList<String> messageIDs = null;
        PendingQueue pq = null;
        for (IMessageHeaderToken ht : tokens) {
            QElement qe;
            String jmsMessageID = RuntimeDataFactory.getMHTJMSMessageID(ht);
            long clientId = RuntimeDataFactory.getMHTClientId(ht);
            String pendingQueueName = this.m_pendingQueuesByBrowserId.get(clientId);
            if (pendingQueueName != null) {
                Object object = this.m_pendingQueueMutex;
                synchronized (object) {
                    pq = (PendingQueue)this.m_pendingQueuesByName.get(pendingQueueName);
                }
            } else {
                if (!this.checkDebugFlags(16384)) continue;
                this.debug("Unable to delete pending a queue message - pending queue no found.");
                continue;
            }
            if (pq == null) {
                this.m_pendingQueuesByBrowserId.remove(clientId);
                if (!this.checkDebugFlags(16384)) continue;
                this.debug("Unable to delete pending queue message(s) - pending queue \"" + pendingQueueName + "\" no longer exists.");
                continue;
            }
            HashMap<String, QElement> results = this.m_browseResults.get(clientId);
            if (results != null && (qe = results.get(jmsMessageID)) != null) {
                if (this.checkDebugFlags(16384)) {
                    this.debug("Deleting a browsed message FOUND in the cache, id = " + jmsMessageID);
                }
                pq.clear((SavableQElement)qe);
                ++result;
                continue;
            }
            if (this.checkDebugFlags(16384)) {
                this.debug("Deleting a browsed message NOT in the cache, id = " + jmsMessageID);
            }
            if (messageIDs == null) {
                messageIDs = new ArrayList<String>();
            }
            messageIDs.add(jmsMessageID);
        }
        if (messageIDs != null) {
            if (pq == null) {
                throw new NullPointerException("PendingQueue cannot be null.");
            }
            result += pq.clear(messageIDs);
        }
        return result;
    }

    @Override
    public String getQueueName() {
        return this.m_name;
    }

    @Override
    public String getQueueAddress() {
        return this.m_address;
    }

    public Collection getPendingQueueData() {
        Vector pqd = (Vector)this.m_pendingQueues.clone();
        ArrayList<PQueueInfo> result = new ArrayList<PQueueInfo>(pqd.size());
        for (PendingQueue pq : pqd) {
            result.add(new PQueueInfo(pq.m_qName, pq.getCurrentEnqueuedCount(), pq.getCurrentTotalSize(), pq.getMinEnqueueTime()));
        }
        return result;
    }

    public IQueueInfo getPendingQueueData(String pqname) {
        PQueueInfo qi = null;
        PendingQueue pq = (PendingQueue)this.m_pendingQueuesByName.get(pqname);
        if (pq != null) {
            qi = new PQueueInfo(pq.m_qName, pq.getCurrentEnqueuedCount(), pq.getCurrentTotalSize(), pq.getMinEnqueueTime());
        }
        return qi;
    }

    public void notifySpaceAvailable() {
        long min_notifysize;
        long max = this.getMaxQueueSizeInBytes();
        long available = max - this.getTotalEnqueuedSizeInBytes();
        long l = min_notifysize = (long)Config.FLOW_CONTROL_NOTIFY_SIZE <= max ? (long)Config.FLOW_CONTROL_NOTIFY_SIZE : (long)Config.FLOW_CONTROL_DEFAULT_NOTIFY_SIZE;
        if (available > 0L && available >= min_notifysize) {
            this.m_reg.getFlowControlManager().onSpaceAvailable(this.m_address, available);
        }
    }

    @Override
    public void restore(IndexedList unacked, boolean preserveRedelivery, boolean notifyMsgEnqueued) {
        this.restore(unacked.elements(), preserveRedelivery, notifyMsgEnqueued);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restore(Enumeration enu, boolean preserveRedelivery, boolean notifyMsgEnqueued) {
        if (!enu.hasMoreElements()) {
            return;
        }
        Vector v = new Vector();
        while (enu.hasMoreElements()) {
            v.addElement(enu.nextElement());
        }
        Object[] msgs = new Object[v.size()];
        v.copyInto(msgs);
        if (msgs.length == 0) {
            return;
        }
        if (this.DEBUG) {
            this.debug("restoring " + msgs.length + " messages to queue " + this.getQueueName());
        }
        RoutingQueue routingQueue = this.m_queue;
        synchronized (routingQueue) {
            for (int i = msgs.length - 1; i >= 0; --i) {
                IMgram m = (IMgram)msgs[i];
                if (this.DEBUG) {
                    this.debug("restore: restoring mgram = " + m.getGuarenteedTrackingNum() + " to queue " + this.getQueueName());
                }
                this.m_queue.reenqueue(m, preserveRedelivery);
            }
        }
        if (notifyMsgEnqueued) {
            this.m_dispatcher.routedMessageEnqueued();
        }
        this.updateQueueStats();
    }

    @Override
    public void unreserve(int size) {
        this.m_queue.unreserve(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PendingQueue getPendingQueue(String name, boolean create) {
        PendingQueue pq = null;
        Object object = this.m_pendingQueueMutex;
        synchronized (object) {
            pq = (PendingQueue)this.m_pendingQueuesByName.get(name);
            if (pq == null) {
                if (!create) {
                    return null;
                }
                pq = (PendingQueue)QueueFactory.getQueueFactory().createQueue(2, name, Config.PENDING_MAX_QUEUE_SIZE);
                this.m_pendingQueues.addElement(pq);
                this.m_pendingQueuesByName.put(name, pq);
            }
        }
        return pq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRemoteBroker getPendingRemoteBroker(String name) {
        Object object = this.m_pendingQueueMutex;
        synchronized (object) {
            return (IRemoteBroker)this.m_remoteBrokersByPendingQueueName.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPendingRemoteBroker(String name, IRemoteBroker irb) {
        Object object = this.m_pendingQueueMutex;
        synchronized (object) {
            if (this.getPendingQueue(name, false) != null) {
                this.m_remoteBrokersByPendingQueueName.put(name, irb);
                AgentRoutingQueue.configPendingQueueExistsCheckingIrb(irb);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Enumeration getPendingQueueNamesInternal() {
        Object object = this.m_pendingQueueMutex;
        synchronized (object) {
            return this.m_pendingQueuesByName.keys();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getPendingQueueNames() {
        Object object = this.m_pendingQueueMutex;
        synchronized (object) {
            return new ArrayList(this.m_pendingQueuesByName.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPendingQueueDisconnected(String name) {
        Object object = this.m_pendingQueueMutex;
        synchronized (object) {
            PendingQueue pq = this.getPendingQueue(name, false);
            if (pq == null) {
                return;
            }
            pq.setSaveThresholdInKiloBytes(Config.DISCONNECTED_PENDING_SAVE_THRESHOLD);
            pq.setMaxQueueSizeInKiloBytes(Config.DISCONNECTED_PENDING_MAX_QUEUE_SIZE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPendingQueueFlowControlled(String name) {
        Object object = this.m_pendingQueueMutex;
        synchronized (object) {
            PendingQueue pq = this.getPendingQueue(name, false);
            if (pq == null) {
                return;
            }
            pq.setSaveThresholdInKiloBytes(Config.FLOW_CONTROLLED_PENDING_SAVE_THRESHOLD);
            pq.setMaxQueueSizeInKiloBytes(Config.FLOW_CONTROLLED_PENDING_MAX_QUEUE_SIZE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canProcessAnyPendingQueue(Vector queuesToProcess, Vector needPrepareRetry, PublishLimiterNotify notifyLimiter) throws InterruptedException {
        boolean okToProcess = false;
        Object object = this.m_pendingQueueMutex;
        synchronized (object) {
            Enumeration enu = this.getPendingQueueNamesInternal();
            while (enu.hasMoreElements()) {
                String name = (String)enu.nextElement();
                IRemoteBroker irb = this.getPendingRemoteBroker(name);
                PendingQueue pq = this.getPendingQueue(name, false);
                if (pq.getRemoveMessagesFlag() || irb.isOkToSend(notifyLimiter)) {
                    okToProcess = true;
                    queuesToProcess.addElement(name);
                    continue;
                }
                if (!irb.isConnected()) {
                    this.setPendingQueueDisconnected(name);
                    needPrepareRetry.addElement(irb);
                    continue;
                }
                this.setPendingQueueFlowControlled(name);
            }
        }
        return okToProcess;
    }

    public boolean checkDeletePendingIfEmpty(String name, PublishLimiterNotify notifyLimiter) {
        return this.checkDeletePendingIfEmpty(name, notifyLimiter, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkDeletePendingIfEmpty(String name, PublishLimiterNotify notifyLimiter, boolean notifyBlockedClients) {
        boolean notifyFCM = false;
        IRemoteBroker irb = this.getPendingRemoteBroker(name);
        boolean queueIsEmpty = false;
        if (notifyBlockedClients) {
            notifyFCM = true;
        }
        Object object = this.getDequeueLock();
        synchronized (object) {
            Object object2 = notifyLimiter.getNotifyTarget();
            synchronized (object2) {
                Object object3 = this.m_pendingQueueMutex;
                synchronized (object3) {
                    PendingQueue pq = this.getPendingQueue(name, false);
                    if (pq == null) {
                        queueIsEmpty = true;
                    } else if (pq.isEmpty()) {
                        queueIsEmpty = true;
                        boolean okToSend = this.isRoutingQueueEmpty() ? irb.isOkToSend(notifyLimiter) : false;
                        if (okToSend) {
                            this.removePendingQueue(name);
                            notifyFCM = true;
                        } else if (!this.m_reg.getFlowControlManager().existBlockedClients(name)) {
                            this.removePendingQueue(name);
                        }
                    } else {
                        queueIsEmpty = false;
                    }
                }
            }
            if (notifyFCM) {
                this.m_reg.getFlowControlManager().onRemoteNodeAvailable(irb.getPendingQueueName());
            }
        }
        return queueIsEmpty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkEnqueuePending(IRemoteBroker irb, IMgram m) {
        boolean enqueued = false;
        Object object = this.m_pendingQueueMutex;
        synchronized (object) {
            PendingQueue pq = this.getPendingQueue(irb.getPendingQueueName(), false);
            if (pq == null) {
                return false;
            }
            this.m_remoteBrokersByPendingQueueName.put(irb.getPendingQueueName(), irb);
            AgentRoutingQueue.configPendingQueueExistsCheckingIrb(irb);
            if (!m.isDiscardable()) {
                pq.enqueue(m);
                enqueued = true;
            }
        }
        if (enqueued) {
            this.updateQueueStats();
            this.updateQueueRcvdStats(m);
        }
        return true;
    }

    private static void configPendingQueueExistsCheckingIrb(IRemoteBroker irb) {
        if (irb != null && irb.isHttp()) {
            ((HttpRemoteBroker)irb).setPendingQueueExists(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createEmptyPendingForIRB(IRemoteBroker irb) {
        String name = irb.getPendingQueueName();
        Object object = this.m_pendingQueueMutex;
        synchronized (object) {
            this.getPendingQueue(name, true);
            if (!irb.isConnected()) {
                this.setPendingQueueDisconnected(name);
            } else {
                this.setPendingQueueFlowControlled(name);
            }
            this.setPendingRemoteBroker(name, irb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueuePending(IRemoteBroker irb, IMgram m) {
        String name = irb.getPendingQueueName();
        Object object = this.m_pendingQueueMutex;
        synchronized (object) {
            PendingQueue pq = this.getPendingQueue(name, true);
            this.setPendingRemoteBroker(name, irb);
            pq.enqueue(m);
        }
        this.updateQueueStats();
        this.updateQueueRcvdStats(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reenqueuePending(IRemoteBroker irb, IMgram mgram, boolean preserveRedelivered) {
        String name = irb.getPendingQueueName();
        Object object = this.m_pendingQueueMutex;
        synchronized (object) {
            if (this.checkDebugFlags(64)) {
                this.debug("reenqueuePending creating PQ pq name: " + irb.getPendingQueueName() + " irb: " + irb);
            }
            PendingQueue pq = this.getPendingQueue(name, true);
            this.setPendingRemoteBroker(name, irb);
            pq.reenqueue(mgram, preserveRedelivered);
        }
        this.updateQueueStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMgram dequeuePending(String name) {
        IMgram ret = null;
        Object object = this.getDequeueLock();
        synchronized (object) {
            Object object2 = this.m_pendingQueueMutex;
            synchronized (object2) {
                PendingQueue pq = this.getPendingQueue(name, false);
                ret = pq == null ? null : (IMgram)pq.dequeue();
            }
        }
        if (ret != null) {
            long enqTm = ret.getBrokerHandle().getPtpEnqueueTime();
            long tmInQueue = enqTm > 0L ? System.currentTimeMillis() - enqTm : 0L;
            this.updateQueueDelvStatsAndStatistic(ret, tmInQueue);
        }
        this.updateQueueStats();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PendingQueue swapPendingQueue(String name) {
        Object object = this.m_pendingQueueMutex;
        synchronized (object) {
            PendingQueue old = this.getPendingQueue(name, false);
            if (old == null) {
                return null;
            }
            IRemoteBroker irb = this.getPendingRemoteBroker(name);
            this.removePendingQueue(name);
            if (this.checkDebugFlags(64)) {
                this.debug("swapPendingQueue creating PQ pq name: " + irb.getPendingQueueName() + " irb: " + irb);
            }
            this.getPendingQueue(name, true);
            this.setPendingRemoteBroker(name, irb);
            return old;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePendingQueue(String name) {
        IRemoteBroker irb = null;
        Object object = this.m_pendingQueueMutex;
        synchronized (object) {
            PendingQueue pq = (PendingQueue)this.m_pendingQueuesByName.remove(name);
            if (pq == null) {
                return;
            }
            this.m_pendingQueues.removeElement(pq);
            PendingQueue pendingQueue = pq;
            synchronized (pendingQueue) {
                pq.setRemoveFlag();
            }
            irb = (IRemoteBroker)this.m_remoteBrokersByPendingQueueName.remove(name);
            if (irb != null && irb.isHttp()) {
                ((HttpRemoteBroker)irb).setPendingQueueExists(false);
            }
            if (pq.m_browsers != null && !pq.m_browsers.isEmpty()) {
                Enumeration<Long> ids = pq.m_browsers.keys();
                while (ids.hasMoreElements()) {
                    this.m_pendingQueuesByBrowserId.remove(ids.nextElement());
                }
            }
        }
    }

    public static boolean isNeighborPendingQueue(String name) {
        return name.startsWith(Config.ROUTING_NODE_NAME + "$");
    }

    @Override
    public void acknowledge(long tracking, long ackTracking) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPendingQueue(String pendingQueueName) throws InterruptedException {
        PendingQueue pq = null;
        Object object = this.m_pendingQueueMutex;
        synchronized (object) {
            if (pendingQueueName != null) {
                pq = (PendingQueue)this.m_pendingQueuesByName.get(pendingQueueName);
            }
        }
        if (pq == null) {
            return;
        }
        object = this.m_queue;
        synchronized (object) {
            pq.clear();
        }
        this.updateQueueStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void clear() throws InterruptedException {
        this.m_queue.clear();
        try {
            Enumeration enu = ((Vector)this.m_pendingQueues.clone()).elements();
            PendingQueue pq = null;
            while (enu.hasMoreElements()) {
                pq = (PendingQueue)enu.nextElement();
                RoutingQueue routingQueue = this.m_queue;
                synchronized (routingQueue) {
                    pq.clear();
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.updateQueueStats();
    }

    @Override
    public synchronized void close() {
        this.m_state = 4;
        this.dispatchShutdown();
        this.m_state = 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean closeBrowser(long clientId) {
        this.m_browseResults.remove(clientId);
        this.clearBrowserIdleTimeout(clientId);
        String pendingQueueName = this.m_pendingQueuesByBrowserId.remove(new Long(clientId));
        if (this.checkDebugFlags(16384)) {
            this.debug("closeBrowser(cid=" + clientId + "): pending queue name = " + pendingQueueName);
        }
        if (pendingQueueName == null) {
            return false;
        }
        PendingQueue pq = null;
        Object object = this.m_pendingQueueMutex;
        synchronized (object) {
            pq = (PendingQueue)this.m_pendingQueuesByName.get(pendingQueueName);
        }
        if (pq != null) {
            pq.closeBrowser(clientId);
        }
        return true;
    }

    @Override
    public void closeReceiver(long clientId) {
    }

    @Override
    public IMgram dequeue(long clientId) throws InterruptedException {
        return null;
    }

    @Override
    public IMgram dequeueByTrackingNum(long trackingNum) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int dispatch(long clientId, int count, boolean forRemoteBroker) throws InterruptedException {
        if (this.DEBUG) {
            this.debug("in AgentRoutingQueue.dispatch()");
        }
        IMgram m = null;
        RoutingQueue routingQueue = this.m_queue;
        synchronized (routingQueue) {
            m = (IMgram)this.m_queue.dequeue();
        }
        if (this.DEBUG) {
            if (m != null) {
                this.debug("in AgentRoutingQueue.dispatch(), mgram = " + m.getGuarenteedTrackingNum());
            } else {
                this.debug("in AgentRoutingQueue.dispatch(), mgram was null");
            }
        }
        try {
            if (m == null) {
                int n = 0;
                return n;
            }
            long enqTm = m.getBrokerHandle().getPtpEnqueueTime();
            long tmInQueue = enqTm > 0L ? System.currentTimeMillis() - enqTm : 0L;
            this.m_rbHelper.route(m);
            this.updateQueueDelvStatsAndStatistic(m, tmInQueue);
            int n = 1;
            return n;
        }
        finally {
            this.updateQueueStats();
        }
    }

    private void updateQueueDelvStatsAndStatistic(IMgram m, long tmInQueue) {
        this.updateQueueDelvStats(m);
        if (tmInQueue > 0L) {
            this.updateStatistic(this.m_timeInQueueStat, tmInQueue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(IMgram m) {
        long size = 0L;
        if (!m.isGuarenteed()) {
            throw new EAssertFailure("Attemped to enqueue unguaranteed message");
        }
        RoutingQueue routingQueue = this.m_queue;
        synchronized (routingQueue) {
            this.m_queue.enqueue(m);
            if (this.DEBUG) {
                size = this.m_queue.getCurrentTotalSize();
            }
            this.m_queue.notifyAll();
        }
        this.initiateDispatching();
        this.updateQueueRcvdStats(m);
        this.updateQueueStats();
        if (this.DEBUG) {
            this.debug("Enqueued TKID:" + m.getGuarenteedTrackingNum() + ", PRI:" + m.getPriority() + ", Queue Size:" + size + (m.isJMSPersistent() ? " PERSISTENT" : ""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean forceReserve(IMgram m) {
        boolean overflow = false;
        RoutingQueue routingQueue = this.m_queue;
        synchronized (routingQueue) {
            if ((long)m.getEnqueuedSize() + this.getTotalEnqueuedSizeInBytes() > this.m_queue.getMaxQueueSizeInBytes()) {
                overflow = true;
            }
            this.m_queue.forceReserve(m);
        }
        return overflow;
    }

    @Override
    public void forcedSave() {
        this.m_queue.forcedSave();
    }

    @Override
    public Object getDequeueLock() {
        return this.m_queue;
    }

    public int getEnqueuedCount() {
        int total = this.m_queue.getCurrentEnqueuedCount();
        if (this.checkDebugFlags(16)) {
            this.debug("getEnqueuedCount: count messages on AgentRoutintQueue only = " + total);
        }
        return total;
    }

    @Override
    public synchronized int getNonDelayableReceiverCount() {
        return this.m_nonDelayableReceiverCount;
    }

    @Override
    public int getMaxQueueSizeInKiloBytes() {
        return this.m_queue.getMaxQueueSizeInKiloBytes();
    }

    @Override
    public long getMaxQueueSizeInBytes() {
        return this.m_queue.getMaxQueueSizeInBytes();
    }

    @Override
    public int getQueueType() {
        return 4;
    }

    @Override
    public int getReceiverCount() {
        return 0;
    }

    @Override
    public int getSaveThresholdInKiloBytes() {
        return this.m_queue.getSaveThresholdInKiloBytes();
    }

    @Override
    public int getTotalEnqueued() {
        return this.getTotalEnqueued(true);
    }

    private int getTotalEnqueued(boolean sync) {
        int overallTotal = sync ? this.m_queue.getCurrentEnqueuedCount() : this.m_queue.getCurrentEnqueuedCountUnsynchronized();
        if (this.checkDebugFlags(16)) {
            this.debug("getTotalEnqueued: count messages on AgentRoutingQueue only = " + overallTotal);
        }
        try {
            Enumeration enu = ((Vector)this.m_pendingQueues.clone()).elements();
            PendingQueue pq = null;
            while (enu.hasMoreElements()) {
                pq = (PendingQueue)enu.nextElement();
                overallTotal += pq.getCurrentEnqueuedCount();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (this.checkDebugFlags(16)) {
            this.debug("getTotalEnqueued: overall total count of messages = " + overallTotal);
        }
        return overallTotal;
    }

    @Override
    public long getTotalSize() {
        return this.getTotalEnqueuedSizeInBytes();
    }

    @Override
    protected long getOldestEnqueueTime() {
        long min = this.m_queue.getMinEnqueueTime();
        try {
            Enumeration enu = ((Vector)this.m_pendingQueues.clone()).elements();
            PendingQueue pq = null;
            while (enu.hasMoreElements()) {
                pq = (PendingQueue)enu.nextElement();
                long enqTm = pq.getMinEnqueueTime();
                if (enqTm == 0L) continue;
                if (min == 0L) {
                    min = enqTm;
                    continue;
                }
                if (enqTm >= min) continue;
                min = enqTm;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return min;
    }

    public long getTotalEnqueuedSizeInBytes() {
        long overallTotalSize = this.m_queue.getCurrentTotalSize();
        if (this.checkDebugFlags(16)) {
            this.debug("getTotalEnqueued: total size of routing queue instance = " + overallTotalSize);
        }
        try {
            Enumeration enu = ((Vector)this.m_pendingQueues.clone()).elements();
            PendingQueue pq = null;
            while (enu.hasMoreElements()) {
                pq = (PendingQueue)enu.nextElement();
                overallTotalSize += pq.getCurrentTotalSize();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (this.checkDebugFlags(16)) {
            this.debug("getTotalEnqueued: overall total size of routing queue and all associated pending queues = " + overallTotalSize);
        }
        return overallTotalSize;
    }

    @Override
    public boolean isReadExclusive() {
        return this.m_readExclusive;
    }

    @Override
    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    @Override
    public boolean isWriteExclusive() {
        return this.m_writeExclusive;
    }

    @Override
    public boolean isWriteOnly() {
        return this.m_writeOnly;
    }

    @Override
    public boolean isGlobal() {
        return this.m_global;
    }

    @Override
    public boolean isClustered() {
        return this.m_clustered;
    }

    @Override
    public boolean openBrowser(long clientId) throws ParseException, TokenMgrError {
        return this.openBrowser(clientId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean openBrowser(long clientId, String selector) throws ParseException, TokenMgrError {
        if (selector == null) {
            return false;
        }
        String pendingQueueName = QueueUtil.getBrowserPendingQueueName(selector);
        String messageSelector = QueueUtil.getBrowserMessageSelector(selector);
        if (this.checkDebugFlags(16384)) {
            this.debug("calling #openBrowser(cid=" + clientId + ", selector=" + selector + "): pending queue name = " + pendingQueueName);
        }
        PendingQueue pq = null;
        Object object = this.m_pendingQueueMutex;
        synchronized (object) {
            if (pendingQueueName != null) {
                pq = (PendingQueue)this.m_pendingQueuesByName.get(pendingQueueName);
            }
        }
        if (pq != null) {
            pq.openBrowser(clientId, messageSelector);
            this.m_pendingQueuesByBrowserId.put(new Long(clientId), pendingQueueName);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNextBrowserSeqNo() {
        Object object = this.m_browserSeqNoLock;
        synchronized (object) {
            return this.m_browserSeqNo++;
        }
    }

    public IBrowseToken openBrowser(String selector) {
        if (this.m_brokerIdentifier == -1L) {
            this.m_brokerIdentifier = AgentRegistrar.getAgentRegistrar().getLogManager().getStartupSeqNo();
        }
        String uid = "$PQBR$" + String.valueOf(this.m_brokerIdentifier);
        String appid = String.valueOf(this.getNextBrowserSeqNo());
        long clientId = AddrUtil.stringToClientId(uid, appid);
        IBrowseToken result = null;
        try {
            if (this.openBrowser(clientId, selector)) {
                result = RuntimeDataFactory.createBrowseToken(clientId, uid + ":" + appid);
                this.updateBrowserIdleTimeout(clientId, true);
            }
        }
        catch (Exception e) {
            String err = "Failed to create a pending queue browser for node " + QueueUtil.getBrowserPendingQueueName(selector);
            BrokerComponent.getComponentContext().logMessage(err, (Throwable)e, 2);
        }
        return result;
    }

    public void setBrowserInactiveTimeout(long clientId, int inactiveTimeoutInSecond) {
        if (this.m_browserInactiveTimeouts == null) {
            this.m_browserInactiveTimeouts = Collections.synchronizedMap(new HashMap());
        }
        this.m_browserInactiveTimeouts.put(clientId, Long.valueOf(inactiveTimeoutInSecond * 1000));
    }

    @Override
    public boolean openReceiver(long clientId) throws ParseException, TokenMgrError {
        return false;
    }

    @Override
    public boolean openReceiver(long clientId, String selector) throws ParseException, TokenMgrError {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(IMgram m, long sender_cid) {
        long size = 0L;
        RoutingQueue routingQueue = this.m_queue;
        synchronized (routingQueue) {
            this.m_queue.enqueue(m);
            if (this.DEBUG) {
                size = this.m_queue.getCurrentEnqueuedSize();
            }
            this.m_queue.notifyAll();
        }
        if (this.DEBUG) {
            this.debug("put: Enqueued TKID:" + m.getGuarenteedTrackingNum() + ", Priority:" + m.getPriority() + ", Queue Size:" + size + (m.isJMSPersistent() ? " PERSISTENT" : ""));
        }
        this.m_dispatcher.routedMessageEnqueued();
        this.updateQueueStats();
        this.updateQueueRcvdStats(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reserve(IMgram m) {
        RoutingQueue routingQueue = this.m_queue;
        synchronized (routingQueue) {
            if ((long)m.getEnqueuedSize() + this.getTotalEnqueuedSizeInBytes() > this.m_queue.getMaxQueueSizeInBytes()) {
                return false;
            }
            return this.m_queue.reserve(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reserve(int size) {
        RoutingQueue routingQueue = this.m_queue;
        synchronized (routingQueue) {
            if ((long)size + this.getTotalEnqueuedSizeInBytes() > this.m_queue.getMaxQueueSizeInBytes()) {
                return false;
            }
            return this.m_queue.reserve(size);
        }
    }

    @Override
    public synchronized void restore(List elems) {
        Object[] obj1;
        int numElements = elems.size();
        Object[] obj = new Object[]{new Integer(elems.size()).toString(), this.getQueueName()};
        BrokerComponent.getComponentContext().logMessage(MessageFormat.format(prAccessor.getString("RESTORING_COUNT"), obj), 3);
        int count = this.m_queue.restore(elems);
        if (count < numElements) {
            obj1 = new Object[]{new Integer(numElements - count).toString(), this.getQueueName()};
            BrokerComponent.getComponentContext().logMessage(MessageFormat.format(prAccessor.getString("MESSAGES_EXPIRED"), obj1), 3);
        }
        obj1 = new Object[]{new Integer(count).toString(), this.getQueueName()};
        BrokerComponent.getComponentContext().logMessage(MessageFormat.format(prAccessor.getString("RESTORED_COUNT"), obj1), 3);
        this.updateQueueStats();
    }

    @Override
    public void setFlowControl(boolean fc) {
    }

    @Override
    public void setGlobal(boolean global) {
        this.m_global = false;
    }

    @Override
    public void setClustered(boolean clustered) {
        this.m_clustered = false;
    }

    @Override
    public void setMaxQueueSizeInBytes(long max) {
        this.m_queue.setMaxQueueSizeInBytes(max);
    }

    @Override
    public void setMaxQueueSizeInKiloBytes(int max) {
        this.m_queue.setMaxQueueSizeInKiloBytes(max);
    }

    @Override
    public void setReadExclusiveMode(boolean mode) {
        this.m_readExclusive = mode;
    }

    @Override
    public void setReadOnlyMode(boolean mode) {
        this.m_readOnly = mode;
    }

    @Override
    public void setSaveThresholdInKiloBytes(int newSaveThreshold) {
        this.m_queue.setSaveThresholdInKiloBytes(newSaveThreshold);
    }

    @Override
    public void setWriteExclusiveMode(boolean mode) {
        this.m_writeExclusive = mode;
    }

    @Override
    public void setWriteOnlyMode(boolean mode) {
        this.m_writeOnly = mode;
    }

    @Override
    public synchronized void start() {
        if (!this.m_reg.getQueueProc().isStarted()) {
            String gl = this.isGlobal() ? prAccessor.getString("GLOBAL") : prAccessor.getString("LOCAL");
            String se = this.isReadExclusive() ? prAccessor.getString("EXCLUSIVE") : prAccessor.getString("SHARED");
            String cl = this.isClustered() ? prAccessor.getString("CLUSTERED") : prAccessor.getString("NONCLUSTERED");
            Object[] obj = new Object[]{this.getQueueName(), gl, cl, se, new Integer(this.getSaveThresholdInKiloBytes()).toString(), new Integer(this.getMaxQueueSizeInKiloBytes()).toString()};
            BrokerComponent.getComponentContext().logMessage(MessageFormat.format(prAccessor.getString("STARTING_QUEUE"), obj), 3);
        }
        this.dispatchStartup(this.m_reg.getQueueProc().getDispatcher());
        this.m_state = 3;
    }

    public boolean isRoutingQueueEmpty() {
        return this.m_queue.getCurrentEnqueuedCount() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deliver(IMgram m, long clientId) throws EClientNotRegistered, ESecurityGeneralException {
        IClientContext cc = null;
        int sendStatus = 0;
        if (this.DEBUG) {
            this.debug("Message sent as " + (m.isGuarenteed() ? "guaranteed" : "reliable"));
        }
        cc = this.m_reg.getClient(clientId);
        if (this.DEBUG) {
            this.debug("Sending mgram: " + m + " to client " + clientId);
        }
        sendStatus = cc.send(m, this.m_emptyLabel, null);
        if (this.DEBUG) {
            String stat = null;
            switch (sendStatus) {
                case 1: {
                    stat = "REJECTED";
                    break;
                }
                case 2: {
                    stat = "DISCARDED";
                    break;
                }
                case 0: {
                    stat = "ACCEPTED";
                    break;
                }
                default: {
                    stat = "UNKNOWN";
                }
            }
            this.debug("IMgram sent to CID: " + clientId + ", status = " + stat);
        }
        if (sendStatus == 1) {
            boolean reenqueued = false;
            RoutingQueue routingQueue = this.m_queue;
            synchronized (routingQueue) {
                this.m_queue.reenqueue(m, true);
                reenqueued = true;
                this.m_queue.notifyAll();
            }
            if (reenqueued) {
                this.updateQueueStats();
            }
            return false;
        }
        return true;
    }

    @Override
    public synchronized void decrementNonDelayableReceiverCount() {
        --this.m_nonDelayableReceiverCount;
    }

    @Override
    public synchronized void incrementNonDelayableReceiverCount() {
        ++this.m_nonDelayableReceiverCount;
    }

    private void initInstance(String qName, AgentRegistrar reg) {
        this.m_name = qName;
        this.m_address = "$Q." + this.m_name;
        this.m_reg = reg;
        this.m_emptyLabel = new Label();
        this.m_pendingQueues = new Vector();
        this.m_pendingQueuesByName = new Hashtable();
        this.m_remoteBrokersByPendingQueueName = new Hashtable();
        this.m_pendingQueuesByBrowserId = Collections.synchronizedMap(new HashMap());
        this.m_pendingQueueMutex = new Object();
        this.m_routerMgr = this.m_reg.getRouterManager();
        if (this.m_routerMgr != null) {
            this.m_routeForwarder = this.m_routerMgr.getRouteForwarder();
            this.m_rbHelper = this.m_reg.getQueueProc().getRemoteBrokerHelper();
        }
        this.initMetrics();
    }

    @Override
    protected void updateQueueStats() {
        this.updateStatistic(this.m_queueMaxDepthStat, this.getTotalEnqueued(false));
        this.updateStatistic(this.m_queueSizeStat, this.getTotalEnqueuedSizeInBytes());
    }

    @Override
    public long getPercentageFull() {
        return this.m_queue.getCurrentEnqueuedSize() * 100L / this.m_queue.getMaxQueueSizeInBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBrowserIdleTimeout(long cid, boolean register) {
        Long inactiveTimeout;
        long browserInactiveTimeout = DEFAULT_ADMIN_BROWSER_INACTIVE_TIMEOUT;
        if (this.m_browserInactiveTimeouts != null && (inactiveTimeout = this.m_browserInactiveTimeouts.get(cid)) != null && inactiveTimeout > 0L) {
            browserInactiveTimeout = inactiveTimeout;
        }
        HashMap<Long, Long> hashMap = this.m_browserIdleTimeouts;
        synchronized (hashMap) {
            this.m_browserIdleTimeouts.put(cid, System.currentTimeMillis() + browserInactiveTimeout);
            if (register) {
                if (this.m_browserExpirer == null) {
                    this.m_browserExpirer = new PendingQueueBrowserExpirer();
                }
                this.m_browserExpirer.onNewMgmtBrowser();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearBrowserIdleTimeout(long cid) {
        HashMap<Long, Long> hashMap = this.m_browserIdleTimeouts;
        synchronized (hashMap) {
            this.m_browserIdleTimeouts.remove(cid);
        }
        if (this.m_browserInactiveTimeouts != null) {
            this.m_browserInactiveTimeouts.remove(cid);
        }
    }

    final class PendingQueueBrowserExpirer
    implements Runnable {
        static final int EXPIRER_RUN_INTERVAL = 60000;
        private boolean m_isRegistered = false;

        PendingQueueBrowserExpirer() {
        }

        public void onNewMgmtBrowser() {
            if (!this.m_isRegistered) {
                AgentRegistrar.getAgentRegistrar().getWatchDogThread().addRelativeTimer(this, 60000L);
                this.m_isRegistered = true;
            }
        }

        @Override
        public void run() {
            new Thread("Routing Queue Browsers Expiry"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (AgentRoutingQueue.this.checkDebugFlags(16384)) {
                        AgentRoutingQueue.this.debug(Thread.currentThread().getName() + " running...");
                    }
                    HashMap browserIdleTimeouts = null;
                    HashMap hashMap = AgentRoutingQueue.this.m_browserIdleTimeouts;
                    synchronized (hashMap) {
                        if (!AgentRoutingQueue.this.m_browserIdleTimeouts.isEmpty()) {
                            browserIdleTimeouts = new HashMap(AgentRoutingQueue.this.m_browserIdleTimeouts);
                        } else {
                            PendingQueueBrowserExpirer.this.m_isRegistered = false;
                        }
                    }
                    if (browserIdleTimeouts != null) {
                        try {
                            long currentTime = System.currentTimeMillis();
                            for (Long clientId : browserIdleTimeouts.keySet()) {
                                if ((Long)browserIdleTimeouts.get(clientId) >= currentTime) continue;
                                AgentRoutingQueue.this.closeBrowser(clientId);
                            }
                        }
                        catch (Throwable t) {
                            String err = "Error expiring idle pending queue browser(s)";
                            BrokerComponent.getComponentContext().logMessage(err, t, 2);
                        }
                        finally {
                            HashMap currentTime = AgentRoutingQueue.this.m_browserIdleTimeouts;
                            synchronized (currentTime) {
                                if (!AgentRoutingQueue.this.m_browserIdleTimeouts.isEmpty()) {
                                    AgentRegistrar.getAgentRegistrar().getWatchDogThread().addRelativeTimer(PendingQueueBrowserExpirer.this, 60000L);
                                    PendingQueueBrowserExpirer.this.m_isRegistered = true;
                                } else {
                                    PendingQueueBrowserExpirer.this.m_isRegistered = false;
                                }
                            }
                        }
                    }
                    if (AgentRoutingQueue.this.checkDebugFlags(16384)) {
                        AgentRoutingQueue.this.debug(Thread.currentThread().getName() + " exiting...m_isRegistered = " + PendingQueueBrowserExpirer.this.m_isRegistered);
                    }
                }
            }.start();
        }
    }

    private final class PQueueInfo
    implements IQueueInfo {
        private String m_name;
        private int m_totalEnqueued;
        private long m_totalSize;
        private long m_maxAge = 0L;

        PQueueInfo(String name, int totalEnqueued, long totalSize, long minEnqTime) {
            this.m_totalEnqueued = totalEnqueued;
            this.m_totalSize = totalSize;
            this.m_name = name;
            if (minEnqTime > 0L) {
                this.m_maxAge = System.currentTimeMillis() - minEnqTime;
            }
        }

        @Override
        public int getQueueType() {
            return 2;
        }

        @Override
        public int getTotalEnqueued() {
            return this.m_totalEnqueued;
        }

        @Override
        public long getTotalSize() {
            return this.m_totalSize;
        }

        @Override
        public String getQueueName() {
            return this.m_name;
        }

        @Override
        public boolean isGlobal() {
            return false;
        }

        @Override
        public boolean isClustered() {
            return false;
        }

        @Override
        public boolean isReadExclusive() {
            return false;
        }

        @Override
        public long getOldestMessageAge() {
            return this.m_maxAge;
        }
    }
}

