/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import progress.message.broker.IQueueContext;
import progress.message.broker.QElement;
import progress.message.broker.QToken;
import progress.message.msg.IMgram;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.zclient.DebugObject;

public abstract class BaseQueue
extends DebugObject {
    protected final String m_qName;
    protected final int m_numPriorities;
    protected long m_maxQueueSize;
    protected final IQueueContext m_bqc;
    protected final QToken[] m_queuePriorityToken;
    protected final int[] m_elementsEnqueuedCount;
    protected int m_totalEnqueuedCount;
    private long m_totalEnqueuedSize;
    private final Object m_qSizeLock = new Object();
    private long m_reservedSize;
    protected int m_highestNonEmptyPriority;
    private volatile long m_minEnqueueTime;
    public static final float s_DEFAULT_STOP_FACTOR = 0.9f;
    public static final float s_DEFAULT_RESUME_FACTOR = 0.85f;

    public BaseQueue(String qName, int numPriorities, int maxQueueSize, IQueueContext bqc) {
        super(DebugState.GLOBAL_DEBUG_ON ? "BaseQueue" : null);
        int i;
        this.m_qName = qName;
        this.m_numPriorities = numPriorities;
        this.m_bqc = bqc;
        this.m_queuePriorityToken = new QToken[this.m_numPriorities + 1];
        for (i = 0; i <= this.m_numPriorities; ++i) {
            this.m_queuePriorityToken[i] = new QToken();
            if (i <= 0) continue;
            this.m_queuePriorityToken[i - 1].m_prev = this.m_queuePriorityToken[i];
            this.m_queuePriorityToken[i].m_next = this.m_queuePriorityToken[i - 1];
        }
        this.m_elementsEnqueuedCount = new int[this.m_numPriorities + 1];
        for (i = 0; i < this.m_numPriorities; ++i) {
            this.m_elementsEnqueuedCount[i] = 0;
        }
        this.m_highestNonEmptyPriority = -1;
        long szInKB = maxQueueSize;
        this.m_maxQueueSize = szInKB > 0x1FFFFFFFFFFFFFL ? Long.MAX_VALUE : szInKB * 1024L;
    }

    synchronized void enqueue(QElement elem, int prio, long len) {
        if (elem == null) {
            return;
        }
        this.link(elem, prio);
        this.updateReservedSize(-len);
        this.updateTotalSize(len);
        this.incrementEnqueuedCounts(prio);
        this.updateMinEnqueueTime();
    }

    synchronized void reenqueue(QElement elem, int prio, long len, boolean preserveRedelivery) {
        if (elem == null) {
            return;
        }
        byte reenqueues = 0;
        IMgram m = (IMgram)elem.getPayload();
        if (m != null) {
            reenqueues = m.getReenqueueCount();
        }
        if (!preserveRedelivery) {
            if (reenqueues < 127) {
                reenqueues = (byte)(reenqueues + 1);
            }
            if (m != null) {
                m.setSuccessor(true);
                m.setReenqueueCount(reenqueues);
            }
        } else {
            reenqueues = m != null && m.isSuccessor() ? (reenqueues == 0 ? (byte)1 : reenqueues) : (byte)0;
        }
        elem.setReenqueueCount(reenqueues);
        this.relink(elem, prio);
        this.incrementEnqueuedCounts(prio);
        this.updateTotalSize(len);
        this.updateMinEnqueueTime();
    }

    protected synchronized void dequeue(QElement elem) {
        this.delink(elem);
        this.decrementEnqueuedCounts(elem.getPriority());
        this.updateTotalSize(-elem.getPayloadSize());
        this.updateMinEnqueueTime();
    }

    synchronized Object dequeue(int prio) {
        if (prio < 0 || prio > this.m_numPriorities) {
            return null;
        }
        if (this.m_elementsEnqueuedCount[prio] == 0) {
            return null;
        }
        QToken token = this.m_queuePriorityToken[prio + 1];
        QElement elem = token.m_next;
        this.dequeue(elem);
        return elem;
    }

    synchronized Object dequeue() {
        if (this.m_totalEnqueuedCount == 0) {
            return null;
        }
        Object obj = this.dequeue(this.m_highestNonEmptyPriority);
        return obj;
    }

    synchronized Object dequeue(long tracking) {
        if (this.m_totalEnqueuedCount == 0) {
            return null;
        }
        QElement elem = this.m_queuePriorityToken[this.m_highestNonEmptyPriority + 1];
        while (elem != null) {
            if (elem instanceof QToken) {
                elem = elem.m_next;
                continue;
            }
            if (elem.getTracking() == tracking) break;
            elem = elem.m_next;
        }
        if (elem == null) {
            return null;
        }
        this.dequeue(elem);
        return elem;
    }

    void notifyMaxQueueSizeChanged() {
        this.notifySpaceAvailable();
    }

    public synchronized boolean reserve(IMgram m) {
        return this.reserve(m.getEnqueuedSize());
    }

    public synchronized boolean reserve(int size) {
        long sz = size;
        if (sz < 0L) {
            return this.updateReservedSizeWithDebug(size, sz);
        }
        if (this.getCurrentTotalSize() + sz <= this.m_maxQueueSize) {
            return this.updateReservedSizeWithDebug(size, sz);
        }
        if (this.DEBUG) {
            this.debug("Space not available for " + size + " bytes.");
        }
        return false;
    }

    private boolean updateReservedSizeWithDebug(int size, long sz) {
        this.updateReservedSize(sz);
        if (this.DEBUG) {
            this.debug("Reserved " + size + " bytes.");
        }
        return true;
    }

    public synchronized boolean forceReserve(IMgram m) {
        return this.forceReserve(m.getEnqueuedSize());
    }

    public synchronized boolean forceReserve(int size) {
        if (this.DEBUG) {
            this.debug("forceReserve " + size + ", Size " + this.getCurrentEnqueuedSize() + ", Reserved " + this.getCurrentReservedSize() + ", Max " + this.getMaxQueueSizeInBytes() + " (all values in bytes)");
        }
        long sz = size;
        long newSize = this.getCurrentEnqueuedSize() + this.getCurrentReservedSize() + sz;
        if (newSize < 0L || newSize > Long.MAX_VALUE) {
            throw new EAssertFailure("Queue size overFlow: msg size= " + size + " bytes, new size= " + newSize + " bytes, max queue size= " + this.getMaxQueueSizeInBytes() + " bytes");
        }
        this.updateReservedSize(sz);
        boolean overflow = false;
        if (newSize > this.getMaxQueueSizeInBytes()) {
            overflow = true;
        }
        if (this.DEBUG) {
            this.debug("ForceReserved " + size + " bytes. overflow= " + overflow);
        }
        return overflow;
    }

    public synchronized void unreserve(int size) {
        this.reserve(-size);
    }

    synchronized Object peek(int prio) {
        if (prio < 0 || prio > this.m_numPriorities) {
            return null;
        }
        if (this.m_elementsEnqueuedCount[prio] == 0) {
            return null;
        }
        QToken token = this.m_queuePriorityToken[prio + 1];
        QElement elem = token.m_next;
        return elem;
    }

    synchronized Object peekWithCopy(int prio) {
        if (prio < 0 || prio > this.m_numPriorities) {
            return null;
        }
        if (this.m_elementsEnqueuedCount[prio] == 0) {
            return null;
        }
        QToken token = this.m_queuePriorityToken[prio + 1];
        QElement elem = token.m_next;
        QElement clone = (QElement)elem.clone();
        return clone;
    }

    public synchronized void clear() throws InterruptedException {
        if (this.m_totalEnqueuedCount == 0) {
            return;
        }
        QElement elem = this.m_queuePriorityToken[this.m_highestNonEmptyPriority + 1].m_next;
        int prio = this.m_highestNonEmptyPriority;
        QElement prev = null;
        QElement next = null;
        while (elem != null) {
            if (elem instanceof QToken) {
                --prio;
                elem = elem.m_next;
                continue;
            }
            prev = elem.getPrevious();
            next = elem.getNext();
            prev.setNext(next);
            next.setPrevious(prev);
            elem.recycle();
            elem = next;
            int n = prio;
            this.m_elementsEnqueuedCount[n] = this.m_elementsEnqueuedCount[n] - 1;
            --this.m_totalEnqueuedCount;
        }
        this.m_totalEnqueuedCount = 0;
        this.setCurrentEnqueuedSize(0L);
        for (int i = 0; i < this.m_numPriorities; ++i) {
            this.m_elementsEnqueuedCount[i] = 0;
        }
        this.m_highestNonEmptyPriority = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCurrentEnqueuedSize() {
        Object object = this.m_qSizeLock;
        synchronized (object) {
            return this.m_totalEnqueuedSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCurrentEnqueuedSize(long size) {
        Object object = this.m_qSizeLock;
        synchronized (object) {
            this.m_totalEnqueuedSize = size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCurrentReservedSize() {
        Object object = this.m_qSizeLock;
        synchronized (object) {
            return this.m_reservedSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCurrentTotalSize() {
        Object object = this.m_qSizeLock;
        synchronized (object) {
            return this.m_totalEnqueuedSize + this.m_reservedSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long getCurrentAvailableSize() {
        Object object = this.m_qSizeLock;
        synchronized (object) {
            long avail = Math.max(this.m_maxQueueSize - this.m_totalEnqueuedSize - this.m_reservedSize, 0L);
            return avail;
        }
    }

    public synchronized long getMaxQueueSizeInBytes() {
        return this.m_maxQueueSize;
    }

    public synchronized int getMaxQueueSizeInKiloBytes() {
        return (int)(this.m_maxQueueSize / 1024L);
    }

    public synchronized void setMaxQueueSizeInBytes(long maxQueueSize) {
        this.m_maxQueueSize = Math.abs(maxQueueSize);
        this.notifyMaxQueueSizeChanged();
    }

    public synchronized void setMaxQueueSizeInKiloBytes(int maxQueueSize) {
        long max = Math.abs((long)maxQueueSize);
        this.m_maxQueueSize = max > 0x1FFFFFFFFFFFFFL ? Long.MAX_VALUE : max * 1024L;
        this.notifyMaxQueueSizeChanged();
    }

    public synchronized int getCurrentEnqueuedCount() {
        return this.m_totalEnqueuedCount;
    }

    public int getCurrentEnqueuedCountUnsynchronized() {
        return this.m_totalEnqueuedCount;
    }

    public synchronized boolean isEmpty() {
        return this.m_totalEnqueuedCount == 0;
    }

    String getQueueAddress() {
        return "$Q." + this.m_qName;
    }

    public synchronized void dump() {
        this.debug("\nElement dump of queue " + this.m_qName + ":\n");
        this.debug("\ttotal # of enqueued elements = " + this.m_totalEnqueuedCount + "\n");
        this.debug("\tnumber of priorities = " + this.m_numPriorities + "\n");
        this.debug("\telements:\n");
        QElement elem = this.m_queuePriorityToken[this.m_numPriorities];
        while (elem != null) {
            this.debug("\t\t" + ((QElement)elem).toString() + "\n");
            elem = elem.m_next;
        }
        this.debug("\ttokens:\n");
        for (int i = 0; i <= this.m_numPriorities; ++i) {
            this.debug("\t\t" + this.m_queuePriorityToken[i] + "\n");
        }
        this.debug("\n");
    }

    protected synchronized void link(QElement elem, int prio) {
        QToken end = this.m_queuePriorityToken[prio];
        QElement e = end.m_prev;
        e.m_next = elem;
        elem.m_prev = e;
        end.m_prev = elem;
        elem.m_next = end;
    }

    private synchronized void relink(QElement elem, int prio) {
        QToken prev = this.m_queuePriorityToken[prio + 1];
        QElement next = prev.m_next;
        prev.m_next = elem;
        elem.m_prev = prev;
        next.m_prev = elem;
        elem.m_next = next;
    }

    private synchronized void delink(QElement elem) {
        QElement next;
        QElement prev = elem.m_prev;
        prev.m_next = next = elem.m_next;
        next.m_prev = prev;
    }

    protected synchronized void incrementEnqueuedCounts(int prio) {
        ++this.m_totalEnqueuedCount;
        int n = prio;
        this.m_elementsEnqueuedCount[n] = this.m_elementsEnqueuedCount[n] + 1;
        if (prio > this.m_highestNonEmptyPriority) {
            this.m_highestNonEmptyPriority = prio;
        }
    }

    private synchronized void decrementEnqueuedCounts(int prio) {
        --this.m_totalEnqueuedCount;
        int n = prio;
        this.m_elementsEnqueuedCount[n] = this.m_elementsEnqueuedCount[n] - 1;
        if (prio == this.m_highestNonEmptyPriority) {
            while (this.m_highestNonEmptyPriority != -1 && this.m_elementsEnqueuedCount[this.m_highestNonEmptyPriority] == 0) {
                --this.m_highestNonEmptyPriority;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateReservedSize(long sz) {
        Object object = this.m_qSizeLock;
        synchronized (object) {
            this.m_reservedSize = Math.max(this.m_reservedSize + sz, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTotalSize(long sz) {
        Object object = this.m_qSizeLock;
        synchronized (object) {
            this.m_totalEnqueuedSize += sz;
        }
    }

    abstract void notifySpaceAvailable();

    protected synchronized void updateMinEnqueueTime() {
        if (this.m_totalEnqueuedCount == 0) {
            this.m_minEnqueueTime = 0L;
            return;
        }
        long min = 0L;
        for (int i = this.m_highestNonEmptyPriority; i >= 0; --i) {
            QElement elem;
            long enqtm;
            if (this.m_elementsEnqueuedCount[i] == 0 || (enqtm = (elem = this.m_queuePriorityToken[i + 1].m_next).getEnqueueTime()) == 0L) continue;
            if (min == 0L) {
                min = enqtm;
                continue;
            }
            if (min <= enqtm) continue;
            min = enqtm;
        }
        this.m_minEnqueueTime = min;
    }

    public long getMinEnqueueTime() {
        return this.m_minEnqueueTime;
    }
}

