/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.client.EXADuplicateXidException;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.ISubject;
import progress.message.zclient.Message;
import progress.message.zclient.Session;
import progress.message.zclient.SessionConfig;

public final class BeginGlobalTransaction
implements IMessageHandler {
    private AgentRegistrar m_reg;

    BeginGlobalTransaction(AgentRegistrar reg) {
        this.m_reg = reg;
    }

    @Override
    public void handleMessage(Session s, Envelope env) {
        try {
            Message req = env.getMessage();
            ISubject subj = req.getSubject();
            Object xid = req.readObject();
            String uid = subj.extractSubjectLevel(2);
            String appid = subj.extractSubjectLevel(3);
            Message rep = new Message();
            try {
                int tid = this.m_reg.getTransactionMgr().beginTxn(uid, appid, xid);
                rep.writeShort(0);
                rep.writeInt(tid);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            catch (EXADuplicateXidException e) {
                rep.writeShort(11);
                rep.writeInt(-1);
            }
            s.reply(rep, env);
        }
        catch (IOException e) {
            if (!Broker.isInShutdown()) {
                SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
            }
        }
        catch (ClassNotFoundException e) {
            SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
        }
    }
}

