/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.jms.TopicConnection;
import progress.message.broker.AgentConnection;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.BrokerLicenseMgr;
import progress.message.broker.Config;
import progress.message.broker.GetStats;
import progress.message.broker.INeighbor;
import progress.message.broker.InterbrokerHook;
import progress.message.broker.StatsManager;
import progress.message.broker.loadbalancing.IBrokerContext;

public class BrokerContext
implements IBrokerContext {
    private boolean m_isLocal;
    private INeighbor m_neighbor;
    private StatsManager m_stats;
    private HashMap<String, Integer> m_indexByAcceptorName = new HashMap();

    BrokerContext() {
        this.m_isLocal = true;
        this.m_stats = AgentRegistrar.getAgentRegistrar().getStatsManager();
    }

    BrokerContext(INeighbor n) {
        this.m_isLocal = false;
        this.m_neighbor = n;
    }

    @Override
    public String getBrokerName() {
        if (this.m_isLocal) {
            return Config.BROKER_NAME;
        }
        return this.m_neighbor.getName();
    }

    @Override
    public String getAcceptorURLs(String acceptorName) {
        if (acceptorName == null) {
            return null;
        }
        if (this.m_isLocal) {
            return Broker.getBroker().getAcceptorURLs(acceptorName);
        }
        return this.m_neighbor.getAcceptorURLs(acceptorName);
    }

    @Override
    public String getClusterName() {
        if (!Config.ENABLE_INTERBROKER || !InterbrokerHook.isSet()) {
            return null;
        }
        if (this.m_isLocal) {
            String[] s = InterbrokerHook.getCollectiveNames();
            return s[0];
        }
        return this.m_neighbor.getCollectiveName();
    }

    @Override
    public int getLoadBalancingWeight() {
        if (!Config.ENABLE_INTERBROKER || !InterbrokerHook.isSet()) {
            return 1;
        }
        if (this.m_isLocal) {
            return Config.LOAD_BALANCING_WEIGHT;
        }
        return this.m_neighbor.getWeight();
    }

    public long getMetric(String name) {
        if (this.m_isLocal) {
            int metricId = GetStats.getMetricId(name);
            if (metricId > 0) {
                return this.m_stats.getMetric(metricId);
            }
            return -1L;
        }
        return -1L;
    }

    public Enumeration getMetricKeys() {
        if (this.m_isLocal) {
            return GetStats.getMetricKeys().keys();
        }
        return null;
    }

    public TopicConnection createTopicConnection() {
        return this.retrieveConnection();
    }

    public TopicConnection createTopicConnection(String username, String password) {
        return this.retrieveConnection();
    }

    private TopicConnection retrieveConnection() {
        if (!this.m_isLocal) {
            return null;
        }
        return null;
    }

    @Override
    public IBrokerContext[] getNeighborBrokerContexts() {
        return this.getNeighborBrokerContexts(false);
    }

    @Override
    public IBrokerContext[] getNeighborBrokerContexts(boolean excludeWeightless) {
        if (!this.m_isLocal) {
            return null;
        }
        if (!Config.ENABLE_INTERBROKER || !InterbrokerHook.isSet()) {
            return null;
        }
        INeighbor[] nlist = InterbrokerHook.getActiveNeighbors();
        Vector<BrokerContext> v = new Vector<BrokerContext>();
        int howmany = nlist.length;
        for (int i = 0; i < howmany; ++i) {
            if (excludeWeightless && nlist[i].getWeight() <= 0) continue;
            v.add(new BrokerContext(nlist[i]));
        }
        return v.toArray(new BrokerContext[v.size()]);
    }

    @Override
    public int getConnectionCount() {
        if (this.m_isLocal) {
            return AgentConnection.getClientConnectionCount();
        }
        return this.m_neighbor.getNeighborConnectionCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String selectRedirectURL(String acceptorName) {
        if (acceptorName == null) {
            return null;
        }
        String redirectURL = null;
        try {
            String urlsByName = null;
            urlsByName = this.m_isLocal ? Broker.getBroker().getAcceptorURLs(acceptorName) : this.m_neighbor.getAcceptorURLs(acceptorName);
            if (urlsByName == null || urlsByName.indexOf(",") < 0) {
                String string = redirectURL = urlsByName;
                return string;
            }
            Object object = this.m_indexByAcceptorName;
            synchronized (object) {
                Integer savedIndex = this.m_indexByAcceptorName.get(acceptorName);
                int acceptorIndex = savedIndex == null ? 0 : savedIndex;
                String[] urls = urlsByName.split(",");
                redirectURL = urls[acceptorIndex %= urls.length];
                this.m_indexByAcceptorName.put(acceptorName, ++acceptorIndex);
            }
            object = redirectURL;
            return object;
        }
        finally {
            if (redirectURL != null && !this.m_isLocal) {
                this.m_neighbor.incrementNeighborConnectionCount();
            }
        }
    }

    @Override
    public int getSessionCount() {
        if (BrokerLicenseMgr.getLicenseMgr().isEnterpriseEdition()) {
            if (this.m_isLocal) {
                return AgentConnection.getJMSSessionCount();
            }
            return this.m_neighbor.getSessionCount();
        }
        return -1;
    }

    @Override
    public int getNonDurableTopicSubscriberCount() {
        if (BrokerLicenseMgr.getLicenseMgr().isEnterpriseEdition()) {
            if (this.m_isLocal) {
                return AgentConnection.getNonDurableTopicSubscriberCount();
            }
            return this.m_neighbor.getNonDurableSubscribersCount();
        }
        return -1;
    }

    @Override
    public int getDurableTopicSubscriberCount() {
        if (BrokerLicenseMgr.getLicenseMgr().isEnterpriseEdition()) {
            if (this.m_isLocal) {
                return AgentConnection.getDurableTopicSubscriberCount();
            }
            return this.m_neighbor.getDurableSubscribersCount();
        }
        return -1;
    }

    @Override
    public int getQueueReceiverCount() {
        if (BrokerLicenseMgr.getLicenseMgr().isEnterpriseEdition()) {
            if (this.m_isLocal) {
                return AgentConnection.getQueueReceiverCount();
            }
            return this.m_neighbor.getQueueReceiversCount();
        }
        return -1;
    }

    @Override
    public int getQueueBrowserCount() {
        if (BrokerLicenseMgr.getLicenseMgr().isEnterpriseEdition()) {
            if (this.m_isLocal) {
                return AgentConnection.getQueueBrowserCount();
            }
            return this.m_neighbor.getQueueBrowsersCount();
        }
        return -1;
    }
}

