/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.util.Collection;
import java.util.Vector;

public class BrokerJob {
    private int m_maxReplyCount;
    private int m_currentReplyCount;
    private boolean m_wasCancelled;
    private boolean m_wasCompleted = false;
    private Vector m_sources = null;
    private Vector m_replies = new Vector();

    public BrokerJob(int replyCount) {
        this.m_maxReplyCount = replyCount;
    }

    public BrokerJob(Vector sources) {
        if (sources == null) {
            throw new NullPointerException("sources");
        }
        this.m_sources = sources;
    }

    public void enqueueReply(Object reply) {
        this.enqueueReply(reply, null);
    }

    public synchronized void enqueueReply(Object reply, Object source) {
        if (this.m_sources != null) {
            if (this.m_sources.contains(source)) {
                this.m_sources.remove(source);
                this.m_replies.add(reply);
                this.notifyAll();
            }
        } else {
            this.m_replies.add(reply);
            ++this.m_currentReplyCount;
            this.notifyAll();
        }
    }

    public synchronized void cancel() {
        this.m_wasCancelled = true;
        this.notifyAll();
    }

    public synchronized void cancel(Object source) {
        if (this.m_sources != null) {
            while (this.m_sources.contains(source)) {
                this.m_sources.remove(source);
            }
        }
        this.m_wasCancelled = true;
        this.notifyAll();
    }

    public synchronized Collection join() throws InterruptedException {
        if (this.m_sources == null) {
            while (this.m_currentReplyCount < this.m_maxReplyCount && !this.m_wasCompleted && !this.m_wasCancelled) {
                this.wait();
            }
        } else {
            while (!this.m_sources.isEmpty() && !this.m_wasCompleted) {
                this.wait();
            }
        }
        return (Collection)this.m_replies.clone();
    }

    public synchronized boolean wasCancelled() {
        return this.m_wasCancelled;
    }

    public synchronized void setCompleted() {
        this.m_wasCompleted = true;
        this.notifyAll();
    }
}

