/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import progress.message.broker.Config;
import progress.message.broker.RoutingConnectionInfo;
import progress.message.zclient.FastVector;
import progress.message.zclient.IQop;
import progress.message.zclient.ISubject;
import progress.message.zclient.ISubjectMatchObject;
import progress.message.zclient.QOP;
import progress.message.zclient.SearchResults;

public class BrokerSearchResults
extends SearchResults {
    private FastVector m_subscriptionVectors;
    private HashMap m_multiSubjectResults;
    public IQop m_qop = null;
    FastVector m_userAcls = null;
    FastVector m_groupAcls = null;
    private ISubject m_searchSubject = null;
    private static final boolean DEBUG = false;
    int m_subCount = 0;
    private boolean m_qopQuery = false;
    public HashMap m_subjectQOPTable = null;
    private SubscriptionsResult m_subscriptionResult;
    private long m_compactionVersion = -1L;
    private BrokerSearchResults m_parent = null;
    private RoutingConnectionInfo m_routingNode = null;

    public BrokerSearchResults() {
        if (Config.ENABLE_SECURITY) {
            this.resetUnnecessaryStructures();
        }
        this.m_subscriptionResult = new SubscriptionsResult();
    }

    @Override
    public void setSubject(ISubject subject) {
        this.m_searchSubject = subject;
    }

    @Override
    public SearchResults newResults() {
        BrokerSearchResults bsr = new BrokerSearchResults();
        if (this.m_qopQuery) {
            bsr.setQOPQuery();
        }
        bsr.m_searchSubject = this.m_searchSubject;
        return bsr;
    }

    @Override
    public void addLocalObjects(ISubject s, Vector subscriptionVector) {
        if (this.m_subscriptionVectors == null) {
            this.m_subscriptionVectors = new FastVector();
        }
        this.m_subscriptionVectors.addElement(subscriptionVector);
        this.m_subCount += subscriptionVector.size();
    }

    @Override
    public void copyInto(ISubject subject, SearchResults dest, boolean fromCache) {
        BrokerSearchResults d = (BrokerSearchResults)dest;
        if (d.m_searchSubject.isMultiSubject() && !this.m_searchSubject.isMultiSubject()) {
            if (d.m_multiSubjectResults == null) {
                d.m_multiSubjectResults = new HashMap(d.m_searchSubject.getMultiSubjectCount());
            }
            d.m_multiSubjectResults.put(this.m_searchSubject, this);
        } else {
            if (Config.ENABLE_SECURITY) {
                d.m_groupAcls = this.m_groupAcls;
                d.m_qop = this.m_qop;
                d.m_subjectQOPTable = this.m_subjectQOPTable;
                d.m_userAcls = this.m_userAcls;
            }
            d.m_searchSubject = this.m_searchSubject;
            d.m_subCount = this.m_subCount;
            d.m_subscriptionVectors = this.m_subscriptionVectors;
            d.m_multiSubjectResults = this.m_multiSubjectResults;
            d.m_compactionVersion = this.m_compactionVersion;
            d.m_routingNode = this.m_routingNode;
            d.m_subscriptionResult.m_subjectMatches = this.m_subscriptionResult.m_subjectMatches;
        }
    }

    @Override
    public void setQOP(ISubject subject, QOP q) {
        if (this.m_qop == null || this.m_qop.getProtection() < q.getProtection() || subject.hasTemporary()) {
            this.m_qop = q;
        }
    }

    public void setQOPQuery() {
        this.m_qopQuery = true;
        this.m_subjectQOPTable = new HashMap();
    }

    public final SubjectSubscriptionMatches createSubjectSubscriptionMatches(ISubject subject, FastVector matches) {
        return new SubjectSubscriptionMatches(subject, matches);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void traversalComplete(long version) {
        if (version <= this.m_compactionVersion && this.m_subscriptionResult != null) {
            return;
        }
        this.m_compactionVersion = version;
        this.m_parent = null;
        if (this.m_searchSubject.isMultiSubject()) {
            this.m_subCount = 0;
            this.checkSubscriptionResult();
            this.m_subscriptionResult.m_subjectMatches = new ArrayList(this.m_searchSubject.getMultiSubjectCount());
            for (ISubject s : this.m_multiSubjectResults.keySet()) {
                BrokerSearchResults toCopy = (BrokerSearchResults)this.m_multiSubjectResults.get(s);
                BrokerSearchResults aResult = (BrokerSearchResults)toCopy.newResults();
                toCopy.copyInto(toCopy.m_searchSubject, aResult, false);
                aResult.traversalComplete(version);
                if (aResult.m_subscriptionResult.m_subjectMatches != null && aResult.m_subscriptionResult.m_subjectMatches.size() > 0) {
                    this.m_subscriptionResult.m_subjectMatches.addAll(aResult.m_subscriptionResult.m_subjectMatches);
                }
                this.m_subCount += aResult.m_subCount;
                if (!Config.ENABLE_SECURITY) continue;
                if (this.m_qop == null) {
                    this.m_qop = aResult.m_qop;
                } else if (aResult.m_qop != null && aResult.m_qop.getProtection() > this.m_qop.getProtection()) {
                    this.m_qop = aResult.m_qop;
                }
                if (this.m_subjectQOPTable == null) {
                    this.m_subjectQOPTable = new HashMap(this.m_searchSubject.getMultiSubjectCount());
                }
                this.m_subjectQOPTable.put(s, aResult.m_qop);
            }
        } else {
            FastVector target = new FastVector(this.m_subCount);
            this.checkSubscriptionResult();
            this.m_subscriptionResult.m_subjectMatches = new ArrayList(1);
            this.m_subscriptionResult.m_subjectMatches.add(new SubjectSubscriptionMatches(this.m_searchSubject, target));
            this.m_subCount = 0;
            if (this.m_subscriptionVectors == null) {
                return;
            }
            for (int i = 0; i < this.m_subscriptionVectors.m_count; ++i) {
                Vector subscriptionVector;
                Vector vector = subscriptionVector = (Vector)this.m_subscriptionVectors.m_data[i];
                synchronized (vector) {
                    for (int j = 0; j < subscriptionVector.size(); ++j) {
                        ISubjectMatchObject match = (ISubjectMatchObject)subscriptionVector.elementAt(j);
                        target.addElement(match);
                        ++this.m_subCount;
                    }
                    continue;
                }
            }
        }
    }

    private void checkSubscriptionResult() {
        if (this.m_subscriptionResult == null) {
            throw new NullPointerException("SubscriptionsResult m_subscriptionResult is null at " + this.getClass().getName() + ".traversalComplete(long version)");
        }
    }

    public SubscriptionsResult getSubscriptions() {
        return this.m_subscriptionResult;
    }

    public final void reset() {
        this.m_subscriptionResult.m_calculatedBatch = false;
        this.m_subscriptionVectors = null;
        this.m_compactionVersion = -1L;
        if (Config.ENABLE_SECURITY) {
            this.m_qopQuery = false;
            this.m_subjectQOPTable = null;
            this.resetUnnecessaryStructures();
        }
    }

    private void resetUnnecessaryStructures() {
        this.m_qop = null;
        this.m_userAcls = new FastVector();
        this.m_groupAcls = new FastVector();
    }

    public String toString() {
        String ret = "";
        if (this.m_subscriptionResult != null && this.m_subscriptionResult.m_subjectMatches != null) {
            Iterator i = this.m_subscriptionResult.m_subjectMatches.iterator();
            ret = ret + "Search Result Subjecriptions: \n";
            while (i.hasNext()) {
                SubjectSubscriptionMatches s = (SubjectSubscriptionMatches)i.next();
                ret = ret + "Subject: " + s.getSubject() + " matches: \n";
                FastVector matches = s.getMatches();
                for (int m = 0; m < matches.m_count; ++m) {
                    ret = ret + m + ": " + matches.m_data[m] + "\n";
                }
            }
        } else {
            ret = ret + "Search Result Subjecriptions: No Subscriptions.\n";
        }
        return ret;
    }

    @Override
    public void setSearchParent(SearchResults sr) {
        this.m_parent = (BrokerSearchResults)sr;
    }

    @Override
    public SearchResults getSearchParent() {
        return this.m_parent;
    }

    @Override
    public void addRoutingNode(Object rn) {
        RoutingConnectionInfo routingNode;
        this.m_routingNode = routingNode = (RoutingConnectionInfo)rn;
    }

    public RoutingConnectionInfo getRoutingNode() {
        return this.m_routingNode;
    }

    public final class SubscriptionsResult {
        public ArrayList m_subjectMatches;
        private boolean m_calculatedBatch = false;
        private boolean m_isBatchable = true;
        private boolean m_isBatchAtomic = true;
        private boolean m_isNPReplAtomic = true;

        private void calculateBatchFlags() {
            if (!this.m_calculatedBatch) {
                this.m_isBatchable = true;
                this.m_isBatchAtomic = true;
                this.m_isNPReplAtomic = true;
                this.m_calculatedBatch = true;
                for (int m = 0; m < this.m_subjectMatches.size(); ++m) {
                    FastVector subs = ((SubjectSubscriptionMatches)this.m_subjectMatches.get(m)).m_matches;
                    for (int s = 0; s < subs.m_count; ++s) {
                        if (this.m_isBatchable) {
                            this.m_isBatchable = ((ISubjectMatchObject)subs.m_data[s]).isBatchable();
                        }
                        if (this.m_isBatchable) {
                            if (this.m_isBatchAtomic) {
                                this.m_isBatchAtomic = ((ISubjectMatchObject)subs.m_data[s]).isBatchAtomic(true);
                            }
                            if (!this.m_isNPReplAtomic) continue;
                            this.m_isNPReplAtomic = ((ISubjectMatchObject)subs.m_data[s]).isBatchAtomic(false);
                            continue;
                        }
                        this.m_isBatchAtomic = false;
                        this.m_isNPReplAtomic = false;
                        return;
                    }
                }
            }
        }

        final boolean isBatchable() {
            this.calculateBatchFlags();
            return this.m_isBatchable;
        }

        final boolean isBatchAtomic(boolean isNPReplAtomic) {
            this.calculateBatchFlags();
            if (isNPReplAtomic) {
                return this.m_isNPReplAtomic;
            }
            return this.m_isBatchAtomic;
        }
    }

    public final class SubjectSubscriptionMatches {
        private FastVector m_matches;
        private ISubject m_subject;

        public SubjectSubscriptionMatches(ISubject subject, FastVector matches) {
            this.m_matches = matches;
            this.m_subject = subject;
        }

        public final ISubject getSubject() {
            return this.m_subject;
        }

        public final FastVector getMatches() {
            return this.m_matches;
        }
    }
}

