/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.SyncTxnEvt;
import progress.message.broker.TxnAckPool;
import progress.message.util.StreamUtil;
import progress.message.util.StringUtil;

public class ChannelTxnSyncEvt
extends SyncTxnEvt {
    private String m_channelId;
    private int m_channelStatus;

    ChannelTxnSyncEvt(int tid, int previousTid, String uid, String appid, short state, String userXid, String noDupCommitId, long noDupTimestamp, String channelId, int channelStatus, TxnAckPool txnAckPool, byte persistenceType, long requestId, long lifespan, boolean chained, short replyStatus) {
        super(tid, previousTid, uid, appid, state, userXid, noDupCommitId, noDupTimestamp, txnAckPool, persistenceType, requestId, lifespan, chained, replyStatus);
        this.m_channelId = channelId;
        this.m_channelStatus = channelStatus;
    }

    ChannelTxnSyncEvt(short type) {
        super(type);
        this.m_channelId = "";
        this.m_channelStatus = 14;
    }

    String getChannelId() {
        return this.m_channelId;
    }

    int getChannelStatus() {
        return this.m_channelStatus;
    }

    @Override
    public short type() {
        return 90;
    }

    @Override
    protected int memSizeBody() {
        int channelIdLength = this.m_channelId.length() << 1;
        return super.memSizeBody() + this.baseSize();
    }

    @Override
    public int streamSizeBody() {
        return super.streamSizeBody() + this.baseSize();
    }

    @Override
    public int serializedSizeBody() {
        return super.serializedSizeBody() + this.baseSize();
    }

    private int baseSize() {
        byte[] utfChannelId;
        block3: {
            utfChannelId = null;
            try {
                utfChannelId = StringUtil.stringToUTF(this.m_channelId);
            }
            catch (UTFDataFormatException e) {
                if (!this.DEBUG) break block3;
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
        if (utfChannelId == null) {
            throw new NullPointerException("utfChannelId is null at " + this.getClass().getName() + ".baseSize()");
        }
        return utfChannelId.length + 4;
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        byte[] utfChannelId = StringUtil.stringToUTF(this.m_channelId);
        int length = this.baseSize();
        super.writeBodyToLog(out, maxbytes - (long)length);
        this.writeBody(out, utfChannelId);
    }

    private void writeBody(OutputStream os, byte[] utfChannelID) throws IOException {
        StreamUtil.writeInt(this.m_channelStatus, os);
        os.write(utfChannelID);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        byte[] utfChannelId = StringUtil.stringToUTF(this.m_channelId);
        super.writeBodyToStream(os, tteTTLConvert);
        this.writeBody(os, utfChannelId);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        super.readBodyFromStream(in, tteTTLConvert);
        this.m_channelStatus = StreamUtil.readInt(in);
        this.m_channelId = StreamUtil.readUTF(in);
    }
}

