/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.CommitResult;
import progress.message.broker.Config;
import progress.message.broker.EInvalidAdminAddress;
import progress.message.broker.ETxnAborted;
import progress.message.broker.ETxnAccessViolation;
import progress.message.broker.ETxnNotFound;
import progress.message.broker.ETxnSequenceError;
import progress.message.client.EGeneralException;
import progress.message.db.EDatabaseException;
import progress.message.db.EInvalidConfiguration;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.ISubject;
import progress.message.zclient.Message;
import progress.message.zclient.Session;

public final class CommitChannelTransactionNoDup
implements IMessageHandler {
    private AgentRegistrar m_reg;

    CommitChannelTransactionNoDup(AgentRegistrar reg) {
        this.m_reg = reg;
    }

    @Override
    public void handleMessage(Session s, Envelope env) {
        block21: {
            boolean commitSuccess = false;
            boolean aborted = false;
            try {
                Message rep = new Message();
                Message req = env.getMessage();
                int tid = req.readInt();
                boolean startTx = req.readBoolean();
                String transactionId = req.readUTF();
                long lifespan = req.readLong();
                int channelState = req.readInt();
                String channelID = req.readUTF();
                int uid = AddrUtil.getUidFromAdmin(env.getSubject());
                try {
                    CommitResult result = this.m_reg.getTransactionMgr().commit(tid, uid, transactionId, lifespan, true, channelState, channelID);
                    int status = result.getResult();
                    switch (status) {
                        case 0: {
                            rep.writeShort(0);
                            commitSuccess = true;
                            break;
                        }
                        case 14: {
                            rep.writeShort(7);
                            aborted = true;
                            break;
                        }
                        case 13: {
                            rep.writeShort(13);
                            rep.writeLong(result.getTimeStamp() - System.currentTimeMillis());
                            aborted = true;
                            break;
                        }
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                catch (EDatabaseException e) {
                    rep.writeShort(8);
                    aborted = true;
                }
                catch (EInvalidConfiguration e) {
                    rep.writeShort(10);
                    aborted = true;
                }
                catch (IllegalArgumentException e) {
                    rep.writeShort(9);
                    aborted = true;
                }
                catch (ETxnNotFound e) {
                    rep.writeShort(2);
                }
                catch (ETxnSequenceError e) {
                    rep.writeShort(3);
                }
                catch (ETxnAborted e) {
                    rep.writeShort(4);
                    aborted = true;
                }
                catch (ETxnAccessViolation e) {
                    rep.writeShort(6);
                }
                catch (EGeneralException e) {
                    rep.writeShort(5);
                }
                catch (IOException e) {
                    rep.writeShort(1);
                }
                if ((commitSuccess || aborted) && startTx) {
                    int newTx = 0;
                    ISubject subj = req.getSubject();
                    String id = Config.getUidFromAdminSubject(subj);
                    String appid = Config.getAppidFromAdminSubject(subj);
                    newTx = this.m_reg.getTransactionMgr().beginTxn(tid, id, appid);
                    rep.writeInt(newTx);
                }
                s.reply(rep, env);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            catch (EInvalidAdminAddress e) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
            catch (IOException e) {
                if (Broker.isInShutdown()) break block21;
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
    }
}

