/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.mq.components.BrokerManagementNotificationsHelper;
import com.sonicsw.mq.mgmtapi.runtime.ICompactStatusConstants;

public class CompactStatusMonitor {
    CompactStatus currentStatus = CompactStatus.NOT_APPLICABLE;

    private CompactStatusMonitor() {
    }

    public static CompactStatusMonitor getInstance() {
        return CompactStatusMonitorLazyHolder.INSTANCE;
    }

    public static CompactStatus getStatus() {
        return CompactStatusMonitor.getInstance().currentStatus;
    }

    public static void setStatus(CompactStatus status) {
        CompactStatusMonitor.setStatus(status, null);
    }

    public static void setStatus(CompactStatus status, Throwable th) {
        if (CompactStatusMonitor.getInstance().currentStatus != status) {
            CompactStatusMonitor.getInstance().currentStatus = status;
            CompactStatusMonitor.fireNotification(status, th);
        }
    }

    static void fireNotification(CompactStatus status, Throwable th) {
        IComponentContext context = BrokerComponent.getComponentContext();
        if (context == null) {
            return;
        }
        int level = 3;
        if (status == CompactStatus.COMPLETED_FAILED) {
            level = 2;
        }
        BrokerManagementNotificationsHelper.sendDbCompactNotification(status.id, status.name, th, level);
    }

    public static class CompactStatus
    implements ICompactStatusConstants {
        final String name;
        final Integer id;
        public static final CompactStatus NOT_APPLICABLE = new CompactStatus(1, "Not applicable");
        public static final CompactStatus IN_PROGRESS = new CompactStatus(2, "in progress");
        public static final CompactStatus COMPLETED_OK = new CompactStatus(3, "successfull");
        public static final CompactStatus COMPLETED_FAILED = new CompactStatus(4, "failed");

        CompactStatus(int id, String name) {
            this.id = new Integer(id);
            this.name = name;
        }

        public Integer getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }
    }

    private static class CompactStatusMonitorLazyHolder {
        private static final CompactStatusMonitor INSTANCE = new CompactStatusMonitor();

        private CompactStatusMonitorLazyHolder() {
        }
    }
}

