/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.Properties;
import progress.message.broker.IBrokerConfig;
import progress.message.broker.prAccessor;
import progress.message.crypto.PBETool;

public class ConfigProperties
extends Properties
implements IBrokerConfig {
    private static volatile String configFile = "";
    private static volatile String configPwd = null;

    @Override
    public void set(String s) {
        configFile = s;
    }

    @Override
    public void set(String s, String pwd) {
        configFile = s;
        configPwd = pwd;
    }

    @Override
    public Properties getPropertyObject() throws Exception {
        try {
            InputStream fis = null;
            if (configPwd != null) {
                try {
                    byte[] inidata = PBETool.readPBEStream(configFile, configPwd);
                    fis = new ByteArrayInputStream(inidata);
                }
                catch (Exception e) {
                    throw new Exception("Unable to decrypt configuration file: " + e.getMessage());
                }
            } else {
                fis = new FileInputStream(configFile);
            }
            InputStreamReader fin = new InputStreamReader(fis);
            this.load(fin);
            fin.close();
            return this;
        }
        catch (FileNotFoundException ex1) {
            String mf = prAccessor.getString("STR044");
            Object[] ob = new Object[]{configFile};
            throw new FileNotFoundException(MessageFormat.format(mf, ob));
        }
        catch (Exception ex2) {
            throw ex2;
        }
    }

    public synchronized void load(InputStreamReader in) throws IOException {
        int ch = in.read();
        block5: while (true) {
            switch (ch) {
                case -1: {
                    return;
                }
                case 33: 
                case 35: {
                    while ((ch = in.read()) >= 0 && ch != 10 && ch != 13) {
                    }
                    continue block5;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    ch = in.read();
                    continue block5;
                }
            }
            StringBuffer key = new StringBuffer();
            while (ch >= 0 && ch != 61 && ch != 58 && ch != 32 && ch != 9 && ch != 10 && ch != 13) {
                key.append((char)ch);
                ch = in.read();
            }
            while (ch == 32 || ch == 9) {
                ch = in.read();
            }
            if (ch == 61 || ch == 58) {
                ch = in.read();
            }
            while (ch == 32 || ch == 9) {
                ch = in.read();
            }
            StringBuffer val = new StringBuffer();
            while (ch >= 0 && ch != 10 && ch != 13) {
                val.append((char)ch);
                ch = in.read();
            }
            this.put(key.toString(), val.toString());
        }
    }
}

