/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.util.Arrays;
import java.util.Comparator;
import progress.message.broker.LoadBalancer;
import progress.message.broker.loadbalancing.IBrokerContext;
import progress.message.broker.loadbalancing.IConnectionContext;

class ConnectionCountLoadBalancer
extends LoadBalancer {
    private boolean m_active = true;
    private static final Comparator<IBrokerContext> s_connectionCountComparator = new Comparator<IBrokerContext>(){

        @Override
        public int compare(IBrokerContext broker1, IBrokerContext broker2) {
            int weightedCount2;
            int weightedCount1 = broker1.getConnectionCount() / broker1.getLoadBalancingWeight();
            if (weightedCount1 < (weightedCount2 = broker2.getConnectionCount() / broker2.getLoadBalancingWeight())) {
                return -1;
            }
            if (weightedCount1 == weightedCount2) {
                return 0;
            }
            return 1;
        }
    };

    ConnectionCountLoadBalancer() {
        super("ConnectionCountLoadBalancer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean onConnect(IConnectionContext cctx) {
        int localWeightedConnectionCount;
        IBrokerContext[] activeNeighbors = this.m_brokerContext.getNeighborBrokerContexts(true);
        if (activeNeighbors == null || activeNeighbors.length == 0) {
            if (this.DEBUG) {
                this.debug("no redirection - no active neighbor");
            }
            return true;
        }
        if (activeNeighbors.length > 1) {
            Arrays.sort(activeNeighbors, s_connectionCountComparator);
        }
        if (activeNeighbors[0].getConnectionCount() < 0) {
            if (this.DEBUG) {
                this.debug("neighbor " + activeNeighbors[0].getBrokerName() + " is active but its connection is unknown..fall back to use " + this.getNext());
            }
            if (this.m_active) {
                this.m_active = false;
                BrokerComponent.getComponentContext().logMessage("Switching to " + this.getNext().getName() + " for connection load balanacing", 2);
            }
            return false;
        }
        if (!this.m_active) {
            this.m_active = true;
            BrokerComponent.getComponentContext().logMessage("Using " + this.getName() + " for connection load balanacing", 3);
        }
        String acceptorName = cctx.getAcceptorName();
        int localConnectionCount = this.m_brokerContext.getConnectionCount();
        int localLoadBalancingWeight = this.m_brokerContext.getLoadBalancingWeight();
        int n = localWeightedConnectionCount = localLoadBalancingWeight == 0 ? 0 : localConnectionCount / localLoadBalancingWeight;
        if (this.DEBUG) {
            this.debug("load balancing connection to acceptor " + acceptorName + " @ = " + this.m_brokerContext.getAcceptorURLs(acceptorName) + " on broker " + this.m_brokerContext.getBrokerName() + " [weight = " + localLoadBalancingWeight + "] [count = " + localConnectionCount + "] within cluster " + this.m_brokerContext.getClusterName() + " [active neighbor count = " + (activeNeighbors != null ? activeNeighbors.length : 0) + "]");
        }
        String redirectURL = null;
        try {
            for (IBrokerContext neighborCtx : activeNeighbors) {
                if (this.DEBUG) {
                    this.debug("processing broker " + neighborCtx.getBrokerName() + " [weight = " + neighborCtx.getLoadBalancingWeight() + "] connection count = " + neighborCtx.getConnectionCount() + " redirect URLs = " + neighborCtx.getAcceptorURLs(acceptorName));
                }
                if (localLoadBalancingWeight > 0 && neighborCtx.getConnectionCount() / neighborCtx.getLoadBalancingWeight() >= localWeightedConnectionCount) {
                    if (this.DEBUG) {
                        this.debug("no redirection - local broker has less (or equal) connections");
                    }
                } else {
                    redirectURL = neighborCtx.selectRedirectURL(acceptorName);
                    if (redirectURL == null) {
                        if (!this.DEBUG) continue;
                        this.debug("neighbor " + neighborCtx.getBrokerName() + " has no acceptor of the same name");
                        continue;
                    }
                    if (this.DEBUG) {
                        this.debug("redirecting to URL = " + redirectURL);
                    }
                }
                break;
            }
        }
        finally {
            cctx.setNewBrokerURL(redirectURL);
        }
        return true;
    }
}

