/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import progress.message.broker.AgentRegistrar;
import progress.message.broker.CounterEvt;
import progress.message.broker.SyncCounterEvt;

public class Counter {
    private int BLOCK = 256;
    private long WRAP = Long.MAX_VALUE;
    private long INITIAL = 0L;
    private short CATEGORY;
    private long m_currentBlock = -1L;
    private long m_last = -1L;
    private AgentRegistrar m_reg = null;

    public Counter(AgentRegistrar reg, short category, int block, long initial, long wrap) {
        this.m_reg = reg;
        this.CATEGORY = category;
        this.BLOCK = block;
        this.WRAP = wrap;
        this.INITIAL = initial;
        this.m_last = this.INITIAL - 1L;
        this.m_currentBlock = -1L;
    }

    void setLast(long last) {
        if (last >= this.INITIAL) {
            this.m_last = last;
        }
    }

    void skipToNextBlock() {
        long currentBlock = this.m_last / (long)this.BLOCK;
        this.m_last = currentBlock == this.WRAP / (long)this.BLOCK ? this.INITIAL - 1L : ++currentBlock * (long)this.BLOCK - 1L;
    }

    public void writeSyncRecord() {
        SyncCounterEvt evt = new SyncCounterEvt(this.CATEGORY, this.m_last);
        this.m_reg.getLogManager().addEvent(evt, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextCounter() {
        Counter counter = this;
        synchronized (counter) {
            boolean newBlock = false;
            if (this.m_last >= this.WRAP) {
                this.m_last = this.INITIAL;
                this.m_currentBlock = this.m_last / (long)this.BLOCK;
                newBlock = true;
            } else {
                ++this.m_last;
                if (this.m_currentBlock != this.m_last / (long)this.BLOCK) {
                    newBlock = true;
                    this.m_currentBlock = this.m_last / (long)this.BLOCK;
                }
            }
            if (newBlock) {
                CounterEvt evt = new CounterEvt(this.CATEGORY, this.m_last);
                this.m_reg.getLogManager().addEvent(evt, true);
                try {
                    this.m_reg.getLogManager().waitForFlush(evt);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        return this.m_last;
    }
}

