/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.util.StreamUtil;

class CounterEvt
extends LogEvent {
    private short m_category;
    private long m_id;

    CounterEvt(short category, long id) {
        this.m_category = category;
        this.m_id = id;
    }

    CounterEvt() {
    }

    @Override
    public short type() {
        return 102;
    }

    @Override
    protected int memSizeBody() {
        return 12;
    }

    @Override
    public int streamSizeBody() {
        return this.serializedSizeBody();
    }

    @Override
    public int serializedSizeBody() {
        return 12;
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        this.writeBody(out);
    }

    private void writeBody(OutputStream os) throws IOException {
        StreamUtil.writeShort(this.m_category, os);
        StreamUtil.writeLong(this.m_id, os);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeBody(os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        this.m_category = StreamUtil.readShort(in);
        this.m_id = StreamUtil.readLong(in);
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoCounter(this.m_category, this.m_id);
    }

    @Override
    public String toString() {
        return super.toString() + "Counter category:" + this.m_category + ", id=" + this.m_id;
    }
}

