/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.prAccessor;
import progress.message.client.EGeneralException;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Message;
import progress.message.zclient.Session;

public final class DelRouting
extends DebugObject
implements IMessageHandler {
    private AgentRegistrar m_reg;

    DelRouting(AgentRegistrar reg) {
        super(DebugState.GLOBAL_DEBUG_ON ? "DelRouting" : null);
        this.m_reg = reg;
    }

    @Override
    public void handleMessage(Session s, Envelope env) {
        if (this.DEBUG) {
            this.debug("Entered DelRouting");
        }
        try {
            Message msg = env.getMessage();
            Message rep = new Message();
            try {
                String routingNodeName = msg.readUTF();
                if (this.DEBUG) {
                    this.debug("routing node: " + routingNodeName);
                }
                if (!this.m_reg.getRoutingConfig().deleteRoutingConnection(routingNodeName)) {
                    EGeneralException e = new EGeneralException(1, prAccessor.getString("STR336"));
                    throw e;
                }
                rep.writeBoolean(true);
            }
            catch (Exception e) {
                rep = new Message();
                rep.writeBoolean(false);
                rep.writeObject(e);
            }
            s.reply(rep, env);
        }
        catch (EGeneralException e) {
            this.logNotShutdown(e);
        }
        catch (IOException e) {
            this.logNotShutdown(e);
        }
    }

    private <T0 extends IOException> void logNotShutdown(T0 e) {
        if (!Broker.isInShutdown()) {
            BrokerComponent.getComponentContext().logMessage(e, 2);
        }
    }
}

