/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.InterruptedIOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.DeleteEndEvt;
import progress.message.broker.DurableTrimEvt;
import progress.message.broker.ECannotFlushEvents;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.IClientContext;
import progress.message.broker.LogEvent;
import progress.message.broker.SyncSubscriptionDeleteEvt;
import progress.message.broker.durable.DurableTrimOp;
import progress.message.db.EDatabaseException;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;
import progress.message.zclient.IStateEvent;
import progress.message.zclient.SessionConfig;

public class DeleteSubscriptionManager
extends DebugObject {
    private HashMap m_deletions;
    private HashMap m_replicateOnlyDeletions;
    private AgentRegistrar m_reg = AgentRegistrar.getAgentRegistrar();
    private HashMap m_prevDeletions;
    private HashMap m_prevReplicateOnlyDeletions;
    private boolean m_inSync = false;
    private boolean m_syncAware = false;
    private LinkedList m_recoveringDeletes;
    private HashMap m_recoveringDeletesMap;

    public DeleteSubscriptionManager() {
        super(DebugState.GLOBAL_DEBUG_ON ? "DeleteSubscriptionManager" : null);
    }

    public void beginDeleteSubscription(IClientContext cc, long maxMessageId, boolean persistent, boolean replicateOnly) {
        long id = cc.getId();
        this.beginDeleteSubscription(cc, id, maxMessageId, persistent, replicateOnly);
    }

    public void beginDeleteSubscription(IClientContext cc, long id, long maxMessageId, boolean persistent, boolean replicateOnly) {
        this.beginDeleteSubscriptionInternal(cc, id, maxMessageId, persistent, replicateOnly);
        if (this.checkDebugFlags(64)) {
            this.debug("beginDeleteSubscription: submitting db delete for id= " + id + " maxMessageId= " + maxMessageId + " persistent= " + persistent + " replicateOnly= " + replicateOnly + " " + cc);
        }
        this.m_reg.getMsgSaver().deleteAllMsgs(id, maxMessageId, persistent, replicateOnly);
    }

    private void beginDeleteSubscriptionInternal(IClientContext cc, long id, long maxMessageId, boolean persistent, boolean replicateOnly) {
        if (cc != null) {
            cc.deletingAllMsgs(maxMessageId);
        }
        if (this.DEBUG) {
            this.debug("beginDeleteSubscriptionInternal starting: " + id + " MaxId: " + maxMessageId + " pers= " + persistent + " replOnly= " + replicateOnly + " " + cc);
        }
        if (!persistent) {
            return;
        }
        this.registerIdForDeletion(cc, id, maxMessageId, replicateOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerIdForDeletion(IClientContext cc, long id, long maxMessageId, boolean replicateOnly) {
        DeleteSubscriptionManager deleteSubscriptionManager = this;
        synchronized (deleteSubscriptionManager) {
            HashMap deletions = replicateOnly ? (this.m_replicateOnlyDeletions = this.initDeletionMap(this.m_replicateOnlyDeletions)) : (this.m_deletions = this.initDeletionMap(this.m_deletions));
            Long ID = new Long(id);
            Long currentMax = (Long)deletions.get(ID);
            if (currentMax == null || currentMax != null && maxMessageId > currentMax) {
                deletions.put(ID, new Long(maxMessageId));
                if (this.checkDebugFlags(64)) {
                    this.debug("registerIdForDeletion: added/replaced " + ID + ", " + maxMessageId + " oldMax= " + currentMax + " replOnly= " + replicateOnly + this.getDebugString() + " " + cc);
                }
            }
        }
    }

    private HashMap initDeletionMap(HashMap m_deletionsParam) {
        HashMap m_deletions = m_deletionsParam;
        if (m_deletions == null) {
            m_deletions = new HashMap();
        }
        return m_deletions;
    }

    public void endDeleteSubscription(long id, long maxMessageId, boolean replicateOnly) {
        if (this.DEBUG) {
            this.debug("endDeleteSubscription logging DeleteEndEvt: " + id + " MaxId: " + maxMessageId);
        }
        DeleteEndEvt evt = new DeleteEndEvt(id, maxMessageId);
        evt.setReplicateOnly(replicateOnly);
        this.m_reg.getLogManager().addEvent(evt, false);
        this.endDeleteSubscriptionInternal(id, maxMessageId, replicateOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean endDeleteSubscriptionInternal(long id, long maxMessageId, boolean replicateOnly) {
        boolean DEBUG1 = this.checkDebugFlags(64);
        DeleteSubscriptionManager deleteSubscriptionManager = this;
        synchronized (deleteSubscriptionManager) {
            HashMap deletions = replicateOnly ? this.m_replicateOnlyDeletions : this.m_deletions;
            if (deletions == null) {
                return false;
            }
            Long ID = new Long(id);
            Long currentID = (Long)deletions.get(ID);
            if (currentID == null) {
                if (this.DEBUG) {
                    this.debug("endDeleteSubscriptionInternal: clientId not found= " + id + " maxMessageId= " + maxMessageId + " replOnly= " + replicateOnly + this.getDebugString());
                }
                return false;
            }
            if (currentID <= maxMessageId) {
                deletions.remove(ID);
                if (this.checkDebugFlags(64)) {
                    this.debug("endDeleteSubscriptionInternal: removedId= " + id + " maxMessageId= " + maxMessageId + " registeredMaxId= " + currentID + " replOnly= " + replicateOnly + this.getDebugString());
                }
                return true;
            }
            if (this.DEBUG) {
                this.debug("endDeleteSubscriptionInternal: registered maxMessageId is greater than max deleted; cid= " + id + "  MaxMessageId In Db Op= " + maxMessageId + " registered maxMessageId= " + currentID + " replOnly= " + replicateOnly + this.getDebugString());
            }
            return true;
        }
    }

    public synchronized void recoverDeleteSubscriptions() {
        String data;
        Long maxMessageId;
        Set ids;
        String data2;
        if (this.checkDebugFlags(32) && (data2 = this.getDebugString(true)) != null) {
            this.debug("recoverDeleteSubscriptions starting: " + data2);
        }
        boolean hasPrev = false;
        if (this.m_prevDeletions != null) {
            hasPrev = true;
            this.m_deletions = this.mergeData(this.m_deletions, this.m_prevDeletions);
            this.m_prevDeletions = null;
        }
        if (this.m_prevReplicateOnlyDeletions != null) {
            hasPrev = true;
            this.m_replicateOnlyDeletions = this.mergeData(this.m_replicateOnlyDeletions, this.m_prevReplicateOnlyDeletions);
            this.m_prevReplicateOnlyDeletions = null;
        }
        if (this.checkDebugFlags(32) && hasPrev) {
            this.debug("recoverDeleteSubscriptions; after merging with prev: " + this.getDebugString());
        }
        this.applyRecoveringDeletes();
        this.m_inSync = false;
        this.m_syncAware = false;
        if (this.m_deletions != null) {
            ids = this.m_deletions.keySet();
            for (Long ID : ids) {
                maxMessageId = (Long)this.m_deletions.get(ID);
                this.debugSubmittingMsgSaverDeleteAll(ID, maxMessageId);
                this.m_reg.getMsgSaver().deleteAllMsgs(ID, maxMessageId, true, false);
            }
        }
        if (this.m_replicateOnlyDeletions != null) {
            ids = this.m_replicateOnlyDeletions.keySet();
            for (Long ID : ids) {
                maxMessageId = (Long)this.m_replicateOnlyDeletions.get(ID);
                this.debugSubmittingMsgSaverDeleteAll(ID, maxMessageId);
                this.m_reg.getMsgSaver().deleteAllMsgs(ID, maxMessageId, true, true);
            }
        }
        if (this.checkDebugFlags(32) && (data = this.getDebugString(true)) != null) {
            this.debug("recoverDeleteSubscriptions completed: " + data);
        }
    }

    private HashMap mergeData(HashMap m_replicateOnlyDeletions, HashMap m_prevReplicateOnlyDeletions) {
        if (m_replicateOnlyDeletions != null) {
            this.mergeDeletions(m_prevReplicateOnlyDeletions, m_replicateOnlyDeletions);
        }
        return m_prevReplicateOnlyDeletions;
    }

    private void debugSubmittingMsgSaverDeleteAll(Long ID, Long maxMessageId) {
        if (this.DEBUG) {
            this.debug("recoverDeleteSubscriptions: Submitting msgSaver deleteAll for cid : " + ID + " MaxId: " + maxMessageId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxDeleteMsgId(long clientId) {
        DeleteSubscriptionManager deleteSubscriptionManager = this;
        synchronized (deleteSubscriptionManager) {
            Long maxId;
            if (this.m_deletions != null && (maxId = (Long)this.m_deletions.get(new Long(clientId))) != null) {
                return maxId;
            }
            if (this.m_replicateOnlyDeletions != null && (maxId = (Long)this.m_replicateOnlyDeletions.get(new Long(clientId))) != null) {
                return maxId;
            }
            return -1L;
        }
    }

    public void redoUnsubscribeEvt(long id, long maxMessageId, boolean replicateOnly) {
        this.beginDeleteSubscriptionInternal(null, id, maxMessageId, true, replicateOnly);
    }

    public void redoUnsubscribeAllEvt(long id, long maxMessageId, boolean replicateOnly) {
        this.beginDeleteSubscriptionInternal(null, id, maxMessageId, true, replicateOnly);
    }

    public void redoSyncSubscriptionDelete(HashMap newDeletions, boolean replicateOnly) {
        if (this.checkDebugFlags(64)) {
            this.debug("redoSyncSubscriptionDelete starting: replOnly= " + replicateOnly + this.getDebugString());
        }
        if (replicateOnly) {
            this.m_replicateOnlyDeletions = this.retrieveOrMergeData(this.m_replicateOnlyDeletions, newDeletions);
        } else {
            this.m_deletions = this.retrieveOrMergeData(this.m_deletions, newDeletions);
        }
        if (this.checkDebugFlags(64)) {
            this.debug("redoSyncSubscriptionDelete completed: " + this.getDebugString());
        }
    }

    private HashMap retrieveOrMergeData(HashMap m_deletionsParam, HashMap newDeletions) {
        HashMap m_deletions = m_deletionsParam;
        if (m_deletions == null) {
            m_deletions = newDeletions;
        } else {
            this.mergeDeletions(m_deletions, newDeletions);
        }
        return m_deletions;
    }

    private void mergeDeletions(HashMap currentDeletions, HashMap newDeletions) {
        for (Long ID : newDeletions.keySet()) {
            Long newMaxID = (Long)newDeletions.get(ID);
            Long currentMaxID = (Long)currentDeletions.get(ID);
            if (currentMaxID != null && (currentMaxID == null || currentMaxID.compareTo(newMaxID) >= 0)) continue;
            currentDeletions.put(ID, newMaxID);
        }
    }

    public void redoEndEvt(long clientId, long maxMessageId, boolean replicateOnly) {
        boolean needSave = false;
        if (this.m_inSync) {
            needSave = true;
        } else {
            boolean foundDeletion = this.endDeleteSubscriptionInternal(clientId, maxMessageId, replicateOnly);
            if (this.m_syncAware) {
                needSave = false;
            } else {
                boolean bl = needSave = !foundDeletion;
            }
        }
        if (needSave) {
            Long cidL;
            DeleteInfo di;
            if (this.m_recoveringDeletes == null) {
                this.m_recoveringDeletes = new LinkedList();
            }
            if (this.m_recoveringDeletesMap == null) {
                this.m_recoveringDeletesMap = new HashMap();
            }
            if ((di = (DeleteInfo)this.m_recoveringDeletesMap.get(cidL = new Long(clientId))) != null && (di.m_replicateOnly && replicateOnly || !di.m_replicateOnly && !replicateOnly)) {
                if (di.m_maxMessageId < maxMessageId) {
                    di.m_maxMessageId = maxMessageId;
                    if (this.checkDebugFlags(64)) {
                        this.debug("redoEndEvt completed; replaced in RecoveringDeletes: id= " + clientId + " maxMessageId= " + maxMessageId + " replOnly= " + replicateOnly + this.getDebugString());
                    }
                }
            } else {
                di = new DeleteInfo();
                di.m_clientId = clientId;
                di.m_maxMessageId = maxMessageId;
                di.m_replicateOnly = replicateOnly;
                this.m_recoveringDeletes.add(di);
                this.m_recoveringDeletesMap.put(cidL, di);
                if (this.checkDebugFlags(64)) {
                    this.debug("redoEndEvt completed; addedTo RecoveringDeletes: id= " + clientId + " maxMessageId= " + maxMessageId + " replOnly= " + replicateOnly + this.getDebugString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSyncRecords() throws ECannotFlushEvents {
        DebugObject evt;
        HashMap deletions = null;
        DeleteSubscriptionManager deleteSubscriptionManager = this;
        synchronized (deleteSubscriptionManager) {
            if (this.m_deletions != null) {
                deletions = (HashMap)this.m_deletions.clone();
            }
        }
        if (deletions != null && !deletions.isEmpty()) {
            evt = new SyncSubscriptionDeleteEvt(deletions);
            this.m_reg.getLogManager().tryAddEvent((IStateEvent)((Object)evt), false);
            if (this.checkDebugFlags(32)) {
                this.debug("writeSyncRecords: numDeletions= " + deletions.size());
            }
        }
        deletions = null;
        evt = this;
        synchronized (evt) {
            if (this.m_replicateOnlyDeletions != null) {
                deletions = (HashMap)this.m_replicateOnlyDeletions.clone();
            }
        }
        if (deletions != null && !deletions.isEmpty()) {
            evt = new SyncSubscriptionDeleteEvt(deletions);
            ((LogEvent)evt).setReplicateOnly(true);
            this.m_reg.getLogManager().tryAddEvent((IStateEvent)((Object)evt), false);
            if (this.checkDebugFlags(32)) {
                this.debug("writeSyncRecords: numReplOnlyDeletions= " + deletions.size());
            }
        }
    }

    public long beginTrimDurableSubscription(DurableTrimOp op, IClientContext cc) throws EDatabaseException, InterruptedIOException, InterruptedException {
        long maxMessageId;
        if (this.DEBUG) {
            this.debug("DSM.beginTrimDurableSubscription determineMaxMessageIDFromTrimDateTime = " + op.getTrimTimestamp());
        }
        DurableTrimEvt evt = new DurableTrimEvt(op.getClientID(), op.getTrimTimestamp());
        evt.setReplicateOnly(false);
        this.m_reg.getLogManager().addEvent(evt, false);
        if (this.DEBUG) {
            this.debug("DSM.beginTrimDurableSubscription event logged: " + op.getClientID() + " trimDateTimex: " + op.getTrimTimestamp());
        }
        if ((maxMessageId = this.m_reg.getBrokerDatabase().determineMaxMessageIdForTrimOp(op.getClientID(), op.getTrimTimestamp())) < 0L) {
            op.sendDBMsgDeleteNotification(0);
            return -1L;
        }
        return this.beginTrimSubscriptionInternal(cc, op, maxMessageId);
    }

    private long beginTrimSubscriptionInternal(IClientContext cc, DurableTrimOp op, long maxMessageId) throws EDatabaseException, InterruptedIOException, InterruptedException {
        if (cc != null) {
            cc.deletingAllMsgs(maxMessageId);
        }
        if (this.DEBUG) {
            Long ccId = null;
            if (cc != null) {
                ccId = cc.getId();
            }
            this.debug("DSM.beginTrimDurableSubscription Registering id for DurableTrimEvt logging " + ccId + " MaxId: " + maxMessageId);
        }
        this.registerIdForDeletion(cc, op.getClientID(), maxMessageId, false);
        if (this.DEBUG) {
            this.debug("DSM.beginTrimDurableSubscription trimming msgs for client " + cc.getUid() + ":" + cc.getAppid() + " trimDateTime: " + op.getTrimTimestamp());
        }
        this.m_reg.getMsgSaver().trimMessages(op, maxMessageId);
        return maxMessageId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redoTrimEvt(long clientId, long trimDateTime, boolean replicateOnly) {
        try {
            long maxMessageId = -1L;
            IClientContext cc = this.m_reg.getClient(clientId);
            DurableTrimOp op = new DurableTrimOp(null, clientId, trimDateTime, AgentRegistrar.getAgentRegistrar().getId());
            try {
                this.m_reg.getBrokerDatabase().beginPubSubDBTran();
                if (Broker.exiting || Broker.isInShutdown()) {
                    return;
                }
                maxMessageId = this.m_reg.getBrokerDatabase().determineMaxMessageIdForTrimOp(clientId, trimDateTime);
            }
            catch (EDatabaseException dbe) {
                SessionConfig.logMessage(dbe, SessionConfig.getLevelWarning());
                return;
            }
            catch (Exception e) {
                SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
                return;
            }
            finally {
                this.m_reg.getBrokerDatabase().releasePubSubDBTran();
            }
            this.beginTrimSubscriptionInternal(cc, op, maxMessageId);
        }
        catch (EClientNotRegistered eClientNotRegistered) {
        }
        catch (EDatabaseException eDatabaseException) {
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized void applyRecoveringDeletes() {
        if (this.checkDebugFlags(64) && this.m_recoveringDeletes != null && !this.m_recoveringDeletes.isEmpty()) {
            this.debug("applyRecoveringDeletes: numRecovering= " + this.m_recoveringDeletes.size());
        }
        if ((this.m_deletions != null || this.m_replicateOnlyDeletions != null) && this.m_recoveringDeletes != null) {
            for (DeleteInfo di : this.m_recoveringDeletes) {
                this.endDeleteSubscriptionInternal(di.m_clientId, di.m_maxMessageId, di.m_replicateOnly);
            }
        }
        this.m_recoveringDeletes = null;
        this.m_recoveringDeletesMap = null;
    }

    private String getDebugString() {
        return this.getDebugString(false);
    }

    private String getDebugString(boolean nullIfZero) {
        int delsize = 0;
        int rdelsize = 0;
        int recDelSize = 0;
        if (this.m_replicateOnlyDeletions != null) {
            rdelsize = this.m_replicateOnlyDeletions.size();
        }
        if (this.m_deletions != null) {
            delsize = this.m_deletions.size();
        }
        if (this.m_recoveringDeletes != null) {
            recDelSize = this.m_recoveringDeletes.size();
        }
        if (nullIfZero && delsize + rdelsize + recDelSize == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(" delsize= ").append(delsize);
        buf.append(" rdelsize= ").append(rdelsize);
        buf.append(" recoveringDel= ").append(recDelSize);
        if (this.m_recoveringDeletesMap != null && recDelSize > this.m_recoveringDeletesMap.size()) {
            buf.append(" recoveringDelMap= ").append(this.m_recoveringDeletesMap.size());
        }
        return buf.toString();
    }

    public synchronized void syncBegin() {
        this.m_syncAware = true;
        if (!this.m_inSync) {
            String data;
            if (this.checkDebugFlags(32) && (data = this.getDebugString(true)) != null) {
                this.debug("SyncBegin starting: " + data);
            }
            this.m_prevDeletions = this.m_deletions;
            this.m_prevReplicateOnlyDeletions = this.m_replicateOnlyDeletions;
            this.m_deletions = null;
            this.m_replicateOnlyDeletions = null;
            this.m_inSync = true;
        }
    }

    public synchronized void syncEnd() {
        if (this.m_inSync) {
            String data;
            if (this.checkDebugFlags(32) && (data = this.getDebugString(true)) != null) {
                this.debug("syncEnd starting: " + data);
            }
            this.applyRecoveringDeletes();
            this.m_prevDeletions = null;
            this.m_prevReplicateOnlyDeletions = null;
            this.m_inSync = false;
            if (this.checkDebugFlags(32) && (data = this.getDebugString(true)) != null) {
                this.debug("syncEnd: completed: " + data);
            }
        }
    }

    final class DeleteInfo {
        long m_clientId;
        long m_maxMessageId;
        boolean m_replicateOnly;

        DeleteInfo() {
        }
    }
}

