/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.broker.EInvalidLogEvent;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.GuarMsgEvt;
import progress.message.broker.LogEvent;
import progress.message.broker.RecipientVector;
import progress.message.broker.RecoveryMgr;
import progress.message.client.ESecurityGeneralException;
import progress.message.util.LongHashTable;
import progress.message.util.StreamUtil;
import progress.message.zclient.FastVector;
import progress.message.zclient.ISubject;

public class DeliveryListEvt
extends LogEvent {
    private GuarMsgEvt m_evt;
    private long m_tracking;
    FastVector m_guarRecips;
    FastVector m_ptpRecips;
    long[] m_ptpTrackingNums = null;
    private LongHashTable m_proxyRecipsTable;
    private boolean m_proxiedCidsOnly;
    private boolean m_deliverOnFlush = false;
    private LongHashTable m_subjectFilters;
    private LongHashTable m_proxyLBSRecipsTable;
    private short m_eventType = (short)181;

    DeliveryListEvt(GuarMsgEvt evt, long tracking, RecipientVector guarRecips, RecipientVector ptpRecips, long[] ptpTrackingNums, boolean deliverOnFlush, LongHashTable proxyRecipsTable, LongHashTable subjectFilters, LongHashTable proxyLBSRecipsTable) {
        this.m_evt = evt;
        if (this.m_evt != null) {
            this.setReplicateOnly(this.m_evt.isReplicateOnly());
        }
        this.m_tracking = tracking;
        if (guarRecips != null) {
            this.m_guarRecips = (FastVector)guarRecips.clone();
        }
        if (ptpRecips != null) {
            this.m_ptpRecips = (FastVector)ptpRecips.clone();
            if (this.m_ptpRecips.m_count > 0) {
                this.m_ptpTrackingNums = new long[ptpTrackingNums.length];
                for (int ii = 0; ii < ptpTrackingNums.length; ++ii) {
                    this.m_ptpTrackingNums[ii] = ptpTrackingNums[ii];
                }
            }
        }
        this.m_deliverOnFlush = deliverOnFlush;
        this.m_proxyRecipsTable = proxyRecipsTable != null && !proxyRecipsTable.isEmpty() ? (LongHashTable)proxyRecipsTable.clone() : null;
        this.m_proxiedCidsOnly = false;
        this.m_subjectFilters = subjectFilters;
        this.m_proxyLBSRecipsTable = proxyLBSRecipsTable;
    }

    DeliveryListEvt(short type) {
        this.m_eventType = type;
        this.m_proxiedCidsOnly = true;
    }

    FastVector getGuarRecipients() {
        return this.m_guarRecips;
    }

    FastVector getPtpRecipients() {
        return this.m_ptpRecips;
    }

    long[] getPtpTrackingNums() {
        return this.m_ptpTrackingNums;
    }

    LongHashTable getProxyRecipsTable() {
        return this.m_proxyRecipsTable;
    }

    LongHashTable getSubjectFilters() {
        return this.m_subjectFilters;
    }

    long getTracking() {
        return this.m_tracking;
    }

    @Override
    public short type() {
        return 181;
    }

    @Override
    public void onFlush() {
        try {
            if (this.m_deliverOnFlush) {
                this.m_evt.deliverMsg();
            }
        }
        catch (ESecurityGeneralException ege) {
            BrokerComponent.getComponentContext().logMessage("Error encrypting message", 2);
        }
    }

    @Override
    public boolean utilizeActionProcessor() {
        return this.m_deliverOnFlush;
    }

    @Override
    public int memSizeBody() {
        return 8 + this.recipientSize();
    }

    @Override
    public int streamSizeBody() {
        return 8 + this.recipientSize();
    }

    @Override
    public int serializedSizeBody() {
        return 8 + this.recipientSize();
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        StreamUtil.writeLong(this.m_tracking, os);
        this.writeRecipientList(os, true);
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        StreamUtil.writeLong(this.m_tracking, out);
        this.writeRecipientList(out, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRecipientList(OutputStream os, boolean includeCCInformation) throws IOException {
        DeliveryListEvt deliveryListEvt = this;
        synchronized (deliveryListEvt) {
            GuarMsgEvt.writeGuarRecips(os, this.m_guarRecips, this.m_tracking);
            GuarMsgEvt.writeProxyRecips(os, this.m_proxyRecipsTable, this.m_tracking, this.m_proxiedCidsOnly);
            GuarMsgEvt.writeProxyLBSRecips(os, this.m_proxyLBSRecipsTable);
            GuarMsgEvt.writePtpRecips(os, this.m_ptpRecips, this.m_ptpTrackingNums, this.m_tracking, includeCCInformation);
            ISubject s = this.retrieveSubject();
            GuarMsgEvt.writeSubjectFilters(os, this.m_subjectFilters, s);
        }
    }

    private int recipientSize() {
        int result = 0;
        result += GuarMsgEvt.guarRecipSize(this.m_guarRecips);
        result += GuarMsgEvt.proxyRecipSize(this.m_proxyRecipsTable);
        result += GuarMsgEvt.proxyLBSRecipSize(this.m_proxyLBSRecipsTable);
        result += GuarMsgEvt.ptpRecipSize(this.m_ptpRecips, this.m_ptpTrackingNums);
        ISubject s = this.retrieveSubject();
        return result += GuarMsgEvt.subjectFiltersSize(this.m_subjectFilters, s);
    }

    private ISubject retrieveSubject() {
        ISubject s = null;
        if (this.m_evt != null) {
            s = this.m_evt.getMessage().getSubject();
        }
        return s;
    }

    @Override
    protected void readBodyFromLog(InputStream in) throws IOException, EInvalidLogEvent {
        this.m_tracking = StreamUtil.readLong(in);
        this.readRecips(in, false, false);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        this.m_tracking = StreamUtil.readLong(in);
        this.readRecips(in, tteTTLConvert, true);
    }

    private void readRecips(InputStream in, boolean tteTTLConvert, boolean readCCInfo) throws IOException {
        Object[] result;
        this.m_guarRecips = null;
        this.m_ptpRecips = null;
        this.m_ptpTrackingNums = null;
        this.m_proxyRecipsTable = null;
        this.m_guarRecips = GuarMsgEvt.readGuarRecips(in, tteTTLConvert, this.m_tracking);
        this.m_proxyRecipsTable = GuarMsgEvt.readProxyRecips(in, tteTTLConvert, this.m_tracking);
        if (this.m_eventType >= 181) {
            this.m_proxyLBSRecipsTable = GuarMsgEvt.readProxyLBSRecips(in, this.getSeqNo());
        }
        if ((result = GuarMsgEvt.readPtpRecips(in, tteTTLConvert, this.m_tracking, readCCInfo, this.m_eventType >= 156)) != null) {
            this.m_ptpRecips = (RecipientVector)result[0];
            this.m_ptpTrackingNums = (long[])result[1];
        }
        if (this.m_eventType >= 111) {
            this.m_subjectFilters = GuarMsgEvt.readSubjectFilters(in);
        }
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoDeliveryList(this);
    }

    void deliverMsg() throws ESecurityGeneralException {
        this.m_evt.deliverMsg(null);
    }

    @Override
    public String toString() {
        return super.toString() + " Delivery list for msg " + this.m_tracking;
    }

    public LongHashTable getProxyLBSRecips() {
        return this.m_proxyLBSRecipsTable;
    }
}

