/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.IClientContext;
import progress.message.broker.IMonitoredObject;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.util.LongHashTable;
import progress.message.zclient.DebugObject;

class DisconnectTimerManager
extends DebugObject {
    private LongHashTable<DisconnectTimer> m_timers = new LongHashTable();
    private AgentRegistrar m_reg;

    DisconnectTimerManager(AgentRegistrar reg) {
        super(DebugState.GLOBAL_DEBUG_ON ? "DisconnectTimerManager" : null);
        this.m_reg = reg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(long timerid, long cid, long timeout, boolean sync) {
        DisconnectTimer t = null;
        boolean newtimer = false;
        LongHashTable<DisconnectTimer> longHashTable = this.m_timers;
        synchronized (longHashTable) {
            t = this.m_timers.get(timerid);
            if (t == null) {
                newtimer = true;
                t = new DisconnectTimer(this.m_reg, timerid, timeout, sync);
                this.m_timers.put(timerid, t);
            }
            if (this.DEBUG) {
                this.debug("register " + timerid + " client:" + cid + " first:" + newtimer);
            }
            t.addClientContext(cid);
            if (newtimer) {
                this.m_reg.getWatchDogThread().register(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregister(long timerid, long cid) {
        DisconnectTimer t = null;
        boolean lastman = false;
        LongHashTable<DisconnectTimer> longHashTable = this.m_timers;
        synchronized (longHashTable) {
            t = this.m_timers.get(timerid);
            if (t == null) {
                return false;
            }
            lastman = t.removeClientContext(cid);
        }
        if (this.DEBUG) {
            this.debug("unregistered " + timerid + " client:" + cid + " last:" + lastman);
        }
        return lastman;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelTimer(long timerid) {
        if (this.DEBUG) {
            this.debug("cancelTimer " + timerid);
        }
        DisconnectTimer t = null;
        LongHashTable<DisconnectTimer> longHashTable = this.m_timers;
        synchronized (longHashTable) {
            t = this.m_timers.remove(timerid);
            if (t != null) {
                this.m_reg.getWatchDogThread().unregister(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean outOfTime(long timerid) {
        DisconnectTimer t = null;
        LongHashTable<DisconnectTimer> longHashTable = this.m_timers;
        synchronized (longHashTable) {
            t = this.m_timers.get(timerid);
            return t == null || t.getExpirationTime() <= System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel(long timerid) {
        if (this.DEBUG) {
            this.debug("cancel " + timerid);
        }
        DisconnectTimer t = null;
        LongHashTable<DisconnectTimer> longHashTable = this.m_timers;
        synchronized (longHashTable) {
            t = this.m_timers.get(timerid);
            if (t != null) {
                return this.m_reg.getWatchDogThread().unregister(t);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForTimerExec(long timerid) throws InterruptedException {
        if (this.DEBUG) {
            this.debug("waitForTimerExec " + timerid);
        }
        LongHashTable<DisconnectTimer> longHashTable = this.m_timers;
        synchronized (longHashTable) {
            while (this.m_timers.get(timerid) != null) {
                this.m_timers.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(long timerid) {
        if (this.DEBUG) {
            this.debug("disconnect " + timerid);
        }
        DisconnectTimer t = null;
        LongHashTable<DisconnectTimer> longHashTable = this.m_timers;
        synchronized (longHashTable) {
            t = this.m_timers.get(timerid);
        }
        try {
            if (t != null) {
                t.timeOutExpired();
            }
        }
        catch (InterruptedException e) {
            throw new EAssertFailure("Interrupted in DisconnectTimer");
        }
    }

    public void clear(long timerid) {
        this.removeTimer(timerid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTimer(long timerid) {
        if (this.DEBUG) {
            this.debug("removeTimer " + timerid);
        }
        LongHashTable<DisconnectTimer> longHashTable = this.m_timers;
        synchronized (longHashTable) {
            this.m_timers.remove(timerid);
            this.m_timers.notifyAll();
        }
    }

    private void dump() {
        System.out.println(this.m_timers);
    }

    public class DisconnectTimer
    extends DebugObject
    implements IMonitoredObject {
        private final AgentRegistrar m_reg;
        private final long m_id;
        private final boolean m_sync;
        private final long m_timeout;
        private Map<Long, Boolean> m_dependents;

        DisconnectTimer(AgentRegistrar reg, long id, long timeout, boolean sync) {
            super(DebugState.GLOBAL_DEBUG_ON ? "DisconnectTimer (" + id + ")" : null);
            this.m_dependents = new LinkedHashMap<Long, Boolean>();
            this.m_reg = reg;
            this.m_id = id;
            this.m_timeout = timeout;
            this.m_sync = sync;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addClientContext(long id) {
            if (this.DEBUG) {
                this.debug("addClientContext " + id);
            }
            Map<Long, Boolean> map = this.m_dependents;
            synchronized (map) {
                this.m_dependents.put(id, Boolean.TRUE);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean removeClientContext(long id) {
            if (this.DEBUG) {
                this.debug("removeClientContext " + id);
            }
            Map<Long, Boolean> map = this.m_dependents;
            synchronized (map) {
                int before = this.m_dependents.size();
                this.m_dependents.remove(id);
                int after = this.m_dependents.size();
                return before == 1 && after == 0;
            }
        }

        @Override
        public long getExpirationTime() {
            return this.m_timeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void timeOutExpired() throws InterruptedException {
            if (this.DEBUG || this.checkDebugFlags(64)) {
                this.debug("postponed disconnect period of " + this.m_timeout + " ms expired for CID " + this.m_id);
            }
            int loopCount = 0;
            while (true) {
                LinkedList<Long> dependentsCopy;
                Object object;
                IClientContext cc;
                block28: {
                    cc = null;
                    ++loopCount;
                    object = this.m_dependents;
                    synchronized (object) {
                        dependentsCopy = new LinkedList<Long>();
                        for (Long idElem : this.m_dependents.keySet()) {
                            this.m_dependents.put(idElem, Boolean.FALSE);
                            dependentsCopy.add(idElem);
                        }
                    }
                    if (dependentsCopy.contains(this.m_id)) {
                        try {
                            cc = this.m_reg.getClient(this.m_id);
                            if (this.DEBUG) {
                                this.debug("calling  reconnectTimeOutExpired on " + cc.getAppid());
                            }
                            cc.reconnectTimeOutExpired(this.m_sync);
                        }
                        catch (EClientNotRegistered ecnr) {
                            if (!this.DEBUG) break block28;
                            this.debug("root client not registered " + this.m_id);
                        }
                    }
                }
                object = dependentsCopy.iterator();
                while (object.hasNext()) {
                    long id = (Long)object.next();
                    if (id == this.m_id) continue;
                    try {
                        cc = this.m_reg.getClient(id);
                        if (this.DEBUG) {
                            this.debug("calling reconnectTimeOutExpired on " + cc.getAppid());
                        }
                        cc.reconnectTimeOutExpired(this.m_sync);
                    }
                    catch (EClientNotRegistered eClientNotRegistered) {}
                }
                object = this.m_dependents;
                synchronized (object) {
                    for (Long idElem : dependentsCopy) {
                        Boolean isNew = this.m_dependents.get(idElem);
                        if (isNew == null) {
                            if (!this.DEBUG && !this.checkDebugFlags(64)) continue;
                            this.debug("dependent " + idElem + " no longer present");
                            continue;
                        }
                        if (isNew.equals(Boolean.TRUE)) {
                            if (!this.DEBUG && !this.checkDebugFlags(64)) continue;
                            this.debug("dependent " + idElem + " re-inserted");
                            continue;
                        }
                        this.m_dependents.remove(idElem);
                    }
                }
                object = DisconnectTimerManager.this.m_timers;
                synchronized (object) {
                    Map<Long, Boolean> map = this.m_dependents;
                    synchronized (map) {
                        if (this.m_dependents.isEmpty()) {
                            DisconnectTimerManager.this.removeTimer(this.m_id);
                            break;
                        }
                        if (this.DEBUG || this.checkDebugFlags(64)) {
                            this.debug("m_dependents not yet empty, size " + this.m_dependents.size() + ", iteration " + loopCount);
                        }
                    }
                }
            }
        }
    }
}

