/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.util.Collection;
import java.util.Hashtable;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.ICCSizeTracker;
import progress.message.broker.IClientContext;
import progress.message.broker.durable.DurableBrowser;
import progress.message.broker.durable.DurableTrimOp;
import progress.message.broker.durable.ECounterFrozenException;
import progress.message.broker.durable.EDurableOperationException;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.zclient.DebugObject;

public class DurableCCTracker
extends DebugObject
implements ICCSizeTracker {
    private IClientContext m_cc;
    private boolean m_queryPending;
    private long m_messageRestorableCount;
    private long m_messageRestorableSize;
    private long m_messageNonRestorableCount;
    private long m_messageNonRestorableSize;
    private long m_maxQueriedMessageId = -1L;
    private long m_maxMessageId = -1L;
    private boolean m_isRecovered = false;
    private Hashtable m_browsers = new Hashtable();
    private boolean m_isFrozen = false;
    private boolean m_trimInProgress = false;
    private Object m_trimSyncObj = new Object();

    DurableCCTracker(IClientContext dcc) {
        super(DebugState.GLOBAL_DEBUG_ON ? "DurableCCTracker " + dcc : null);
        this.m_cc = dcc;
        this.m_queryPending = false;
        this.m_messageRestorableCount = 0L;
        this.m_messageNonRestorableCount = 0L;
        this.m_messageRestorableSize = 0L;
        this.m_messageNonRestorableSize = 0L;
    }

    @Override
    public IClientContext getCC() {
        return this.m_cc;
    }

    public synchronized void freeze() {
        this.m_isFrozen = true;
        this.setSubscriptionTrimInProgress(this.m_trimInProgress, null);
    }

    private synchronized void incrementNonRestorable(long count, long size) {
        this.m_messageNonRestorableCount += count;
        this.m_messageNonRestorableSize += size;
    }

    private synchronized void decrementNonRestorable(long count, long size) {
        if (this.m_messageNonRestorableCount == 0L) {
            if (this.DEBUG) {
                this.debug("Warning, nonrestorable count is already zero and will not be decremented into negative.");
            }
        } else {
            this.m_messageNonRestorableCount -= count;
            this.m_messageNonRestorableSize -= size;
        }
        if (this.m_messageNonRestorableCount == 0L && this.m_messageNonRestorableSize != 0L) {
            if (this.DEBUG) {
                this.debug("Warning, nonrestorable count is zero but size is " + this.m_messageNonRestorableSize + ", setting size to zero");
            }
            this.m_messageNonRestorableSize = 0L;
        }
    }

    private synchronized void incrementRestorable(long count, long size) {
        this.m_messageRestorableCount += count;
        this.m_messageRestorableSize += size;
    }

    private synchronized void decrementRestorable(long count, long size) {
        if (this.m_messageRestorableCount == 0L) {
            if (this.DEBUG) {
                this.debug("Warning, restorable count is already zero and will not be decremented into negative.");
            }
        } else {
            this.m_messageRestorableCount -= count;
            this.m_messageRestorableSize -= size;
        }
        if (this.m_messageRestorableCount == 0L && this.m_messageRestorableSize != 0L) {
            if (this.DEBUG) {
                this.debug("Warning, restorable count is zero but size is " + this.m_messageRestorableSize + ", setting size to zero");
            }
            this.m_messageRestorableSize = 0L;
        }
    }

    @Override
    public synchronized void messageAdded(int count, int size) {
        this.incrementNonRestorable(count, size);
        if (this.DEBUG) {
            this.debug("Message received, Count:" + (this.m_messageRestorableCount + this.m_messageNonRestorableCount) + ", Size:" + (this.m_messageRestorableSize + this.m_messageNonRestorableSize));
        }
    }

    @Override
    public synchronized void messageRemoved(int count, int size) {
        this.decrementNonRestorable(count, size);
        if (this.DEBUG) {
            this.debug("Message delivered, Count:" + (this.m_messageRestorableCount + this.m_messageNonRestorableCount) + ", Size:" + (this.m_messageRestorableSize + this.m_messageNonRestorableSize));
        }
    }

    @Override
    public synchronized void messageSaved(int oldSize, int newSize, long trackingNum) throws ECounterFrozenException {
        if (this.m_isFrozen) {
            throw new ECounterFrozenException();
        }
        if (this.m_queryPending && trackingNum > this.m_maxQueriedMessageId && trackingNum <= this.m_maxMessageId) {
            if (this.DEBUG) {
                this.debug("Not accounting for TrkNum: " + trackingNum + " with size: " + newSize);
            }
            return;
        }
        this.decrementNonRestorable(1L, oldSize);
        this.incrementRestorable(1L, newSize);
        if (this.checkDebugFlags(64) && this.m_messageNonRestorableCount < 0L) {
            this.debug("messageSaved; m_messageNonRestorableCount= " + this.m_messageNonRestorableCount + " m_messageRestorableCount= " + this.m_messageRestorableCount);
        }
    }

    @Override
    public synchronized void messageProxySaved(int size, long trackingNum) throws ECounterFrozenException {
        if (this.m_isFrozen) {
            throw new ECounterFrozenException();
        }
        if (this.m_queryPending && trackingNum > this.m_maxQueriedMessageId && trackingNum <= this.m_maxMessageId) {
            if (this.DEBUG) {
                this.debug("Not accounting for TrkNum: " + trackingNum + " with size: " + size);
            }
            return;
        }
        this.incrementRestorable(1L, size);
    }

    @Override
    public synchronized void messageDeleted(int size, long trackingNum) throws ECounterFrozenException {
        if (this.m_isFrozen) {
            throw new ECounterFrozenException();
        }
        if (this.m_queryPending && trackingNum > this.m_maxQueriedMessageId && trackingNum <= this.m_maxMessageId) {
            if (this.DEBUG) {
                this.debug("Not accounting for TrkNum: " + trackingNum + " with size: " + size);
            }
            return;
        }
        this.decrementRestorable(1L, size);
        if (this.DEBUG) {
            this.debug("Message deleted, Count:" + (this.m_messageRestorableCount + this.m_messageNonRestorableCount) + ", Size:" + (this.m_messageRestorableSize + this.m_messageNonRestorableSize) + ", TrkNum: " + trackingNum);
        }
    }

    public synchronized void messagesDeleted(int count, int size) throws ECounterFrozenException {
        if (this.m_isFrozen) {
            throw new ECounterFrozenException();
        }
        if (this.m_queryPending) {
            return;
        }
        this.decrementRestorable(count, size);
        if (this.DEBUG) {
            this.debug("Messages deleted, Count:" + (this.m_messageRestorableCount + this.m_messageNonRestorableCount) + ", Size:" + (this.m_messageRestorableSize + this.m_messageNonRestorableSize));
        }
    }

    @Override
    public synchronized void updateQueryMsgs(long size, long count, long maxQueriedMessageId) throws ECounterFrozenException {
        if (this.m_isFrozen) {
            throw new ECounterFrozenException();
        }
        if (!this.m_queryPending) {
            throw new EAssertFailure("Attempt to update query count/size while not in query state! " + this.m_cc + " size= " + size + " count= " + count);
        }
        this.incrementRestorable(count, size);
        this.m_maxQueriedMessageId = maxQueriedMessageId;
        if (this.DEBUG) {
            this.debug("Message query update, Count:" + this.m_messageRestorableCount + ", Size:" + this.m_messageRestorableSize + ", Max queried message id: " + this.m_maxQueriedMessageId + ", Max message id: " + this.m_maxMessageId);
        }
    }

    @Override
    public synchronized void setQueryPending(boolean value, long maxMessageId) {
        this.m_queryPending = value;
        this.m_maxMessageId = maxMessageId;
    }

    public synchronized boolean isQueryPending() {
        return this.m_queryPending;
    }

    @Override
    public synchronized long getMessageCount() {
        if (this.m_queryPending) {
            return -1L;
        }
        long result = this.m_messageRestorableCount + this.m_messageNonRestorableCount;
        if (result < 0L) {
            if (this.DEBUG) {
                this.debug("getMessageCount(): Count is negative: " + result);
            }
            return 0L;
        }
        return result;
    }

    @Override
    public synchronized long[] getMessageCountAndSize() {
        return new long[]{this.getMessageCount(), this.getMessageSize()};
    }

    @Override
    public synchronized long getRestorableMessageCount() {
        return this.getSize(this.m_messageRestorableCount);
    }

    @Override
    public synchronized long getRestorableMessageSize() {
        return this.getSize(this.m_messageRestorableSize);
    }

    private long getSize(long m_messageRestorableSize) {
        if (this.m_queryPending) {
            return -1L;
        }
        return m_messageRestorableSize;
    }

    @Override
    public synchronized long getMessageSize() {
        if (this.m_queryPending) {
            return -1L;
        }
        long result = this.m_messageRestorableSize + this.m_messageNonRestorableSize;
        if (result < 0L) {
            if (this.DEBUG) {
                this.debug("Size is negative: " + result);
            }
            return 0L;
        }
        return result;
    }

    @Override
    public synchronized void reset() {
        if (this.checkDebugFlags(64)) {
            this.debug("reset; oldValues are: m_messageNonRestorableCount= " + this.m_messageNonRestorableCount + " m_messageRestorableCount= " + this.m_messageRestorableCount);
        }
        this.m_messageRestorableCount = 0L;
        this.m_messageRestorableSize = 0L;
        this.m_messageNonRestorableCount = 0L;
        this.m_messageNonRestorableSize = 0L;
        this.setSubscriptionTrimInProgress(this.m_trimInProgress, null);
    }

    @Override
    public void reset(long maxIdToSkip) {
        if (this.checkDebugFlags(64)) {
            this.debug("reset w. id; oldValues are: m_messageNonRestorableCount= " + this.m_messageNonRestorableCount + " m_messageRestorableCount= " + this.m_messageRestorableCount);
        }
    }

    @Override
    public synchronized void recover(long count, long size) {
        this.incrementRestorable(count, size);
        this.m_isRecovered = true;
    }

    @Override
    public boolean isRecovered() {
        return this.m_isRecovered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createBrowser(String tracking, long clientId, boolean isLocal) throws EDurableOperationException {
        block5: {
            IClientContext cc = AgentRegistrar.getAgentRegistrar().lockContext(this.m_cc.getId());
            try {
                long cid = clientId;
                if (this.m_cc.isGroupSubscription()) {
                    cid = this.m_cc.getId();
                }
                if (cc.isDisconnected()) {
                    this.m_browsers.put(tracking, new DurableBrowser(cid, tracking, isLocal));
                    break block5;
                }
                throw new EDurableOperationException(2);
            }
            finally {
                cc.unlock();
            }
        }
    }

    public void setBrowseInactivityTimeout(String tracking, int timeout) throws EDurableOperationException {
        DurableBrowser browser = this.retrieveDurableBrowser(tracking);
        browser.setInactivityTimeout(timeout);
    }

    public void destroyBrowser(String tracking) throws EDurableOperationException {
        if (this.m_browsers.remove(tracking) == null) {
            throw new EDurableOperationException(5);
        }
    }

    public Collection browse(String tracking, int maxMessages) throws EDurableOperationException, InterruptedException {
        DurableBrowser browser = this.retrieveDurableBrowser(tracking);
        return browser.browse(maxMessages);
    }

    private DurableBrowser retrieveDurableBrowser(String tracking) throws EDurableOperationException {
        DurableBrowser browser = (DurableBrowser)this.m_browsers.get(tracking);
        if (browser == null) {
            throw new EDurableOperationException(5);
        }
        return browser;
    }

    private boolean isDebug() {
        return this.DEBUG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setSubscriptionTrimInProgress(boolean value, DurableTrimOp op) {
        Object object = this.m_trimSyncObj;
        synchronized (object) {
            if (value) {
                if (!this.isSubscriptionTrimInProgress(true)) {
                    this.m_trimInProgress = true;
                    if (op != null) {
                        op.sendTrimInvocationInitiated();
                    }
                }
            } else {
                this.m_trimInProgress = false;
                if (op != null) {
                    op.sendTrimInvocationCompleted();
                }
            }
            this.m_trimSyncObj.notifyAll();
            return this.m_trimInProgress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubscriptionTrimInProgress(boolean wait) {
        Object object = this.m_trimSyncObj;
        synchronized (object) {
            if (!this.m_trimInProgress) {
                return false;
            }
            while (wait && !this.m_trimInProgress && this.m_cc.isDisconnected() && !Broker.exiting) {
                try {
                    this.m_trimSyncObj.wait(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            return this.m_trimInProgress;
        }
    }
}

