/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.util.StreamUtil;

class DurableSMOUpdateEvt
extends LogEvent {
    private long m_id = -1L;
    private long m_restoringBrokerId = -1L;
    private long m_previousBrokerId = -1L;

    DurableSMOUpdateEvt(long id, long previousBrokerId, long restoringBrokerId) {
        this.m_id = id;
        this.m_previousBrokerId = previousBrokerId;
        this.m_restoringBrokerId = restoringBrokerId;
    }

    DurableSMOUpdateEvt() {
    }

    @Override
    protected int memSizeBody() {
        return 24;
    }

    @Override
    protected int streamSizeBody() {
        return this.serializedSizeBody();
    }

    @Override
    protected int serializedSizeBody() {
        return 24;
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        this.m_id = StreamUtil.readLong(in);
        this.m_previousBrokerId = StreamUtil.readLong(in);
        this.m_restoringBrokerId = StreamUtil.readLong(in);
    }

    @Override
    protected void writeBodyToLog(OutputStream os, long maxbytes) throws ELogEventTooLong, IOException {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        this.writeBody(os);
    }

    private void writeBody(OutputStream os) throws IOException {
        StreamUtil.writeLong(this.m_id, os);
        StreamUtil.writeLong(this.m_previousBrokerId, os);
        StreamUtil.writeLong(this.m_restoringBrokerId, os);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeBody(os);
    }

    @Override
    public short type() {
        return 73;
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoDurableSMOUpdate(this.m_id, this.m_previousBrokerId, this.m_restoringBrokerId);
    }

    @Override
    public String toString() {
        return super.toString() + "DurableSMOUpdateEvt cid: " + this.m_id + " previous brokerId: " + this.m_previousBrokerId + " restoring brokerId: " + this.m_restoringBrokerId;
    }

    @Override
    public boolean usesClientRegistry() {
        return true;
    }

    @Override
    public boolean usesSubscriptionTable() {
        return true;
    }

    @Override
    public long getClientID() {
        return this.m_id;
    }
}

