/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.util.StreamUtil;

public class DurableTrimEvt
extends LogEvent {
    private long m_id;
    private long m_trimDateTime;

    DurableTrimEvt(long id, long trimDateTime) {
        this.m_id = id;
        this.m_trimDateTime = trimDateTime;
    }

    DurableTrimEvt() {
    }

    @Override
    public short type() {
        return 151;
    }

    @Override
    protected int memSizeBody() {
        return 16;
    }

    @Override
    public int streamSizeBody() {
        return this.serializedSizeBody();
    }

    @Override
    public int serializedSizeBody() {
        return this.memSizeBody();
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        this.writeBody(out);
    }

    private void writeBody(OutputStream os) throws IOException {
        StreamUtil.writeLong(this.m_id, os);
        StreamUtil.writeLong(this.m_trimDateTime, os);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeBody(os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        this.m_id = StreamUtil.readLong(in);
        this.m_trimDateTime = StreamUtil.readLong(in);
    }

    @Override
    public void redo(RecoveryMgr rm) {
        AgentRegistrar.getAgentRegistrar().getDeleteSubscriptionManager().redoTrimEvt(this.m_id, this.m_trimDateTime, this.isReplicateOnly());
    }

    @Override
    public String toString() {
        return super.toString() + "DurableTrimEvt cid: " + this.m_id + " MaxMessageId: " + this.m_trimDateTime;
    }
}

