/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.text.DecimalFormat;
import progress.message.broker.Config;
import progress.message.broker.IClientContext;
import progress.message.broker.PublishLimiter;
import progress.message.msg.IMgram;
import progress.message.zclient.DebugObject;
import progress.message.zclient.FastVector;

public class FlowToDiskMemoryManager
extends DebugObject {
    private FastVector m_clientsBlockedOnMemory = new FastVector();
    private long m_memorySize = 0L;
    private Object m_memorySizeSyncObj = new Object();
    private static FlowToDiskMemoryManager s_flowMgr;
    private static final DecimalFormat PERCENT_FORMAT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static FlowToDiskMemoryManager getFlowToDiskMemoryManager() {
        if (s_flowMgr != null) return s_flowMgr;
        Class<FlowToDiskMemoryManager> clazz = FlowToDiskMemoryManager.class;
        synchronized (FlowToDiskMemoryManager.class) {
            if (s_flowMgr != null) return s_flowMgr;
            s_flowMgr = new FlowToDiskMemoryManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return s_flowMgr;
        }
    }

    private FlowToDiskMemoryManager() {
        super("FlowToDiskMemoryManager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateMemorySize(long size, FastVector clients, PublishLimiter pubLimiter) {
        Object object = this.m_memorySizeSyncObj;
        synchronized (object) {
            this.m_memorySize += size;
            if (size > 0L) {
                this.flowControlPublisherOnMemory(clients, pubLimiter);
            } else {
                this.releaseAllPublishersBlockedOnMemory();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseAllPublishersBlockedOnMemory() {
        Object object = this.m_memorySizeSyncObj;
        synchronized (object) {
            if (this.m_clientsBlockedOnMemory.m_count > 0) {
                boolean releaseBlockedPublishers = false;
                if (Config.MAX_FTD_MEMORY_SIZE == 0) {
                    releaseBlockedPublishers = true;
                } else {
                    long resumeMemorySize = (long)Config.MAX_FTD_MEMORY_SIZE * 1024L * 1024L;
                    if (resumeMemorySize >= this.m_memorySize) {
                        releaseBlockedPublishers = true;
                    }
                }
                if (releaseBlockedPublishers) {
                    for (int ii = 0; ii < this.m_clientsBlockedOnMemory.m_count; ++ii) {
                        IClientContext client = (IClientContext)this.m_clientsBlockedOnMemory.m_data[ii];
                        Object object2 = client.getSyncObj();
                        synchronized (object2) {
                            client.getOutQueue().flowToDiskReleaseBlockedPublishers();
                            continue;
                        }
                    }
                    if (this.checkDebugFlags(64)) {
                        this.debug("All pubs released; ftdMemorySize= " + this.m_memorySize);
                    }
                    this.m_clientsBlockedOnMemory.m_count = 0;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releasePublishersBlockedOnMemoryForSubscriber(IClientContext subscriber) {
        Object object = this.m_memorySizeSyncObj;
        synchronized (object) {
            Object object2 = subscriber.getSyncObj();
            synchronized (object2) {
                subscriber.getOutQueue().flowToDiskReleaseBlockedPublishers();
            }
            int subIndex = this.m_clientsBlockedOnMemory.indexOf(subscriber, 0);
            if (subIndex > -1) {
                this.m_clientsBlockedOnMemory.removeElementAt(subIndex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flowControlPublisherOnMemory(FastVector clients, PublishLimiter pubLimiter) {
        Object object = this.m_memorySizeSyncObj;
        synchronized (object) {
            if (Config.MAX_FTD_MEMORY_SIZE <= 0) {
                return;
            }
            long maxMemorySize = (long)Config.MAX_FTD_MEMORY_SIZE * 1024L * 1024L;
            if (this.DEBUG) {
                this.debug("Using " + PERCENT_FORMAT.format((double)this.m_memorySize / (double)maxMemorySize) + " of flow-to-disk memory.");
            }
            if (maxMemorySize < this.m_memorySize) {
                for (int ii = 0; ii < clients.m_count; ++ii) {
                    IClientContext client = (IClientContext)clients.m_data[ii];
                    if (!client.flowToDiskFlowControlPublisher(pubLimiter)) continue;
                    if (this.checkDebugFlags(64)) {
                        this.debug("Flow controlling publisher; FlowToDiskMemorySize= " + this.m_memorySize + " maxMemorySize= " + maxMemorySize);
                    }
                    if (this.m_clientsBlockedOnMemory.indexOf(client, 0) != -1) continue;
                    this.m_clientsBlockedOnMemory.addElement(client);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasRoomForMgram(IMgram msg) {
        Object object = this.m_memorySizeSyncObj;
        synchronized (object) {
            long maxMemorySize = (long)Config.MAX_FTD_MEMORY_SIZE * 1024L * 1024L;
            if (Config.MAX_FTD_MEMORY_SIZE <= 0) {
                return true;
            }
            return maxMemorySize >= this.m_memorySize + (long)msg.memoryLength();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMemorySize() {
        Object object = this.m_memorySizeSyncObj;
        synchronized (object) {
            return this.m_memorySize;
        }
    }

    static {
        PERCENT_FORMAT = new DecimalFormat("#0.0%");
    }
}

