/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.util.Vector;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.client.EGeneralException;
import progress.message.zclient.Envelope;
import progress.message.zclient.FastVector;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Message;
import progress.message.zclient.Session;

public final class GetDurableSubscriptionUserIds
implements IMessageHandler {
    private AgentRegistrar m_reg;

    GetDurableSubscriptionUserIds(AgentRegistrar reg) {
        this.m_reg = reg;
    }

    @Override
    public void handleMessage(Session s, Envelope env) {
        try {
            Message req = env.getMessage();
            String prefix = req.readUTF();
            boolean getAll = prefix.length() == 0;
            Vector vec = new Vector();
            this.m_reg.getDurableSubscriptionUserIds(vec);
            Message rep = new Message();
            rep.writeBoolean(true);
            if (getAll) {
                int count = vec.size();
                rep.writeInt(vec.size());
                if (count > 0) {
                    for (int i = 0; i < count; ++i) {
                        rep.writeUTF((String)vec.elementAt(i));
                    }
                }
            } else {
                FastVector matches = new FastVector();
                int length = vec.size();
                for (int i = 0; i < length; ++i) {
                    String name = (String)vec.elementAt(i);
                    if (!name.startsWith(prefix)) continue;
                    matches.addElement(name);
                }
                int count = matches.m_count;
                rep.writeInt(count);
                for (int i = 0; i < count; ++i) {
                    rep.writeUTF((String)matches.m_data[i]);
                }
            }
            s.reply(rep, env);
        }
        catch (Exception e) {
            Message rep = new Message();
            try {
                rep.writeBoolean(false);
                rep.writeObject(e);
                s.reply(rep, env);
            }
            catch (EGeneralException ege) {
                if (!Broker.isInShutdown()) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)ege, 2);
                }
            }
            catch (Exception ee) {
                BrokerComponent.getComponentContext().logMessage((Throwable)ee, 2);
            }
        }
    }
}

