/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.util.ArrayList;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.EClientNotRegistered;
import progress.message.client.EGeneralException;
import progress.message.client.EInvalidSubjectSyntax;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Message;
import progress.message.zclient.Session;

public final class GetNeighborSubscriptions
implements IMessageHandler {
    private AgentRegistrar m_reg;

    GetNeighborSubscriptions(AgentRegistrar reg) {
        this.m_reg = reg;
    }

    @Override
    public void handleMessage(Session s, Envelope env) {
        block7: {
            try {
                String neighbor = env.getMessage().readUTF();
                String pattern = env.getMessage().readUTF();
                Message rep = new Message();
                try {
                    long requestor = AddrUtil.stringToClientId(neighbor, "Broker");
                    ArrayList al = this.m_reg.getSubscriptions(requestor, pattern);
                    rep.writeInt(al.size());
                    rep.writeObject(al);
                }
                catch (EInvalidSubjectSyntax e) {
                    rep.writeInt(-1);
                }
                catch (EClientNotRegistered e) {
                    rep.writeInt(-2);
                }
                s.reply(rep, env);
            }
            catch (EGeneralException e) {
                if (!Broker.isInShutdown()) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                }
            }
            catch (IOException e) {
                if (Broker.isInShutdown()) break block7;
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
    }
}

