/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.util.Vector;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.RoutingConnectionInfo;
import progress.message.client.EGeneralException;
import progress.message.zclient.Envelope;
import progress.message.zclient.FastVector;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Message;
import progress.message.zclient.Session;

public final class GetRoutings
implements IMessageHandler {
    private AgentRegistrar m_reg;

    GetRoutings(AgentRegistrar reg) {
        this.m_reg = reg;
    }

    @Override
    public void handleMessage(Session s, Envelope env) {
        block11: {
            try {
                if (!env.isRequest()) {
                    return;
                }
                Message msg = env.getMessage();
                Message rep = new Message();
                try {
                    String prefix = env.getMessage().readUTF();
                    boolean getAll = prefix.length() == 0;
                    Vector routings = this.m_reg.getRoutingConfig().getRoutingConnections();
                    RoutingConnectionInfo r = null;
                    rep.writeBoolean(true);
                    int numMatches = 0;
                    FastVector matches = null;
                    if (getAll) {
                        numMatches = routings.size();
                    } else {
                        matches = new FastVector();
                        int length = routings.size();
                        for (int i = 0; i < length; ++i) {
                            r = (RoutingConnectionInfo)routings.elementAt(i);
                            if (!r.getRoutingNodeName().startsWith(prefix)) continue;
                            matches.addElement(r);
                        }
                        numMatches = matches.m_count;
                    }
                    rep.writeInt(numMatches);
                    for (int i = 0; i < numMatches; ++i) {
                        r = !getAll ? (RoutingConnectionInfo)matches.m_data[i] : (RoutingConnectionInfo)routings.elementAt(i);
                        rep.writeUTF(r.getRoutingNodeName());
                        rep.writeUTF(r.getConnectionURLs());
                        rep.writeUTF(r.getUserName());
                        rep.writeBoolean(r.isLoadBalance());
                        rep.writeBoolean(r.isSequentialLoadBalancing());
                        rep.writeInt(r.getTimeout());
                        rep.writeBoolean(r.isForwardRoutings());
                        rep.writeBoolean(r.isStaticRouting());
                        rep.writeUTF(r.getOutboundBrokerName());
                        rep.writeUTF(r.getRoutingAcceptor());
                    }
                }
                catch (Exception e) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                    rep = new Message();
                    rep.writeBoolean(false);
                    rep.writeObject(e);
                }
                s.reply(rep, env);
            }
            catch (EGeneralException e) {
                if (!Broker.isInShutdown()) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                }
            }
            catch (IOException e) {
                if (Broker.isInShutdown()) break block11;
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
    }
}

