/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.util.Enumeration;
import progress.message.broker.Broker;
import progress.message.broker.Config;
import progress.message.broker.GetStats;
import progress.message.broker.StatsManager;
import progress.message.broker.StatsMetrics;
import progress.message.client.EGeneralException;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Message;
import progress.message.zclient.Session;

public class GetStatsInfo
extends GetStats
implements IMessageHandler {
    GetStatsInfo(StatsManager statsMgr) {
        super(statsMgr);
    }

    @Override
    public void handleMessage(Session s, Envelope env) {
        block5: {
            try {
                Message req = env.getMessage();
                Message reply = new Message();
                String broker = req.readUTF();
                System.out.println("GetStatsInfo: broker = " + broker);
                if (broker.equals(Config.BROKER_NAME)) {
                    reply.writeUTF(Config.BROKER_NAME);
                    Message rep = GetStatsInfo.getStatsInfo(reply);
                    s.reply(rep, env);
                }
            }
            catch (EGeneralException e) {
                if (!Broker.isInShutdown()) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                }
            }
            catch (IOException e) {
                if (Broker.isInShutdown()) break block5;
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
    }

    public static Message getStatsInfo(Message msg) {
        try {
            msg.writeInt(StatsMetrics.facilityDisplayNames.size());
            for (String facilityDisplayName : StatsMetrics.facilityDisplayNames) {
                msg.writeUTF(facilityDisplayName);
            }
            int capSize = metricCaptions.size();
            msg.writeInt(capSize);
            Enumeration capKeys = metricCaptions.keys();
            while (capKeys.hasMoreElements()) {
                Object curCapKey = capKeys.nextElement();
                msg.writeInt((Integer)curCapKey);
                Object metricType = metricTypes.get(curCapKey);
                if (metricType != null) {
                    msg.writeInt((Integer)metricType);
                } else {
                    msg.writeInt(0);
                }
                msg.writeUTF((String)metricCaptions.get(curCapKey));
            }
            int keySize = metricKeys.size();
            msg.writeInt(keySize);
            Enumeration keyKeys = metricKeys.keys();
            while (keyKeys.hasMoreElements()) {
                Object curKeyKey = keyKeys.nextElement();
                msg.writeInt((Integer)metricKeys.get(curKeyKey));
                msg.writeUTF((String)curKeyKey);
            }
        }
        catch (IOException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
        return msg;
    }
}

