/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.util.Vector;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.BrokerSubscription;
import progress.message.broker.DurableSubscriptionUtil;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.EInvalidAdminAddress;
import progress.message.client.EGeneralException;
import progress.message.client.EInvalidSubjectSyntax;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Message;
import progress.message.zclient.Session;

public final class GetSubscriptionsInfo
implements IMessageHandler {
    private AgentRegistrar m_reg;

    GetSubscriptionsInfo(AgentRegistrar reg) {
        this.m_reg = reg;
    }

    @Override
    public void handleMessage(Session s, Envelope env) {
        block15: {
            try {
                long requestor = AddrUtil.getIdFromAdmin(env.getSubject());
                String pattern = env.getMessage().readUTF();
                Message rep = new Message();
                try {
                    byte clientVer = this.m_reg.getClient(requestor).getClientSessionVer();
                    String subName = null;
                    String selector = null;
                    Vector v = this.m_reg.subscriptions(requestor, pattern);
                    int size = v.size();
                    rep.writeInt(size);
                    for (int i = 0; i < size; ++i) {
                        BrokerSubscription bs = (BrokerSubscription)v.elementAt(i);
                        rep.writeUTF(bs.getSubject().getSubjectString());
                        bs.getLabel().serialize(rep);
                        selector = bs.getSelectorString();
                        if (selector == null) {
                            rep.writeBoolean(false);
                        } else {
                            rep.writeBoolean(true);
                            rep.writeUTF(selector);
                        }
                        rep.writeBoolean(bs.getSelectorAtBroker());
                        subName = null;
                        if (bs.getClient() != null && bs.getClient().getAppid() != null) {
                            subName = DurableSubscriptionUtil.getSubscriptionName(bs.getClient().getAppid());
                        }
                        if (subName == null) {
                            rep.writeBoolean(false);
                        } else {
                            rep.writeBoolean(true);
                            rep.writeUTF(subName);
                        }
                        if (clientVer >= 25) {
                            rep.writeBoolean(bs.getDurableStrictMessageOrder());
                        }
                        if (clientVer < 27) continue;
                        rep.writeInt(bs.getFlowToDisk());
                    }
                }
                catch (EInvalidSubjectSyntax e) {
                    rep.writeInt(-1);
                }
                catch (EClientNotRegistered e) {
                    rep.writeInt(0);
                }
                s.reply(rep, env);
            }
            catch (EInvalidAdminAddress e) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
            catch (EGeneralException e) {
                if (!Broker.isInShutdown()) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                }
            }
            catch (IOException e) {
                if (Broker.isInShutdown()) break block15;
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
    }
}

