/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.util.StreamUtil;

abstract class GlobalTxnStateChangeEvt
extends LogEvent {
    private int m_tid;
    private long m_requestId;
    private short m_type = 0;

    GlobalTxnStateChangeEvt(int tid, long requestId) {
        this.m_tid = tid;
        this.m_requestId = requestId;
    }

    GlobalTxnStateChangeEvt(short typ) {
        this.m_type = typ;
    }

    int getTid() {
        return this.m_tid;
    }

    long getRequestId() {
        return this.m_requestId;
    }

    @Override
    public abstract short type();

    @Override
    protected int memSizeBody() {
        return 12;
    }

    @Override
    protected int streamSizeBody() {
        return this.serializedSizeBody();
    }

    @Override
    protected int serializedSizeBody() {
        return 12;
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        StreamUtil.writeInt(this.m_tid, out);
        StreamUtil.writeLong(this.m_requestId, out);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        StreamUtil.writeInt(this.m_tid, os);
        StreamUtil.writeLong(this.m_requestId, os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        this.m_tid = StreamUtil.readInt(in);
        this.m_requestId = StreamUtil.readLong(in);
    }

    @Override
    public abstract void redo(RecoveryMgr var1);

    protected abstract String typeStr();

    @Override
    public String toString() {
        return super.toString() + "Txn " + this.m_tid + ", requestId " + this.m_requestId + ": " + this.typeStr();
    }
}

