/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.SyncTxnEvt;
import progress.message.broker.TxnAckPool;
import progress.message.xa.XidImpl;

class GlobalTxnSyncEvt
extends SyncTxnEvt {
    private XidImpl m_xid;

    GlobalTxnSyncEvt(int tid, String uid, String appid, short state, String userXid, String noDupCommitId, long noDupTimestamp, Object xid, TxnAckPool txnAckPool, byte persistenceType, long requestId, long lifespan, boolean chained, short replyStatus) {
        super(tid, -1, uid, appid, state, userXid, noDupCommitId, noDupTimestamp, txnAckPool, persistenceType, requestId, lifespan, chained, replyStatus);
        if (xid instanceof XidImpl) {
            this.m_xid = (XidImpl)xid;
        } else {
            System.out.println("[GlobalTxnSyncEvt]unknow xid type");
        }
    }

    GlobalTxnSyncEvt(short type) {
        super(type);
        this.m_xid = new XidImpl();
    }

    XidImpl getXid() {
        return this.m_xid;
    }

    @Override
    public short type() {
        return 100;
    }

    @Override
    protected int memSizeBody() {
        return super.memSizeBody() + this.m_xid.getMemorySize();
    }

    @Override
    public int streamSizeBody() {
        return super.streamSizeBody() + this.m_xid.getMemorySize();
    }

    @Override
    public int serializedSizeBody() {
        return super.serializedSizeBody() + this.m_xid.getMemorySize();
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        super.writeBodyToLog(out, maxbytes);
        this.m_xid.writebody(out);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        super.writeBodyToStream(os, tteTTLConvert);
        this.m_xid.writebody(os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        super.readBodyFromStream(in, tteTTLConvert);
        this.m_xid.readbody(in);
        if (this.DEBUG) {
            this.debug("readbody().m_xid=" + this.m_xid);
        }
    }

    @Override
    public String toString() {
        return super.toString() + "[" + this.m_xid.toString() + "]";
    }
}

