/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.GroupSubscriptionClientContext;
import progress.message.broker.GroupXOnceMsgAllocationTracker;
import progress.message.broker.IClientContext;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.msg.IMgram;
import progress.message.util.StreamUtil;
import progress.message.zclient.EMgramFormatError;

public class GroupMsgAllocationEvt
extends LogEvent {
    private static final short m_eventType = 182;
    private static final byte REPLICATE_ONLY_FLAG = 1;
    private byte m_flags;
    private long m_msgTracking;
    private long m_recipientTracking;
    private long m_recipientId;
    private long m_groupId;
    private IMgram m_msg;
    private GroupSubscriptionClientContext m_groupcc;
    private IClientContext m_recip;
    private boolean m_deliverOnFlush = false;

    public GroupMsgAllocationEvt(IClientContext recipient, GroupSubscriptionClientContext groupcc, long tracking, IMgram msg) {
        this.m_recip = recipient;
        this.m_recipientId = recipient.getId();
        this.m_groupcc = groupcc;
        this.m_groupId = groupcc.getId();
        this.m_msgTracking = tracking;
        this.m_recipientTracking = msg.getGuarenteedTrackingNum();
        this.m_msg = msg;
        this.m_deliverOnFlush = true;
        if (msg.isNonPersistentReplicated()) {
            this.m_flags = (byte)(this.m_flags | 1);
            this.setReplicateOnly(msg.isNonPersistentReplicated());
        }
        if (this.DEBUG) {
            this.debug("Constructor; tracking= " + tracking);
        }
    }

    public GroupMsgAllocationEvt() {
    }

    public IMgram getMessage() {
        return this.m_msg;
    }

    public GroupSubscriptionClientContext getGroupCC() {
        return this.m_groupcc;
    }

    long getGroupId() {
        return this.m_groupId;
    }

    IClientContext getRecipient() {
        return this.m_recip;
    }

    long getRecipientId() {
        return this.m_recipientId;
    }

    long getRecipientTracking() {
        return this.m_recipientTracking;
    }

    long getMessageTracking() {
        return this.m_msgTracking;
    }

    public GroupXOnceMsgAllocationTracker.GroupMsgAllocation getGroupMessageAllocation() {
        return new GroupXOnceMsgAllocationTracker.GroupMsgAllocation(this.isReplicateOnly(), this.m_recipientId, this.m_msgTracking, this.m_recipientTracking);
    }

    @Override
    protected void onFlush() {
        if (this.DEBUG) {
            this.debug("onFlush starting ");
        }
        if (this.m_deliverOnFlush) {
            this.m_recip.xOnceGroupSendRelease(this);
        }
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoGroupAllocation(this);
    }

    @Override
    protected int serializedSizeBody() {
        return 33;
    }

    private void writeBody(OutputStream os) throws IOException {
        StreamUtil.writeByte(this.m_flags, os);
        StreamUtil.writeLong(this.m_msgTracking, os);
        StreamUtil.writeLong(this.m_recipientTracking, os);
        StreamUtil.writeLong(this.m_recipientId, os);
        StreamUtil.writeLong(this.m_groupId, os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException, EMgramFormatError {
        this.m_flags = StreamUtil.readByte(in);
        this.setReplicateOnly((this.m_flags & 1) != 0);
        this.m_msgTracking = StreamUtil.readLong(in);
        this.m_recipientTracking = StreamUtil.readLong(in);
        this.m_recipientId = StreamUtil.readLong(in);
        this.m_groupId = StreamUtil.readLong(in);
    }

    @Override
    protected int memSizeBody() {
        return this.streamSizeBody();
    }

    @Override
    protected int streamSizeBody() {
        return this.serializedSizeBody();
    }

    @Override
    public short type() {
        return 182;
    }

    @Override
    protected void writeBodyToLog(OutputStream os, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        this.writeBody(os);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeBody(os);
    }
}

