/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.util.StreamUtil;

public final class GuarAckDoneEvt
extends LogEvent {
    private long m_tracking;

    public GuarAckDoneEvt(long tracking) {
        this.m_tracking = tracking;
    }

    public GuarAckDoneEvt() {
    }

    long getTracking() {
        return this.m_tracking;
    }

    @Override
    public short type() {
        return 24;
    }

    @Override
    protected int memSizeBody() {
        return 8;
    }

    @Override
    protected int streamSizeBody() {
        return this.serializedSizeBody();
    }

    @Override
    protected int serializedSizeBody() {
        return 8;
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        StreamUtil.writeLong(this.m_tracking, out);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        StreamUtil.writeLong(this.m_tracking, os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        this.m_tracking = StreamUtil.readLong(in);
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoGuarAckDone(this.m_tracking);
    }

    @Override
    public String toString() {
        return super.toString() + "Guar ack " + this.m_tracking + " acknowledged";
    }
}

