/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.interbroker.prAccessor;
import progress.message.util.ArrayUtil;
import progress.message.util.EAssertFailure;
import progress.message.util.StreamUtil;

public final class GuarAckXchgEvt
extends LogEvent {
    private ByteArrayOutputStream m_trackingBuf = new ByteArrayOutputStream();
    private DataOutputStream m_trackDos = new DataOutputStream(this.m_trackingBuf);

    public void addTracking(long tracking) {
        try {
            this.m_trackDos.writeLong(tracking);
        }
        catch (IOException e) {
            String mf37 = prAccessor.getString("STR008");
            Object[] ob37 = new Object[]{e};
            throw new EAssertFailure(MessageFormat.format(mf37, ob37), e);
        }
    }

    @Override
    public short type() {
        return 25;
    }

    @Override
    protected int memSizeBody() {
        return 16 + this.m_trackingBuf.size();
    }

    @Override
    protected int streamSizeBody() {
        return this.serializedSizeBody();
    }

    @Override
    protected int serializedSizeBody() {
        return 4 + this.m_trackingBuf.size();
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        this.writeBody(out);
    }

    private void writeBody(OutputStream os) throws IOException {
        int bufSize = this.m_trackingBuf.size();
        StreamUtil.writeInt(bufSize, os);
        os.write(this.m_trackingBuf.toByteArray(), 0, bufSize);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeBody(os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        int len = StreamUtil.readInt(in);
        byte[] data = new byte[len];
        StreamUtil.readBytes(in, data, 0, len);
        this.m_trackingBuf.reset();
        this.m_trackingBuf.write(data, 0, len);
    }

    @Override
    public void redo(RecoveryMgr rm) {
        byte[] data = this.m_trackingBuf.toByteArray();
        for (int i = 0; i < data.length; i += 8) {
            rm.redoGuarAckDone(ArrayUtil.readLong(data, i));
        }
    }

    @Override
    public String toString() {
        String mf120 = prAccessor.getString("STR009");
        Object[] ob120 = new Object[]{super.toString()};
        return MessageFormat.format(mf120, ob120);
    }
}

