/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.security.cert.BrokerTrustStore;
import com.sonicsw.security.cert.EmptyTrustStore;
import com.sonicsw.security.cert.TrustStore;
import java.security.KeyStoreException;

public class HTTPDirectInboundEntry {
    private String m_url;
    private String m_deliveryMode;
    private String m_destinationType;
    private String m_destinationName;
    private int m_priority;
    private long m_ttl;
    private String m_type;
    private String m_username;
    private String m_password;
    private String m_requestMode;
    private boolean m_preserveUndelivered = false;
    private boolean m_notifyUndelivered = false;
    private boolean m_duplicateDetect = false;
    private boolean m_headerAuthentication = false;
    private boolean m_basicAuthentication = false;
    private boolean m_certificateAuthentication = false;
    private boolean m_userPreconfigured = false;
    private boolean m_isWSDLRetrieval = false;
    private String m_soapRoles = null;
    private String m_wsdlLocation = null;
    private String m_keystoreFormat = null;
    private String m_keystoreLocation = null;
    private char[] m_keystorePassword = null;
    private boolean m_certificateToUsernameMapping = true;
    private String m_x509Alias = null;
    private char[] m_x509Password = null;
    private String m_undeliveredDestinationType = null;
    private String m_undeliveredDestinationName = null;
    private TrustStore m_trustStore = null;
    private long m_timeout = 0L;

    public HTTPDirectInboundEntry(String url, String deliveryMode, String destinationType, String destinationName, Integer priority, Long ttl, String username, String password, String requestMode, Long timeout, Boolean preserveUndelivered, Boolean notifyUndelivered, Boolean duplicateDetect, Boolean headerAuthentication, Boolean basicAuthentication, Boolean certificateAuthentication, Boolean userPreconfigured) {
        this.m_url = url;
        this.m_deliveryMode = deliveryMode;
        this.m_destinationType = destinationType;
        this.m_destinationName = destinationName;
        this.m_username = username;
        this.m_password = password;
        this.m_requestMode = requestMode;
        if (timeout != null) {
            this.m_timeout = timeout;
        }
        this.m_priority = priority == null ? 4 : priority;
        this.m_ttl = ttl == null ? 60000L : ttl;
        if (preserveUndelivered != null) {
            this.m_preserveUndelivered = preserveUndelivered;
        }
        if (notifyUndelivered != null) {
            this.m_notifyUndelivered = notifyUndelivered;
        }
        this.m_duplicateDetect = false;
        if (duplicateDetect != null) {
            this.m_duplicateDetect = duplicateDetect;
        }
        this.m_headerAuthentication = false;
        if (headerAuthentication != null) {
            this.m_headerAuthentication = headerAuthentication;
        }
        this.m_basicAuthentication = false;
        if (basicAuthentication != null) {
            this.m_basicAuthentication = basicAuthentication;
        }
        this.m_certificateAuthentication = false;
        if (certificateAuthentication != null) {
            this.m_certificateAuthentication = certificateAuthentication;
        }
        this.m_userPreconfigured = userPreconfigured;
        this.supportWSDLConfiguration();
    }

    public String getURL() {
        return this.m_url;
    }

    public void setURL(String url) {
        this.m_url = url;
    }

    public boolean isWSDLRetrieval() {
        return this.m_isWSDLRetrieval;
    }

    public void setIsWSDLRetrieval(boolean isWSDLRetrieval) {
        this.m_isWSDLRetrieval = isWSDLRetrieval;
    }

    public String getRequestMode() {
        return this.m_requestMode;
    }

    public String getDestinationType() {
        return this.m_destinationType;
    }

    public String getDestinationName() {
        return this.m_destinationName;
    }

    public String getUsername() {
        return this.m_username;
    }

    public String getPassword() {
        return this.m_password;
    }

    public String getDeliveryMode() {
        return this.m_deliveryMode;
    }

    public int getPriority() {
        return this.m_priority;
    }

    public long getTTL() {
        return this.m_ttl;
    }

    public String getType() {
        return this.m_type;
    }

    public boolean getPreserveUndelivered() {
        return this.m_preserveUndelivered;
    }

    public boolean getNotifyUndelivered() {
        return this.m_notifyUndelivered;
    }

    public boolean getDuplicateDetect() {
        return this.m_duplicateDetect;
    }

    public boolean getHeaderAuthentication() {
        return this.m_headerAuthentication;
    }

    public boolean getBasicAuthentication() {
        return this.m_basicAuthentication;
    }

    public boolean getCertificateAuthentication() {
        return this.m_certificateAuthentication;
    }

    public boolean getUserPreconfigured() {
        return this.m_userPreconfigured;
    }

    public long getTimeout() {
        return this.m_timeout;
    }

    public String toString() {
        return "HTTPDirectInboundEntry(url:" + this.m_url + ", deliveryMode: " + this.m_deliveryMode + ", destinationType: " + this.m_destinationType + ", destinationName: " + this.m_destinationName + ", priority:" + this.m_priority + ", ttl: " + this.m_ttl + ", type: " + this.m_type + ", username:  " + this.m_username + ", password: " + this.m_password + ", requestMode:  " + this.m_requestMode + ", preserveUndelivered: " + this.m_preserveUndelivered + ", notifyUndelivered:  " + this.m_notifyUndelivered + ", duplicateDetect: " + this.m_duplicateDetect + ", requestMode:  " + this.m_headerAuthentication + ", m_basicAuthentication: " + this.m_basicAuthentication + ", m_certificateAuthentication:  " + this.m_certificateAuthentication + ", m_userPreconfigured: " + this.m_userPreconfigured + ", m_soapRoles: " + this.m_soapRoles + ", m_wsdlLocation: " + this.m_wsdlLocation + ", m_undeliveredDestinationType: " + this.m_undeliveredDestinationType + ", m_undeliveredDestinationName: " + this.m_undeliveredDestinationName;
    }

    public void configureWS(String soapRoles, String wsdlLocation) {
        this.m_soapRoles = soapRoles;
        this.m_wsdlLocation = wsdlLocation;
    }

    public String getSOAPRoles() {
        return this.m_soapRoles;
    }

    public String getWSDLLocation() {
        return this.m_wsdlLocation;
    }

    public void configureUndelivered(String destinationType, String destinationName) {
        this.m_undeliveredDestinationType = destinationType;
        this.m_undeliveredDestinationName = destinationName;
    }

    public String getUndeliveredDestinationType() {
        return this.m_undeliveredDestinationType;
    }

    public String getUndeliveredDestinationName() {
        return this.m_undeliveredDestinationName;
    }

    public void configureWSSecurity(String keystoreFormat, String keystoreLocation, String keystorePassword, Boolean certificateToUsernameMapping, String x509alias, String keyPassword) throws KeyStoreException {
        this.m_keystoreFormat = keystoreFormat;
        this.m_keystoreLocation = keystoreLocation;
        if (keystorePassword != null) {
            this.m_keystorePassword = keystorePassword.toCharArray();
        }
        if (certificateToUsernameMapping != null) {
            this.m_certificateToUsernameMapping = certificateToUsernameMapping;
        }
        this.m_x509Alias = x509alias;
        if (keyPassword != null) {
            this.m_x509Password = keyPassword.toCharArray();
        }
        this.createTrustStore();
    }

    public synchronized void createTrustStore() throws KeyStoreException {
        this.m_trustStore = null;
        String err = null;
        if (this.m_keystoreLocation == null || this.m_keystoreLocation.length() == 0) {
            err = "Trust store not specified for " + this.m_url;
        } else if (this.m_keystorePassword == null || this.m_keystorePassword.length == 0) {
            err = "Invalid trust store password for " + this.m_url;
        } else {
            try {
                this.m_trustStore = new TrustStore(this.m_keystoreFormat);
                this.m_trustStore.load(this.m_keystoreLocation, this.m_keystorePassword);
            }
            catch (Exception ex) {
                this.m_trustStore = null;
                err = "Unable to load trust store for " + this.m_url + ": " + ex.getMessage();
            }
        }
        if (this.m_trustStore == null || !this.m_trustStore.initialized()) {
            this.m_trustStore = BrokerTrustStore.getInstance(this.m_keystoreFormat);
            if (this.m_trustStore != null && this.m_trustStore.initialized()) {
                err = err + " - use broker trust store.";
            } else {
                this.m_trustStore = new EmptyTrustStore();
                err = err + " - broker trust store not available either.";
            }
        }
        if (err != null) {
            throw new KeyStoreException(err);
        }
    }

    public synchronized TrustStore getTrustStore() {
        return this.m_trustStore;
    }

    public synchronized void deleteTrustStore() throws KeyStoreException {
        this.m_trustStore = null;
        this.m_trustStore = BrokerTrustStore.getInstance(this.m_keystoreFormat);
        if (this.m_trustStore == null || !this.m_trustStore.initialized()) {
            this.m_trustStore = new EmptyTrustStore();
            throw new KeyStoreException("No trust store available for " + this.m_url);
        }
    }

    public void setKeystoreFormat(String format) {
        this.m_keystoreFormat = format;
    }

    public void setKeystoreLocation(String url) {
        this.m_keystoreLocation = url;
    }

    public void setKeystorePassword(char[] pwd) {
        this.m_keystorePassword = pwd;
    }

    public void setCertificateToUsernameMapping(boolean b) {
        this.m_certificateToUsernameMapping = b;
    }

    public void setX509Alias(String alias) {
        this.m_x509Alias = alias;
    }

    public void setX509Password(char[] pwd) {
        this.m_x509Password = pwd;
    }

    public String getKeystoreFormat() {
        return this.m_keystoreFormat;
    }

    public String getKeystoreLocation() {
        return this.m_keystoreLocation;
    }

    public char[] getKeystorePassword() {
        return this.m_keystorePassword;
    }

    public boolean getCertificateToUsernameMapping() {
        return this.m_certificateToUsernameMapping;
    }

    public String getX509Alias() {
        return this.m_x509Alias;
    }

    public char[] getX509Password() {
        return this.m_x509Password;
    }

    private void supportWSDLConfiguration() {
        if (this.m_url.toUpperCase().endsWith("?WSDL")) {
            this.m_url = this.m_url.substring(0, this.m_url.length() - 5);
            this.m_destinationType = "WSDL";
            this.m_wsdlLocation = this.m_destinationName;
        }
    }
}

