/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.util.Properties;
import progress.message.broker.HTTPAcceptor;
import progress.message.broker.IAcceptor;
import progress.message.net.ESocketConfigException;
import progress.message.net.ProgressSocketFactory;

public class HTTPSAcceptor
extends HTTPAcceptor
implements IAcceptor {
    static volatile String s_DEFAULT_HTTP_DEBUG = null;
    static volatile String s_DEFAULT_HTTP_MIN_THREADS = null;
    static volatile String s_DEFAULT_HTTP_MAX_THREADS = null;
    static volatile String s_DEFAULT_HTTP_THREAD_IDLE_TIMEOUT_IN_MILLISECS = null;
    static volatile String s_DEFAULT_HTTP_CONNECTION_CLEANUP_INTERVAL = null;
    static volatile String s_DEFAULT_HTTP_CLIENT_IDLE_TIMEOUT_IN_MILLISECS = null;
    static volatile String s_DEFAULT_HTTP_CLIENT_READ_TIMEOUT_IN_MILLISECS = null;
    static volatile String s_DEFAULT_HTTP_BROKER_READ_TIMEOUT_IN_MILLISECS = null;
    static volatile String s_DEFAULT_SSL_CERTIFICATE_CHAIN = null;
    static volatile String s_DEFAULT_SSL_CERTIFICATE_CHAIN_FORM = null;
    static volatile String s_DEFAULT_SSL_PRIVATE_KEY = null;
    static volatile String s_DEFAULT_SSL_PRIVATE_KEY_PASSWORD = null;
    static volatile String s_DEFAULT_SSL_CIPHER_SUITES = null;
    static volatile String s_DEFAULT_SSL_CA_CERTIFICATES_DIR = null;
    static volatile String s_DEFAULT_SSL_CLIENT_AUTHENTICATION = null;
    static volatile String s_DEFAULT_SSL_PROVIDER_CLASS = null;

    public HTTPSAcceptor(String name, String url, String externalURL, boolean dynHostBinding, String privateHost, String publicHost, Properties properties) throws ESocketConfigException {
        super(name, url, externalURL, "https", dynHostBinding, privateHost, publicHost, properties);
        this.m_properties.remove("PROTOCOL");
        this.m_properties.put("PROTOCOL", "HTTPS");
        int socketType = ProgressSocketFactory.getType(this.m_protocol);
        this.m_socketFactory = ProgressSocketFactory.getFactory(socketType);
    }

    public static void setDefaultSSLParams(String providerClass, String certChain, String certChainForm, String privateKey, String privateKeyPassword, String cipherSuites, String caCertsDir, String clientAuth) {
        if (providerClass != null) {
            s_DEFAULT_SSL_PROVIDER_CLASS = new String(providerClass);
        }
        if (certChain != null) {
            s_DEFAULT_SSL_CERTIFICATE_CHAIN = new String(certChain);
        }
        if (certChainForm != null) {
            s_DEFAULT_SSL_CERTIFICATE_CHAIN_FORM = new String(certChainForm);
        }
        if (privateKey != null) {
            s_DEFAULT_SSL_PRIVATE_KEY = new String(privateKey);
        }
        if (privateKeyPassword != null) {
            s_DEFAULT_SSL_PRIVATE_KEY_PASSWORD = new String(privateKeyPassword);
        }
        if (cipherSuites != null) {
            s_DEFAULT_SSL_CIPHER_SUITES = new String(cipherSuites);
        }
        if (caCertsDir != null) {
            s_DEFAULT_SSL_CA_CERTIFICATES_DIR = new String(caCertsDir);
        }
        if (clientAuth != null) {
            s_DEFAULT_SSL_CLIENT_AUTHENTICATION = new String(clientAuth);
        }
    }

    public static void setDefaultHTTPParams(Boolean httpDebug, Integer httpMinThreads, Integer httpMaxThreads, Long httpThreadIdleTimeout, Long httpConnectionCleanupInterval, Long httpClientIdleTimeout, Long httpClientReadTimeout, Long httpBrokerReadTimeout) {
        String val = httpDebug != null ? httpDebug.toString() : "false";
        s_DEFAULT_HTTP_DEBUG = new String(val);
        val = httpMinThreads != null ? httpMinThreads.toString() : String.valueOf(2);
        s_DEFAULT_HTTP_MIN_THREADS = new String(val);
        val = httpMaxThreads != null ? httpMaxThreads.toString() : String.valueOf(512);
        s_DEFAULT_HTTP_MAX_THREADS = new String(val);
        val = httpThreadIdleTimeout != null ? httpThreadIdleTimeout.toString() : "60000";
        s_DEFAULT_HTTP_THREAD_IDLE_TIMEOUT_IN_MILLISECS = new String(val);
        val = httpConnectionCleanupInterval != null ? httpConnectionCleanupInterval.toString() : "60000";
        s_DEFAULT_HTTP_CONNECTION_CLEANUP_INTERVAL = new String(val);
        val = httpClientIdleTimeout != null ? httpClientIdleTimeout.toString() : String.valueOf(10000L);
        s_DEFAULT_HTTP_CLIENT_IDLE_TIMEOUT_IN_MILLISECS = new String(val);
        val = httpClientReadTimeout != null ? httpClientReadTimeout.toString() : String.valueOf(50500L);
        s_DEFAULT_HTTP_CLIENT_READ_TIMEOUT_IN_MILLISECS = new String(val);
        val = httpBrokerReadTimeout != null ? httpBrokerReadTimeout.toString() : String.valueOf(20000L);
        s_DEFAULT_HTTP_BROKER_READ_TIMEOUT_IN_MILLISECS = new String(val);
    }

    @Override
    public void createServerSocket() throws IOException {
        super.createServerSocket();
    }
}

