/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.AgentSender;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.EStartupFailure;
import progress.message.broker.IClientContext;
import progress.message.client.EGeneralException;
import progress.message.msg.IMgram;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;
import progress.message.zclient.IDirectSender;
import progress.message.zclient.xonce.IDRInboundAdapter;
import progress.message.zclient.xonce.IDROutboundAdapter;
import progress.message.zclient.xonce.IDoubtResolver;
import progress.message.zclient.xonce.IDoubtResolverCompletionListener;
import progress.message.zclient.xonce.IIDRInboundSupport;
import progress.message.zclient.xonce.IIDROutboundSupport;
import progress.message.zclient.xonce.IIDRTransport;
import progress.message.zclient.xonce.MgramIDRTransport;

public class IDRMgramHandler
extends DebugObject {
    private AgentRegistrar m_reg;
    private static Hashtable m_transports = new Hashtable();

    IDRMgramHandler(AgentRegistrar reg) throws EStartupFailure {
        super(DebugState.GLOBAL_DEBUG_ON ? "IDRMgramHandler" : null);
        this.m_reg = reg;
    }

    void processIDR(IMgram m) throws IOException {
        long cid = m.getBrokerHandle().getSenderID();
        if (cid == -1L) {
            return;
        }
        IIDRTransport transport = null;
        try {
            transport = this.locateTransport(cid);
            if (transport == null) {
                transport = this.constructTransport(cid);
            }
            transport.handleIDR(m);
        }
        catch (IOException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            if (transport != null) {
                this.removeTransport(cid);
            }
            throw e;
        }
    }

    AgentRegistrar getAgentRegistrar() {
        return this.m_reg;
    }

    private IIDRTransport constructTransport(long cid) throws EClientNotRegistered {
        IClientContext cc = this.m_reg.getClient(cid);
        String appid = cc.getAppid();
        IDROutboundAdapter outbound = new IDROutboundAdapter(cc);
        IDRInboundAdapter inbound = new IDRInboundAdapter(cc);
        AgentSenderWrapper sender = new AgentSenderWrapper(cc.getConnection().getAgentSender());
        MgramIDRTransport transport = new MgramIDRTransport(true, cc.getChannel(), cc.getAppid(), sender, outbound, inbound);
        BrokerIDRListener listener = new BrokerIDRListener(cid, outbound, inbound);
        outbound.setCompletionListener(listener);
        inbound.setCompletionListener(listener);
        m_transports.put(appid, transport);
        return transport;
    }

    private IIDRTransport locateTransport(long cid) throws EClientNotRegistered {
        IClientContext cc = this.m_reg.getClient(cid);
        String appid = cc.getAppid();
        IIDRTransport transport = (IIDRTransport)m_transports.get(appid);
        if (transport != null) {
            AgentSenderWrapper sender = new AgentSenderWrapper(cc.getConnection().getAgentSender());
            ((MgramIDRTransport)transport).setSender(sender);
        }
        return transport;
    }

    private void removeTransport(long cid) throws EClientNotRegistered {
        IClientContext cc = this.m_reg.getClient(cid);
        String appid = cc.getAppid();
        m_transports.remove(appid);
    }

    class BrokerIDRListener
    implements IDoubtResolverCompletionListener {
        private Vector m_dependents = null;
        private long m_cid = 0L;

        BrokerIDRListener(long cid, IIDROutboundSupport outbound, IIDRInboundSupport inbound) {
            this.m_cid = cid;
            this.m_dependents = new Vector();
            this.m_dependents.add(outbound);
            this.m_dependents.add(inbound);
        }

        @Override
        public void failed(IDoubtResolver res, IOException ioe) {
            BrokerComponent.getComponentContext().logMessage((Throwable)ioe, 2);
            this.m_dependents.clear();
        }

        @Override
        public void completed(IDoubtResolver res, int status) {
            this.m_dependents.remove(res);
            if (this.m_dependents.isEmpty()) {
                try {
                    IDRMgramHandler.this.removeTransport(this.m_cid);
                    IClientContext cc = IDRMgramHandler.this.m_reg.getClient(this.m_cid);
                    if (cc.getConnection().getDeliveryStartedFromId(this.m_cid)) {
                        cc.startDelivery(null);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    class AgentSenderWrapper
    implements IDirectSender {
        AgentSender m_as = null;

        AgentSenderWrapper(AgentSender as) {
            this.m_as = as;
        }

        @Override
        public void sendDirect(IMgram m) throws EGeneralException {
            try {
                this.m_as.sendThrough(m);
            }
            catch (IOException ioe) {
                throw new EGeneralException(0, ioe.toString());
            }
        }
    }
}

