/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import progress.message.broker.Transaction;
import progress.message.broker.TransactionMgr;
import progress.message.broker.prAccessor;
import progress.message.client.EGeneralException;
import progress.message.zclient.ENoTrackingNum;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Message;
import progress.message.zclient.MessageHandler;
import progress.message.zclient.Session;

class InDoubtTxnReplyHandler
extends MessageHandler
implements IMessageHandler {
    private TransactionMgr m_txnmgr;

    InDoubtTxnReplyHandler(TransactionMgr tmgr) {
        super(null);
        this.m_txnmgr = tmgr;
        try {
            this.replaceHandler(this);
        }
        catch (EGeneralException eGeneralException) {
            // empty catch block
        }
    }

    @Override
    public void handleMessage(Session context, Envelope envelope) {
        block8: {
            try {
                Message rep = envelope.getMessage();
                Transaction t = this.m_txnmgr.removeInDoubtTxn(envelope.getReplyTracking());
                if (t == null) break block8;
                t.cancelInDoubtReq();
                try {
                    boolean txnStatus = rep.readBoolean();
                    if (txnStatus) {
                        this.m_txnmgr.commit(t.getTid());
                        if (this.m_txnmgr.DEBUG_RECOVERY) {
                            this.m_txnmgr.debug("Committed inDoubt txn " + t.getTid());
                        }
                    } else {
                        this.m_txnmgr.abort(t.getTid());
                        if (this.m_txnmgr.DEBUG_RECOVERY) {
                            this.m_txnmgr.debug("Aborted inDoubt txn " + t.getTid());
                        }
                    }
                }
                catch (Exception e) {
                    BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR264"), (Throwable)e, 2);
                    BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR265") + t.getTid() + ": " + e.getMessage(), (Throwable)e, 2);
                }
            }
            catch (ENoTrackingNum e) {
                BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR266"), (Throwable)e, 2);
            }
        }
    }
}

