/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mq.components.BrokerComponent;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Properties;
import progress.message.broker.Config;
import progress.message.broker.ConfigProperties;
import progress.message.broker.LogFile;
import progress.message.broker.TransactionMgr;
import progress.message.broker.prAccessor;
import progress.message.client.EGeneralException;
import progress.message.db.DBFactory;
import progress.message.db.Db;
import progress.message.db.EBrokerNameTooLong;
import progress.message.db.EDatabaseException;
import progress.message.db.EDatabaseNotExists;
import progress.message.dbq.DBQSetup;
import progress.message.dbq.IInitDbDBQ;
import progress.message.dbsc.ISchemaDef;
import progress.message.dbsc.IStatusListener;
import progress.message.dd.NoDupDetectDb;
import progress.message.dd.NoDupDetectDbAdmin;
import progress.message.resources.prMessageFormat;
import progress.message.util.DebugState;
import progress.message.util.server.OStream;

public class InitBrokerDatabase {
    public static final String UNKNOWN = null;
    public static final String CREATE = "create";
    public static final String CREATEWITHSAMPLES = "createwithsamples";
    public static final String RECREATE = "recreate";
    public static final String DELETE = "delete";
    public static final String UPGRADE = "upgrade";
    public static final String COMPACT = "compact";
    private String action = UNKNOWN;
    private static volatile String iniFile = "db.ini";
    private static volatile String iniPwd = null;
    private String workDir = ".";
    private boolean duplicateDetectiontable = true;
    private boolean basicDBTables = true;
    private boolean forceDel = false;
    private boolean create = false;
    private boolean recreate = false;
    private boolean upgrade = false;
    private boolean compact = false;
    private IComponentContext m_context = null;
    private Properties m_props = null;
    private ISchemaDef schemaCompacted;

    public static void main(String[] args) {
        int exitStatus = 1;
        InitBrokerDatabase ibd = new InitBrokerDatabase();
        if (ibd.parseArguments(args)) {
            try {
                Config.setStandAlone(true);
                ConfigProperties configuration = new ConfigProperties();
                configuration.set(iniFile, iniPwd);
                ibd.setProps(configuration.getPropertyObject());
                ibd.execute();
                exitStatus = 0;
            }
            catch (Exception e) {
                OStream.println(e.getMessage());
            }
        }
        OStream.println("");
        OStream.println(prAccessor.getString("STR197"));
        System.exit(exitStatus);
    }

    private void usage() {
        this.log(prAccessor.getString("STR192"));
        this.log("");
        this.log(prAccessor.getString("STR296"));
        this.log(prAccessor.getString("STR195"));
        this.log(prAccessor.getString("STR196"));
        this.log(prAccessor.getString("STR193"));
        this.log(prAccessor.getString("STR194"));
    }

    private boolean parseArguments(String[] args) {
        if (args.length < 1 && args.length > 7) {
            this.log(prAccessor.getString("STR143") + args.length);
            return this.logAndUsage();
        }
        if (args.length <= 7) {
            this.setAction(args[0]);
            if (this.getAction() == null) {
                this.log(prAccessor.getString("STR146") + args[0]);
                return this.logAndUsage();
            }
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if ("-ini".equalsIgnoreCase(arg) && i < args.length && !args[i + 1].startsWith("-")) {
                    iniFile = args[++i];
                    continue;
                }
                if ("-inipwd".equalsIgnoreCase(arg) && i < args.length && !args[i + 1].startsWith("-")) {
                    iniPwd = args[++i];
                    continue;
                }
                if ("transactionTable".equalsIgnoreCase(arg)) {
                    this.duplicateDetectiontable = true;
                    this.setBasicDBTables(false);
                    continue;
                }
                if ("-w".equalsIgnoreCase(arg) && i < args.length && !args[i + 1].startsWith("-")) {
                    this.workDir = args[++i];
                    continue;
                }
                this.log(prAccessor.getString("STR146") + arg);
                this.usage();
                return false;
            }
        }
        return true;
    }

    private boolean logAndUsage() {
        this.log("");
        this.usage();
        return false;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String vParam) {
        String v = vParam;
        if (v != null) {
            this.action = v = v.toLowerCase();
            if (v.equals(CREATE)) {
                this.create = true;
            } else if (v.equals(CREATEWITHSAMPLES)) {
                this.create = true;
            } else if (v.equals(RECREATE)) {
                this.recreate = true;
            } else if (v.equals(DELETE)) {
                this.forceDel = true;
            } else if (v.equals(UPGRADE)) {
                this.upgrade = true;
            } else if (v.equals(COMPACT)) {
                this.compact = true;
            }
        }
    }

    public void setBasicDBTables(boolean value) {
        this.basicDBTables = value;
    }

    public boolean getBasicDBTables() {
        return this.basicDBTables;
    }

    public boolean getTransactionTable() {
        return this.duplicateDetectiontable;
    }

    public void setTransactionTable(boolean v) {
        this.duplicateDetectiontable = v;
    }

    public String getIniFile() {
        return iniFile;
    }

    public void setIniFile(String v) {
        iniFile = v;
    }

    public String getIniPassword() {
        return iniPwd;
    }

    public void setIniPassword(String v) {
        iniPwd = v;
    }

    private void setupConfig() {
        String brokerName = null;
        String logPath = null;
        String fileSeparator = null;
        String dbtype = null;
        String mqconnect = null;
        if (!Config.loadConfig(this.getProps(), true)) {
            if (BrokerComponent.getComponentContext() == null) {
                OStream.println(prAccessor.getString("STR047"));
            } else {
                BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR047"), 3);
            }
            throw new RuntimeException(prAccessor.getString("STR047"));
        }
        dbtype = this.getProps().getProperty("DATABASE_STORE_TYPE", Config.DATABASE_STORE_TYPE);
        mqconnect = this.getProps().getProperty("MQSTORE_DB_CONNECT", Config.MQSTORE_DB_CONNECT);
        String enableSecurity = this.getProps().getProperty("ENABLE_SECURITY", String.valueOf(Config.ENABLE_SECURITY));
        String enableQopSecurity = this.getProps().getProperty("ENABLE_QOPSECURITY", String.valueOf(Config.ENABLE_QOPSECURITY));
        brokerName = this.getProps().getProperty("BROKER_NAME", Config.BROKER_NAME);
        fileSeparator = System.getProperties().getProperty("file.separator");
        logPath = this.getContext() == null ? this.getProps().getProperty("LOG_PATH", ".") : this.getProps().getProperty("RECOVERY_LOG_PATH", ".");
        logPath = logPath + fileSeparator;
        Config.DATABASE_STORE_TYPE = dbtype;
        Config.MQSTORE_DB_CONNECT = mqconnect;
        Config.BROKER_NAME = brokerName;
        Config.ENABLE_SECURITY = Boolean.valueOf(enableSecurity);
        Config.ENABLE_QOPSECURITY = Boolean.valueOf(enableQopSecurity);
        Config.LOG_PATH = logPath;
        Config.LOG_FILE_1 = Config.LOG_PATH + "recoverylog1.bin";
        Config.LOG_FILE_2 = Config.LOG_PATH + "recoverylog2.bin";
        Config.TXN_FILE_PATH = Config.LOG_PATH;
        Config.DEBUG_NAME = this.getProps().getProperty("DEBUG_NAME", null);
        DebugState.parse(Config.DEBUG_NAME);
    }

    public void compactDatabase(String workingDir) {
        this.setupConfig();
        try {
            ISchemaDef.LogTarget lt = new ISchemaDef.LogTarget(){

                @Override
                public void log(String type, String message) {
                    int level = 2;
                    if (type == "fatal error") {
                        level = 1;
                    } else if (type == "verbose") {
                        level = 5;
                    } else if (type == "result") {
                        level = 3;
                    }
                    if (level <= 3) {
                        if (InitBrokerDatabase.this.getContext() != null) {
                            InitBrokerDatabase.this.getContext().logMessage(message, level);
                        } else {
                            OStream.println(message);
                        }
                    }
                }
            };
            Db db = DBFactory.createBrokerDb();
            this.schemaCompacted = db.getSchemaDef();
            this.schemaCompacted.setLogTarget(lt);
            this.schemaCompacted.compact(workingDir);
        }
        catch (EDatabaseException e) {
            BrokerComponent.getComponentContext().logMessage("Failed to compact database:" + e.getMessage(), (Throwable)e, 2);
            throw new RuntimeException(e);
        }
        finally {
            Db.shutdown();
        }
    }

    public void stopDBCompact() {
        if (this.schemaCompacted != null) {
            this.schemaCompacted.stopCompact();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initNeeded() {
        this.setupConfig();
        File log1 = new File(Config.LOG_FILE_1);
        File log2 = new File(Config.LOG_FILE_2);
        if (log1.exists() && log2.exists()) {
            if (DBFactory.isBrokerDbDirExists()) {
                return false;
            }
            throw new RuntimeException(new EDatabaseException("Inconsistent state detected: recovery logs exists but Broker DB " + Config.MQSTORE_DB_CONNECT + " directory does not exist"));
        }
        try {
            Db db = DBFactory.createBrokerDb();
            db.start();
            boolean bl = !db.seemsConfigured();
            return bl;
        }
        catch (EDatabaseNotExists dbne) {
            boolean bl = true;
            return bl;
        }
        catch (EDatabaseException dbe) {
            boolean bl = false;
            return bl;
        }
        finally {
            Db.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean upgradeNeeded() {
        this.setupConfig();
        try {
            int vers;
            Db db = DBFactory.createBrokerDb();
            db.start();
            if (db.seemsConfigured() && (vers = db.checkUpgrade()) != db.getLatestSupportedDbVersion()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (EDatabaseException dbe) {
            boolean bl = false;
            return bl;
        }
        finally {
            Db.shutdown();
        }
        return false;
    }

    public void execute() throws Exception {
        try {
            this.setupConfig();
            Db db = DBFactory.createBrokerDb();
            if (this.getBasicDBTables()) {
                boolean dbexists = true;
                try {
                    db.start();
                }
                catch (EDatabaseNotExists ex) {
                    dbexists = false;
                }
                if (dbexists && db.seemsConfigured()) {
                    if (this.create) {
                        Db.shutdown();
                        String msgf = prAccessor.getString("STR295");
                        Object[] obj = new Object[]{Config.BROKER_NAME};
                        throw new Exception(prMessageFormat.format(msgf, obj));
                    }
                    if (this.forceDel || this.recreate) {
                        InitBrokerDatabase.dropLocalTables(db);
                        InitBrokerDatabase.deleteLogFiles();
                        int ct = TransactionMgr.deleteAllTxnFiles();
                        this.log(prAccessor.getString("STR147"));
                    }
                    if (this.upgrade) {
                        this.upgrade(db);
                        this.log(prAccessor.getString("OBJS_UPGRADED"));
                    }
                    if (this.compact) {
                        this.compactDatabase(this.workDir);
                    }
                }
                if (this.create || this.recreate) {
                    if (!dbexists) {
                        db.createNewDb();
                        db.start();
                    }
                    ISchemaDef dbs = db.getSchemaDef();
                    dbs.setStatusListener(new IStatusListener(){

                        @Override
                        public void creatingSchemaObj(int type, String name, boolean created) {
                            switch (type) {
                                case 1: {
                                    if (!created) break;
                                    Object[] parms = new Object[]{name};
                                    InitBrokerDatabase.this.log(MessageFormat.format(prAccessor.getString("CREATING_DBOBJECT"), parms));
                                    break;
                                }
                                case 3: {
                                    if (created) {
                                        Object[] parms = new Object[]{name};
                                        InitBrokerDatabase.this.log(MessageFormat.format(prAccessor.getString("CREATING_INDEX"), parms));
                                        break;
                                    }
                                    Object[] parms = new Object[]{name};
                                    InitBrokerDatabase.this.log(MessageFormat.format(prAccessor.getString("INDEX_NOT_REQUIRED"), parms));
                                    break;
                                }
                                case 2: {
                                    if (!created) break;
                                    Object[] parms = new Object[]{name};
                                    InitBrokerDatabase.this.log(MessageFormat.format(prAccessor.getString("CREATING_TABLE"), parms));
                                    break;
                                }
                            }
                        }

                        @Override
                        public void upgradingSchema(String message) {
                        }
                    });
                    dbs.createAll();
                    IInitDbDBQ initDBQ = DBQSetup.initDbInitDBQ(db);
                    db.setDBVersion();
                    byte mode = 0;
                    if (Config.ENABLE_SECURITY) {
                        mode = (byte)(mode | 1);
                        if (Config.ENABLE_QOPSECURITY) {
                            mode = (byte)(mode | 2);
                        }
                    }
                    initDBQ.initializeSecurityMode(mode);
                    initDBQ.initializeBrokerState(0);
                    this.log(prAccessor.getString("STR180"));
                    initDBQ.initializeSyncPoint();
                    this.log(prAccessor.getString("STR184"));
                    long now = new Date().getTime();
                    initDBQ.initializeLogTime(now);
                    this.log(prAccessor.getString("STR185"));
                    try {
                        if (!new File(Config.LOG_PATH).exists()) {
                            new File(Config.LOG_PATH).mkdirs();
                        }
                        LogFile broker_log = new LogFile(now);
                        broker_log.close();
                    }
                    catch (IOException e) {
                        Db.shutdown();
                        String msg = prAccessor.getString("STR186");
                        Object[] obj = new Object[]{e.toString()};
                        throw new Exception(prMessageFormat.format(msg, obj));
                    }
                    catch (Exception e) {
                        Db.shutdown();
                        String msg = prAccessor.getString("STR187");
                        Object[] obj = new Object[]{e.toString()};
                        throw new Exception(prMessageFormat.format(msg, obj));
                    }
                    this.log(prAccessor.getString("STR188"));
                }
            }
            if (this.getTransactionTable()) {
                try {
                    NoDupDetectDbAdmin ddAdmin = NoDupDetectDb.getAdmin(this.getProps(), db);
                    ddAdmin.setContext(this.getContext());
                    if (this.forceDel || this.recreate) {
                        ddAdmin.drop();
                    }
                    if (this.create || this.recreate) {
                        ddAdmin.init();
                    }
                    if (this.upgrade) {
                        ddAdmin.upgrade(-1);
                    }
                }
                catch (Exception e) {
                    Db.shutdown();
                    throw e;
                }
            }
            db.close();
        }
        catch (EBrokerNameTooLong e) {
            throw e;
        }
        catch (EDatabaseException e) {
            throw new Exception(prAccessor.getString("STR189") + e);
        }
        catch (EGeneralException e) {
            Db.shutdown();
            if (BrokerComponent.getComponentContext() == null) {
                this.log(prAccessor.getString("STR190") + e);
            } else {
                BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR190") + e.getMessage(), (Throwable)e, 2);
            }
            throw e;
        }
        finally {
            Db.shutdown();
        }
    }

    private static void dropLocalTables(Db db) throws EDatabaseException {
        ISchemaDef dbs = db.getSchemaDef();
        dbs.dropAll();
    }

    private static void deleteLogFiles() {
        File fx;
        String x2;
        try {
            File f1 = new File(Config.LOG_FILE_1);
            f1.delete();
        }
        catch (Exception f1) {
            // empty catch block
        }
        try {
            File f2 = new File(Config.LOG_FILE_2);
            f2.delete();
        }
        catch (Exception f2) {
            // empty catch block
        }
        try {
            x2 = Config.LOG_FILE_1 + "x";
            fx = new File(x2);
            fx.delete();
        }
        catch (Exception x2) {
            // empty catch block
        }
        try {
            x2 = Config.LOG_FILE_2 + "x";
            fx = new File(x2);
            fx.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void upgrade(Db db) throws EDatabaseException {
        int vers = db.checkUpgrade();
        if (vers == db.getLatestSupportedDbVersion()) {
            this.log("Upgrade not necessary; db schema version is correct  " + db.getLatestSupportedDbVersion());
            return;
        }
        this.log("Upgrading db from " + vers + " to " + db.getLatestSupportedDbVersion());
        ISchemaDef dbs = db.getSchemaDef();
        dbs.setStatusListener(new IStatusListener(){

            @Override
            public void creatingSchemaObj(int type, String name, boolean created) {
            }

            @Override
            public void upgradingSchema(String message) {
                InitBrokerDatabase.this.log(message);
            }
        });
        dbs.upgradeAll(vers);
        dbs.setStatusListener(null);
        db.setDBVersion();
    }

    public IComponentContext getContext() {
        return this.m_context;
    }

    public void setContext(IComponentContext context) {
        this.m_context = context;
    }

    public Properties getProps() {
        return this.m_props;
    }

    public void setProps(Properties props) {
        this.m_props = props;
    }

    private void log(String out) {
        if (this.getContext() != null) {
            this.getContext().logMessage(out, 3);
        } else {
            OStream.println(out);
        }
    }
}

