/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import progress.message.broker.Broker;
import progress.message.broker.Config;
import progress.message.broker.IIntervalCheck;
import progress.message.zclient.DebugThread;

public class IntervalPollingThread
extends DebugThread {
    private int m_pollingInterval;
    private Hashtable m_monitoredObjects = new Hashtable();

    IntervalPollingThread() {
        super("IntervalPollingThread");
        this.m_pollingInterval = Config.ACKNOWLEDGE_MONITOR_INTERVAL * 1000;
        if (this.DEBUG) {
            this.debug("Constructed; m_pollingInterval= " + this.m_pollingInterval);
        }
    }

    public void startThread() {
        if (this.m_pollingInterval > 0) {
            this.setDaemon(true);
            this.start();
        } else if (this.DEBUG) {
            this.debug("startThread: Thread not started; Config.ACKNOWLEDGE_MONITOR_INTERVAL= " + Config.ACKNOWLEDGE_MONITOR_INTERVAL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(IIntervalCheck monitoredObject) {
        if (this.m_pollingInterval <= 0) {
            return;
        }
        Hashtable hashtable = this.m_monitoredObjects;
        synchronized (hashtable) {
            if (!this.m_monitoredObjects.contains(monitoredObject)) {
                this.m_monitoredObjects.put(monitoredObject, monitoredObject);
                if (this.DEBUG) {
                    this.debug("Registered " + monitoredObject + " size= " + this.m_monitoredObjects.size());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(IIntervalCheck monitoredObject) {
        Hashtable hashtable = this.m_monitoredObjects;
        synchronized (hashtable) {
            Object obj = this.m_monitoredObjects.remove(monitoredObject);
            if (this.DEBUG && obj != null) {
                this.debug("Unregistered " + obj + " size= " + this.m_monitoredObjects.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void threadMain() {
        Object elements = null;
        if (this.DEBUG) {
            this.debug("Started");
        }
        while (!Thread.interrupted()) {
            Broker.getBroker();
            if (Broker.isInShutdown()) break;
            try {
                Thread.sleep(this.m_pollingInterval);
                ArrayList<IIntervalCheck> monobjs = null;
                Hashtable hashtable = this.m_monitoredObjects;
                synchronized (hashtable) {
                    if (this.m_monitoredObjects.isEmpty()) {
                        continue;
                    }
                    monobjs = new ArrayList<IIntervalCheck>();
                    Enumeration objects = this.m_monitoredObjects.elements();
                    while (objects.hasMoreElements()) {
                        IIntervalCheck monitoredObject = (IIntervalCheck)objects.nextElement();
                        monobjs.add(monitoredObject);
                    }
                }
                for (IIntervalCheck monitoredObject : monobjs) {
                    monitoredObject.onEndInterval();
                }
            }
            catch (InterruptedException ex) {
                // empty catch block
                break;
            }
        }
        if (this.DEBUG) {
            this.debug("Exiting size= " + this.m_monitoredObjects.size());
        }
    }
}

