/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import progress.message.broker.ILogRandomAccessFile;
import progress.message.util.ArrayUtil;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;

public final class LogBuffer
extends DebugObject {
    private byte[] m_logBuffer;
    private int m_blockSize;
    private ILogRandomAccessFile m_raf;
    private long m_filepos;
    private int m_currentBlockBegin;
    private int m_unflushedDataStart;
    private boolean m_hasUnflushedData;
    private long[] m_writeCounts;
    private long m_writes;
    private long m_blocksCopied;
    private long m_blocksLoaded;
    private long m_extFlush;
    private boolean DEBUG1;
    private boolean DEBUG0;

    public LogBuffer(String name, ILogRandomAccessFile raf, int blockSize, int numBlocks) {
        super(DebugState.GLOBAL_DEBUG_ON ? "LogBuffer " + name : null);
        this.DEBUG1 = (this.debugFlags & 0x40) > 0;
        this.DEBUG0 = (this.debugFlags & 0x20) > 0;
        this.m_raf = raf;
        this.m_blockSize = blockSize;
        this.m_logBuffer = new byte[blockSize * numBlocks];
        this.m_writeCounts = new long[numBlocks];
        this.reset();
        if (this.DEBUG0) {
            this.debug("Created; numBlocks= " + numBlocks);
        }
    }

    public synchronized int read(int position) {
        int pos = this.m_currentBlockBegin + position;
        return this.m_logBuffer[pos] & 0xFF;
    }

    public synchronized void read(int position, byte[] b, int off, int len) {
        int pos = this.m_currentBlockBegin + position;
        System.arraycopy(this.m_logBuffer, pos, b, off, len);
    }

    public synchronized int readInt(int position) {
        int pos = this.m_currentBlockBegin + position;
        return (this.m_logBuffer[pos++] & 0xFF) << 24 | (this.m_logBuffer[pos++] & 0xFF) << 16 | (this.m_logBuffer[pos++] & 0xFF) << 8 | this.m_logBuffer[pos++] & 0xFF;
    }

    public synchronized void write(int position, int b) {
        int pos = this.m_currentBlockBegin + position;
        this.m_logBuffer[pos] = (byte)b;
        this.markBufferAsDirty();
    }

    public synchronized void writeInt(int position, int i) {
        int pos = this.m_currentBlockBegin + position;
        this.m_logBuffer[pos++] = (byte)(i >>> 24 & 0xFF);
        this.m_logBuffer[pos++] = (byte)(i >>> 16 & 0xFF);
        this.m_logBuffer[pos++] = (byte)(i >>> 8 & 0xFF);
        this.m_logBuffer[pos++] = (byte)(i & 0xFF);
        this.markBufferAsDirty();
    }

    public synchronized long readLong(int position) {
        int pos = this.m_currentBlockBegin + position;
        return ((long)this.m_logBuffer[pos++] & 0xFFL) << 56 | ((long)this.m_logBuffer[pos++] & 0xFFL) << 48 | ((long)this.m_logBuffer[pos++] & 0xFFL) << 40 | ((long)this.m_logBuffer[pos++] & 0xFFL) << 32 | ((long)this.m_logBuffer[pos++] & 0xFFL) << 24 | ((long)this.m_logBuffer[pos++] & 0xFFL) << 16 | ((long)this.m_logBuffer[pos++] & 0xFFL) << 8 | (long)this.m_logBuffer[pos++] & 0xFFL;
    }

    public synchronized void writeLong(int position, long i) {
        int pos = this.m_currentBlockBegin + position;
        this.m_logBuffer[pos++] = (byte)(i >>> 56 & 0xFFL);
        this.m_logBuffer[pos++] = (byte)(i >>> 48 & 0xFFL);
        this.m_logBuffer[pos++] = (byte)(i >>> 40 & 0xFFL);
        this.m_logBuffer[pos++] = (byte)(i >>> 32 & 0xFFL);
        this.m_logBuffer[pos++] = (byte)(i >>> 24 & 0xFFL);
        this.m_logBuffer[pos++] = (byte)(i >>> 16 & 0xFFL);
        this.m_logBuffer[pos++] = (byte)(i >>> 8 & 0xFFL);
        this.m_logBuffer[pos++] = (byte)(i & 0xFFL);
        this.markBufferAsDirty();
    }

    public synchronized void write(int position, byte[] b, int off, int len) {
        int pos = this.m_currentBlockBegin + position;
        System.arraycopy(b, off, this.m_logBuffer, pos, len);
        this.markBufferAsDirty();
    }

    private void markBufferAsDirty() {
        if (this.m_filepos >= 0L) {
            this.m_hasUnflushedData = true;
            if (this.m_unflushedDataStart < 0) {
                this.m_unflushedDataStart = this.m_currentBlockBegin;
            }
        }
    }

    public synchronized void clear(int position, int count) {
        int pos = this.m_currentBlockBegin + position;
        ArrayUtil.clear(this.m_logBuffer, pos, count);
    }

    public synchronized void flushBuffer() throws IOException {
        ++this.m_extFlush;
        this.flushBuffer(true);
    }

    private synchronized void flushBuffer(boolean copyLastBlock) throws IOException {
        if (this.m_hasUnflushedData) {
            int len = this.m_currentBlockBegin - this.m_unflushedDataStart + this.m_blockSize;
            if (this.DEBUG1) {
                long firstBlock = (this.m_filepos + (long)this.m_unflushedDataStart) / (long)this.m_blockSize;
                long lastBlock = (this.m_filepos + (long)this.m_currentBlockBegin) / (long)this.m_blockSize;
                this.debug("flushBuffer: flushing; firstBlock= " + firstBlock + " lastblock= " + lastBlock + " len= " + len + " m_extFlush= " + this.m_extFlush);
            }
            this.m_raf.seek(this.m_filepos + (long)this.m_unflushedDataStart);
            this.m_raf.write(this.m_logBuffer, this.m_unflushedDataStart, len);
            if (this.m_currentBlockBegin > 0 && copyLastBlock) {
                if (this.DEBUG) {
                    this.debug("Copying last block to start of buffer; m_currentBlockBegin (before copy)= " + this.m_currentBlockBegin);
                }
                System.arraycopy(this.m_logBuffer, this.m_currentBlockBegin, this.m_logBuffer, 0, this.m_blockSize);
                this.m_filepos += (long)this.m_currentBlockBegin;
                this.m_currentBlockBegin = 0;
                ++this.m_blocksCopied;
            }
            this.m_hasUnflushedData = false;
            this.m_unflushedDataStart = -1;
            if (this.DEBUG0) {
                ++this.m_writes;
                int n = len / this.m_blockSize - 1;
                this.m_writeCounts[n] = this.m_writeCounts[n] + 1L;
                if (this.m_writes % 50000L == 0L) {
                    StringBuffer buf = new StringBuffer();
                    buf.append("BufferFlush (50000): totFlush: ");
                    buf.append(this.m_writes);
                    buf.append("; NumExtFlush: ");
                    buf.append(this.m_extFlush);
                    buf.append("; NumCopied: ");
                    buf.append(this.m_blocksCopied);
                    buf.append("; NumLoaded: ");
                    buf.append(this.m_blocksLoaded);
                    buf.append(": ");
                    for (int i = 0; i < this.m_writeCounts.length; ++i) {
                        if (this.m_writeCounts[i] == 0L) continue;
                        buf.append('[');
                        buf.append("" + (i + 1));
                        buf.append(", ");
                        buf.append(this.m_writeCounts[i]);
                        buf.append("] ");
                        this.m_writeCounts[i] = 0L;
                    }
                    this.debug(buf.toString());
                    this.m_blocksCopied = 0L;
                    this.m_blocksLoaded = 0L;
                    this.m_extFlush = 0L;
                }
            }
        }
    }

    public synchronized int setCurrentBlock(long blockNum, boolean loadBlock) throws IOException {
        long newFilePtr = blockNum * (long)this.m_blockSize;
        int ct = 0;
        if (this.DEBUG) {
            int unflushed = 0;
            if (this.m_hasUnflushedData) {
                unflushed = this.m_currentBlockBegin + this.m_blockSize - this.m_unflushedDataStart;
            }
            this.debug("Calling setCurrentBlock; blockNum= " + blockNum + " loadBlock= " + loadBlock + " m_filepos= " + this.m_filepos + " newFilePtr= " + newFilePtr + " m_currentBlockBegin= " + this.m_currentBlockBegin + " unflushedLen= " + unflushed);
        }
        if (this.m_filepos < 0L) {
            if (loadBlock) {
                if (newFilePtr > this.m_raf.length()) {
                    return -1;
                }
                ct = this.seekAndReadRAF(newFilePtr);
                if (this.DEBUG) {
                    this.debug("setCurrentBlock case1: loaded block " + blockNum + " into buf[0]; newFilePtr= " + newFilePtr);
                }
            }
            this.m_currentBlockBegin = 0;
            this.m_filepos = newFilePtr;
            return ct;
        }
        if (newFilePtr < this.m_filepos) {
            if (loadBlock) {
                if (this.DEBUG) {
                    this.debug("SetCurrentBlock case2: loading earlier block; m_filepos= " + this.m_filepos + " newFilePtr= " + newFilePtr);
                }
                ct = this.seekAndReadRAF(newFilePtr);
            }
            this.m_currentBlockBegin = 0;
            this.m_filepos = newFilePtr;
            this.m_hasUnflushedData = false;
            this.m_unflushedDataStart = -1;
        } else if (newFilePtr >= this.m_filepos + (long)this.m_logBuffer.length) {
            if (this.DEBUG) {
                this.debug("SetCurrentBlock case3: positioning beyond the buffer fileSlicePtr= " + this.m_filepos + " newFilePtr= " + newFilePtr);
            }
            if (this.m_hasUnflushedData) {
                this.flushBuffer(false);
            }
            if (loadBlock) {
                if (newFilePtr > this.m_raf.length()) {
                    return -1;
                }
                if (this.DEBUG) {
                    this.debug("SetCurrentBlock case3: loading newer block; m_filepos= " + this.m_filepos + " newFilePtr= " + newFilePtr);
                }
                ct = this.seekAndReadRAF(newFilePtr);
            }
            this.m_currentBlockBegin = 0;
            this.m_filepos = newFilePtr;
        } else {
            int newBlockOffset = (int)(newFilePtr - this.m_filepos);
            if (newBlockOffset > this.m_currentBlockBegin && loadBlock) {
                if (newFilePtr > this.m_raf.length()) {
                    return -1;
                }
                this.m_raf.seek(newFilePtr);
                ct = this.m_raf.readRAF(this.m_logBuffer, newBlockOffset, this.m_blockSize);
                ++this.m_blocksLoaded;
                if (this.DEBUG1) {
                    this.debug("setCurrentBlock case4;  loaded block into pos " + newBlockOffset);
                }
            }
            if (this.m_hasUnflushedData && newBlockOffset < this.m_unflushedDataStart) {
                if (this.DEBUG1) {
                    this.debug("setCurrentBlock case4;  discarding unflushed data  newBlockOffset= " + newBlockOffset + " m_unflushedDataStart= " + this.m_unflushedDataStart);
                }
                this.m_hasUnflushedData = false;
                this.m_unflushedDataStart = -1;
            }
            if (this.DEBUG) {
                this.debug("setCurrentBlock case4; repositioning within buffer: old m_currentBlockBegin= " + this.m_currentBlockBegin + " newBlockOffset= " + newBlockOffset);
            }
            this.m_currentBlockBegin = newBlockOffset;
        }
        if (this.DEBUG) {
            this.debug("setCurrentBlock completed " + blockNum + " firstBlock= " + this.m_filepos / (long)this.m_blockSize + " m_extFlush= " + this.m_extFlush);
        }
        return ct;
    }

    private int seekAndReadRAF(long newFilePtr) throws IOException {
        this.m_raf.seek(newFilePtr);
        int ct = this.m_raf.readRAF(this.m_logBuffer, 0, this.m_blockSize);
        ++this.m_blocksLoaded;
        return ct;
    }

    public synchronized void reset() {
        this.m_filepos = -1L;
        this.m_currentBlockBegin = 0;
        this.m_hasUnflushedData = false;
        this.m_unflushedDataStart = -1;
        for (int i = 0; i < this.m_writeCounts.length; ++i) {
            this.m_writeCounts[i] = 0L;
        }
    }
}

