/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.sonicmq.util.action.Action;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BatchSplitEvt;
import progress.message.broker.ChannelTxnSyncEvt;
import progress.message.broker.ClientAckEvt;
import progress.message.broker.ConnectEvt;
import progress.message.broker.ConnectionIdEvt;
import progress.message.broker.CounterEvt;
import progress.message.broker.DeleteEndEvt;
import progress.message.broker.DeliveryListEvt;
import progress.message.broker.DummyNonLoggableEvt;
import progress.message.broker.DurableDisconnectEvt;
import progress.message.broker.DurableSMOUpdateEvt;
import progress.message.broker.DurableStatsEvent;
import progress.message.broker.DurableTrimEvt;
import progress.message.broker.ECorruptLogEvent;
import progress.message.broker.EInvalidLogEvent;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.EOFEvent;
import progress.message.broker.EOLEvent;
import progress.message.broker.EUnknownLogEventType;
import progress.message.broker.GlobalTxnAbortEvt;
import progress.message.broker.GlobalTxnBeginEvt;
import progress.message.broker.GlobalTxnCommitEvt;
import progress.message.broker.GlobalTxnEndEvt;
import progress.message.broker.GlobalTxnJoinEvt;
import progress.message.broker.GlobalTxnPrecommitEvt;
import progress.message.broker.GlobalTxnPrepareEvt;
import progress.message.broker.GlobalTxnResumeEvt;
import progress.message.broker.GlobalTxnSuspendEvt;
import progress.message.broker.GlobalTxnSyncEvt;
import progress.message.broker.GroupMsgAllocationEvt;
import progress.message.broker.GroupMsgDeallocationEvt;
import progress.message.broker.GuarMsgEvt;
import progress.message.broker.InterbrokerHook;
import progress.message.broker.MsgDeliveredEvt;
import progress.message.broker.MsgRestoreBeginEvt;
import progress.message.broker.MsgRestoreEndEvt;
import progress.message.broker.NoDupCommitBegEvt;
import progress.message.broker.OperationContextAddEvt;
import progress.message.broker.OperationContextRemoveEvt;
import progress.message.broker.ProxyDoubtResolvedEvt;
import progress.message.broker.QueueMsgAckedEvt;
import progress.message.broker.QueueMsgEvt;
import progress.message.broker.QueueMsgGroupAssignEvt;
import progress.message.broker.QueueMsgGroupUnassignEvt;
import progress.message.broker.QueueMsgMoveEvt;
import progress.message.broker.QueueMsgMoveToTopicEvt;
import progress.message.broker.RMInboundEndEvt;
import progress.message.broker.RMInboundEvt;
import progress.message.broker.RMOutboundEndEvt;
import progress.message.broker.RMOutboundEvt;
import progress.message.broker.RecoveryMgr;
import progress.message.broker.ReplyAckEvt;
import progress.message.broker.SubscribeEvt;
import progress.message.broker.SubscribeEvtForSelector;
import progress.message.broker.SyncBeginEvt;
import progress.message.broker.SyncCounterEvt;
import progress.message.broker.SyncDeleteMsgEvt;
import progress.message.broker.SyncEndEvt;
import progress.message.broker.SyncGroupMsgAllocationEvt;
import progress.message.broker.SyncGuarMsgEvt;
import progress.message.broker.SyncMsgRestoreEvt;
import progress.message.broker.SyncOperationContextEvt;
import progress.message.broker.SyncQueueMsgEvt;
import progress.message.broker.SyncQueueMsgGroupsEvt;
import progress.message.broker.SyncQueueMsgMoveEvt;
import progress.message.broker.SyncQueueMsgMoveToTopicEvt;
import progress.message.broker.SyncRMInboundEvt;
import progress.message.broker.SyncRMOutboundEvt;
import progress.message.broker.SyncSubscriptionDeleteEvt;
import progress.message.broker.SyncTempQueueEvt;
import progress.message.broker.SyncTxnEvt;
import progress.message.broker.TempQueueCreationEvt;
import progress.message.broker.TempQueueDeletionEvt;
import progress.message.broker.TxnAbortBeginEvt;
import progress.message.broker.TxnAbortEvt;
import progress.message.broker.TxnBeginEvt;
import progress.message.broker.TxnCommitEvt;
import progress.message.broker.TxnPrecommitEvt;
import progress.message.broker.TxnPrepareEvt;
import progress.message.broker.UnfilteredEvt;
import progress.message.broker.UnregisterEvt;
import progress.message.broker.UnsubscribeAllEvt;
import progress.message.broker.UnsubscribeEvt;
import progress.message.broker.gs.GSSubscribeEvt;
import progress.message.gr.RouterManager;
import progress.message.util.DebugState;
import progress.message.util.StreamUtil;
import progress.message.zclient.DebugObject;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.IStateEvent;

public abstract class LogEvent
extends DebugObject
implements Action,
IStateEvent {
    private static final byte STREAM_VERSION = 2;
    static final int BASELENGTH = 14;
    public static final short NON_LOGGABLE_EVT = -3;
    public static final short EOF_TYPE = -2;
    public static final short EOL_TYPE = -1;
    public static final short GUAR_MSG_TYPE_V4_0 = 1;
    public static final short MSG_DELIVERED_TYPE = 2;
    public static final short SUBSCRIBE_TYPE_V4_0 = 3;
    public static final short UNSUBSCRIBE_ALL_TYPE = 4;
    public static final short SYNC_BEGIN_TYPE = 5;
    public static final short SYNC_END_TYPE = 6;
    public static final short SYNC_GUAR_MSG_TYPE = 7;
    public static final short QUEUE_MSG_TYPE = 8;
    public static final short QUEUE_MSG_SAVED_TYPE = 9;
    public static final short QUEUE_MSG_ACKED_TYPE = 10;
    public static final short SYNC_QUEUE_MSG_TYPE = 11;
    public static final short TXN_PRECOMMIT_TYPE = 12;
    public static final short TXN_COMMIT_TYPE = 13;
    public static final short TXN_PREPARE_TYPE = 14;
    public static final short TXN_BEGIN_TYPE = 15;
    public static final short TXN_ABORT_TYPE = 16;
    public static final short SYNC_TXN_TYPE = 17;
    public static final short UNSUBSCRIBE_TYPE_V6_2 = 18;
    public static final short CONNECT_TYPE = 19;
    public static final short UNREGISTER_TYPE = 20;
    public static final short CLIENT_ACK_TYPE_V4_0 = 23;
    public static final short IB_GUAR_ACK_DONE_TYPE = 24;
    public static final short IB_GUAR_ACK_XCHG_TYPE = 25;
    public static final short QUEUE_MSG_SEND_TYPE = 26;
    public static final short QUEUE_MSG_MOVE_TYPE = 27;
    public static final short GR_GUAR_QUEUEACK_DONE_TYPE = 28;
    public static final short GR_GUAR_QUEUEACK_XCHG_TYPE = 29;
    public static final short GR_INDOUBT_QREENQUEUE_TYPE = 30;
    public static final short NO_DUP_COMMIT_BEG_TYPE = 31;
    public static final short SYNC_TXN_TYPE_V3C1 = 32;
    public static final short GLB_TXN_BEGIN_TYPE = 33;
    public static final short GLB_TXN_END_TYPE = 34;
    public static final short GLB_TXN_PREPARE_TYPE = 35;
    public static final short GLB_TXN_PRECOMMIT_TYPE = 36;
    public static final short GLB_TXN_COMMIT_TYPE = 37;
    public static final short GLB_TXN_ABORT_TYPE = 38;
    public static final short GLB_TXN_SYNC_TYPE = 39;
    public static final short NO_DUP_COMMIT_BEG_TYPE_V4_0 = 40;
    public static final short CHANNEL_TXN_SYNC_TYPE = 41;
    public static final short SUBSCRIBE_FOR_SELECTOR_TYPE_V4_0 = 42;
    public static final short UNFILTERED_TYPE = 43;
    public static final short UNUSED_TYPE = 44;
    public static final short CONNECTION_ID_TYPE = 45;
    public static final short GUAR_MSG_TYPE_V5_0 = 48;
    public static final short SYNC_QUEUE_MSG_TYPE_V5_0 = 49;
    public static final short SYNC_TXN_TYPE_V500 = 50;
    public static final short GLB_TXN_SYNC_TYPE_V500 = 51;
    public static final short CHANNEL_TXN_SYNC_TYPE_V500 = 52;
    public static final short TXN_PREPARE_TYPE_V500 = 53;
    public static final short GLB_TXN_PREPARE_TYPE_V500 = 54;
    public static final short TXN_PRECOMMIT_TYPE_V500 = 55;
    public static final short GLB_TXN_PRECOMMIT_TYPE_V500 = 56;
    public static final short GS_SUBSCRIBE_TYPE_V5_0 = 57;
    public static final short QUEUE_MSG_TYPE_V5_0 = 58;
    public static final short SUBSCRIBE_TYPE_V5_0 = 59;
    public static final short SUBSCRIBE_FOR_SELECTOR_TYPE_V5_0 = 60;
    public static final short DURABLE_DISCONNECT_TYPE = 61;
    public static final short PROXY_DOUBT_RESOLVED_TYPE = 62;
    public static final short DELIVERY_LIST_TYPEV6_1 = 63;
    public static final short TXN_ABORT_BEGIN_TYPE = 64;
    public static final short DURABLE_STATS_TYPE = 65;
    public static final short DELETE_END_TYPE = 66;
    public static final short SYNC_SUBSCRIPTION_DELETE_TYPE = 67;
    public static final short CLIENT_ACK_EVT_TYPE_V5_0 = 68;
    public static final short GUAR_MSG_TYPE_V5_0_2 = 69;
    public static final short QUEUE_MSG_TYPE_V5_0_2 = 70;
    public static final short SYNC_QUEUE_MSG_TYPE_V5_0_2 = 71;
    public static final short BATCH_SPLIT_TYPE = 72;
    public static final short DURABLE_SMO_UPDATE_TYPE = 73;
    public static final short SYNC_DELETE_MSG_EVT_6_1 = 74;
    public static final short QUEUE_MSG_TYPE_V5_1 = 75;
    public static final short QUEUE_MSG_SEND_TYPE_V5_1 = 76;
    public static final short SYNC_QUEUE_MSG_TYPE_V5_1 = 77;
    public static final short QUEUE_MSG_MOVE_TYPE_V5_1 = 78;
    public static final short TEMP_QUEUE_CREATION_EVT = 79;
    public static final short TEMP_QUEUE_DELETION_EVT = 80;
    public static final short SYNC_TEMP_QUEUE_EVT = 81;
    public static final short TXN_PRECOMMIT_TYPE_V6_0 = 82;
    public static final short TXN_COMMIT_TYPE_V6_0 = 83;
    public static final short TXN_PREPARE_TYPE_V6_0 = 84;
    public static final short TXN_BEGIN_TYPE_V6_0 = 85;
    public static final short TXN_ABORT_TYPE_V6_0 = 86;
    public static final short TXN_ABORT_BEGIN_TYPE_V6_0 = 87;
    public static final short NO_DUP_COMMIT_BEG_TYPE_V6_0 = 88;
    public static final short SYNC_TXN_TYPE_V6_0 = 89;
    public static final short CHANNEL_TXN_SYNC_TYPE_V6_0 = 90;
    public static final short GLB_TXN_BEGIN_TYPE_V6_0 = 91;
    public static final short GLB_TXN_END_TYPE_V6_0 = 92;
    public static final short GLB_TXN_JOIN_TYPE_V6_0 = 93;
    public static final short GLB_TXN_SUSPEND_TYPE_V6_0 = 94;
    public static final short GLB_TXN_RESUME_TYPE_V6_0 = 95;
    public static final short GLB_TXN_PREPARE_TYPE_V6_0 = 96;
    public static final short GLB_TXN_PRECOMMIT_TYPE_V6_0 = 97;
    public static final short GLB_TXN_COMMIT_TYPE_V6_0 = 98;
    public static final short GLB_TXN_ABORT_TYPE_V6_0 = 99;
    public static final short GLB_TXN_SYNC_TYPE_V6_0 = 100;
    public static final short REPLY_ACK_TYPE = 101;
    public static final short COUNTER_TYPE = 102;
    public static final short SYNC_COUNTER_TYPE = 103;
    public static final short QUEUE_MSG_ACKED_TYPE_V6_0 = 104;
    public static final short CLIENT_ACK_EVT_TYPE_V6_0 = 105;
    public static final short SYNC_GUAR_MSG_EVT_V6_0 = 106;
    public static final short SUBSCRIBE_TYPE_V6_0 = 107;
    public static final short SUBSCRIBE_FOR_SELECTOR_TYPE_V6_0 = 108;
    public static final short GS_SUBSCRIBE_TYPE_V6_0 = 109;
    public static final short GUAR_MSG_EVT_V6_2 = 110;
    public static final short DELIVERY_LIST_EVT_V6_2 = 111;
    public static final short SUBSCRIBE_TYPE = 112;
    public static final short SUBSCRIBE_FOR_SELECTOR_TYPE = 113;
    public static final short GS_SUBSCRIBE_TYPE = 114;
    public static final short UNSUBSCRIBE_TYPE = 115;
    public static final short QUEUE_MSG_MOVE_TO_TOPIC_TYPE_V7_0 = 116;
    public static final short CLIENT_ACK_EVT_TYPE = 117;
    public static final short SYNC_DELETE_MSG_EVT = 118;
    public static final short RM_INBOUND_EVT = 119;
    public static final short RM_INBOUND_END_EVT = 120;
    public static final short SYNC_RM_INBOUND_EVT = 121;
    public static final short RM_OUTBOUND_EVT = 122;
    public static final short RM_OUTBOUND_END_EVT = 123;
    public static final short SYNC_RM_OUTBOUND_EVT = 124;
    public static final short OPERATION_CONTEXT_ADD_EVT = 125;
    public static final short OPERATION_CONTEXT_REMOVE_EVT = 126;
    public static final short SYNC_OPERATION_CONTEXT_EVT = 127;
    public static final short RM_INBOUND_EVT_V7_5 = 128;
    public static final short RM_INBOUND_END_EVT_V7_5 = 129;
    public static final short SYNC_RM_INBOUND_EVT_V7_5 = 130;
    public static final short RM_OUTBOUND_EVT_V7_5 = 131;
    public static final short RM_OUTBOUND_END_EVT_V7_5 = 132;
    public static final short SYNC_RM_OUTBOUND_EVT_V7_5 = 133;
    public static final short OPERATION_CONTEXT_ADD_EVT_V7_5 = 134;
    public static final short SYNC_OPERATION_CONTEXT_EVT_V7_5 = 135;
    public static final short AVAILABLE_136_V7_6_OR_LATER = 136;
    public static final short AVAILABLE_137_V7_6_OR_LATER = 137;
    public static final short AVAILABLE_138_V7_6_OR_LATER = 138;
    public static final short AVAILABLE_139_V7_6_OR_LATER = 139;
    public static final short AVAILABLE_140_V7_6_OR_LATER = 140;
    public static final short AVAILABLE_141_V7_6_OR_LATER = 141;
    public static final short AVAILABLE_142_V7_6_OR_LATER = 142;
    public static final short AVAILABLE_143_V7_6_OR_LATER = 143;
    public static final short AVAILABLE_144_V7_6_OR_LATER = 144;
    public static final short AVAILABLE_145_V7_6_OR_LATER = 145;
    public static final short AVAILABLE_146_V7_6_OR_LATER = 146;
    public static final short AVAILABLE_147_V7_6_OR_LATER = 147;
    public static final short AVAILABLE_148_V7_6_OR_LATER = 148;
    public static final short AVAILABLE_149_V7_6_OR_LATER = 149;
    public static final short AVAILABLE_150_V7_6_OR_LATER = 150;
    public static final short DURABLE_SUBSCRIPTION_MSG_TRIM_EVT_V7_0_2_99 = 151;
    public static final short MSG_RESTORE_BEGIN_EVT = 152;
    public static final short MSG_RESTORE_END_EVT = 153;
    public static final short SYNC_MSG_RESTORE_EVT = 154;
    public static final short GUAR_MSG_EVT_V7_6_2_HF = 155;
    public static final short DELIVERY_LIST_EVT_V7_6_2_HF = 156;
    public static final short GUAR_MSG_EVT_V7_6_2_HF_V2 = 180;
    public static final short DELIVERY_LIST_EVT_V7_6_2_HF_V2 = 181;
    public static final short GUAR_MSG_TYPE = 180;
    public static final short DELIVERY_LIST_TYPE = 181;
    public static final short GROUP_MSG_ALLOCATE_EVT = 182;
    public static final short GROUP_MSG_DEALLOCATE_EVT = 183;
    public static final short SYNC_GROUP_MSG_ALLOCATE_EVT = 184;
    public static final short SYNC_QUEUE_MSG_MOVE_TYPE = 185;
    public static final short SYNC_QUEUE_MSG_MOVE_TO_TOPIC_TYPE = 186;
    public static final short QUEUE_MSG_GROUP_ASSIGN_EVT = 187;
    public static final short QUEUE_MSG_GROUP_UNASSIGN_EVT = 188;
    public static final short SYNC_QUEUE_MSG_GROUPS_EVT = 189;
    private boolean m_logged;
    private boolean m_inQueue;
    private boolean m_canceled;
    private boolean m_waitingForFlush;
    private int m_memsize;
    private boolean m_recoverable = true;
    private boolean m_replicateOnly = false;
    private IStateEvent m_prev;
    private IStateEvent m_next;
    private volatile byte m_flushState;
    private volatile boolean m_notify;
    private volatile boolean m_canBeDelayed = false;
    protected long m_seqno = -1L;
    protected long m_actionTrackingNumber = -1L;
    private boolean m_isAction = false;
    private int m_numSeqNos = 1;
    private IStateEvent m_replOnlyEvt;

    protected LogEvent() {
        super(DebugState.GLOBAL_DEBUG_ON ? "LogEvent" : null);
    }

    protected LogEvent(LogEvent evt) {
        super(DebugState.GLOBAL_DEBUG_ON ? "LogEvent" : null);
        this.m_logged = evt.m_logged;
        this.m_inQueue = evt.m_inQueue;
        this.m_memsize = evt.m_memsize;
        this.m_recoverable = evt.m_recoverable;
        this.m_prev = evt.m_prev;
        this.m_next = evt.m_next;
        this.m_flushState = evt.m_flushState;
        this.m_notify = evt.m_notify;
        this.m_canBeDelayed = evt.m_canBeDelayed;
        this.m_seqno = evt.m_seqno;
        this.m_actionTrackingNumber = evt.m_actionTrackingNumber;
        this.m_isAction = evt.m_isAction;
        this.m_numSeqNos = evt.m_numSeqNos;
        this.m_replicateOnly = evt.m_replicateOnly;
    }

    synchronized boolean isLogged() {
        return this.m_logged;
    }

    synchronized void setLogged(boolean logged) {
        this.m_logged = logged;
    }

    @Override
    public synchronized boolean isInQueue() {
        return this.m_inQueue;
    }

    @Override
    public synchronized void setInQueue(boolean iq) {
        this.m_inQueue = iq;
    }

    @Override
    public synchronized boolean isReplicateOnly() {
        return this.m_replicateOnly;
    }

    public final synchronized void setReplicateOnly(boolean replicateOnly) {
        this.m_replicateOnly = replicateOnly;
    }

    @Override
    public boolean delayLogLimiterRelease() {
        return false;
    }

    @Override
    public synchronized boolean cancelLog() {
        if (!this.m_inQueue || this.m_waitingForFlush) {
            return false;
        }
        this.m_canceled = true;
        this.m_inQueue = false;
        return true;
    }

    @Override
    public synchronized void setWaitingForFlush() {
        this.m_waitingForFlush = true;
    }

    public synchronized boolean removedFromLog() {
        return this.m_canceled;
    }

    @Override
    public void setAction(boolean value) {
        this.m_isAction = value;
    }

    @Override
    public boolean isAction() {
        return this.m_isAction;
    }

    @Override
    public IStateEvent getNext() {
        return this.m_next;
    }

    @Override
    public void setNext(IStateEvent next) {
        this.m_next = next;
    }

    @Override
    public IStateEvent getPrev() {
        return this.m_prev;
    }

    @Override
    public void setPrev(IStateEvent prev) {
        this.m_prev = prev;
    }

    @Override
    public abstract short type();

    @Override
    public boolean usesClientRegistry() {
        return false;
    }

    @Override
    public boolean usesSubscriptionTable() {
        return false;
    }

    @Override
    public boolean mustBeBuffered() {
        return true;
    }

    @Override
    public long getClientID() {
        return -1L;
    }

    @Override
    public synchronized int getNumSeqNos() {
        return this.m_numSeqNos;
    }

    public final synchronized void setNumSeqNos(int numSeqNos) {
        this.m_numSeqNos = numSeqNos;
    }

    @Override
    public long getSeqNo() {
        return this.m_seqno;
    }

    @Override
    public IStateEvent getReplOnlyEvt() {
        return this.m_replOnlyEvt;
    }

    @Override
    public void setReplOnlyEvt(IStateEvent replOnlyEvt) {
        this.m_replOnlyEvt = replOnlyEvt;
    }

    @Override
    public boolean hasValidSeqNo() {
        return this.m_seqno >= 0L || this.isHighPriority();
    }

    @Override
    public void setSeqNo(long seqno) {
        this.m_seqno = seqno;
    }

    @Override
    public void setHighPriority() {
        this.m_seqno = -2L;
    }

    @Override
    public boolean isHighPriority() {
        return this.m_seqno == -2L;
    }

    @Override
    public void setActionTrackingNum(long trackingNumber) {
        this.m_actionTrackingNumber = trackingNumber;
    }

    @Override
    public long getActionTrackingNum() {
        if (this.m_actionTrackingNumber == -1L) {
            return this.getSeqNo();
        }
        return this.m_actionTrackingNumber;
    }

    public void setCanBeDelayed(boolean canDelay) {
        this.m_canBeDelayed = canDelay;
    }

    @Override
    public boolean canBeDelayed() {
        return this.m_canBeDelayed;
    }

    public boolean isFlushed() {
        return this.m_flushState == 1;
    }

    protected abstract void writeBodyToLog(OutputStream var1, long var2) throws IOException, ELogEventTooLong;

    protected void readBodyFromLog(InputStream in) throws IOException, EInvalidLogEvent, EMgramFormatError {
        this.readBodyFromStream(in, false);
    }

    protected abstract int memSizeBody();

    @Override
    public void saveMemory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForFlush() throws InterruptedException {
        if (this.m_flushState == 0) {
            this.m_notify = true;
            LogEvent logEvent = this;
            synchronized (logEvent) {
                while (this.m_flushState == 0) {
                    this.wait();
                }
            }
        }
        this.m_waitingForFlush = false;
        if (this.m_flushState == 2) {
            throw new InterruptedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyFlushed() {
        this.m_flushState = 1;
        if (this.m_notify) {
            LogEvent logEvent = this;
            synchronized (logEvent) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFlushUnflushable() {
        this.m_flushState = (byte)2;
        if (this.m_notify) {
            LogEvent logEvent = this;
            synchronized (logEvent) {
                this.notifyAll();
            }
        }
    }

    protected void onFlush() {
    }

    public abstract void redo(RecoveryMgr var1);

    public static final LogEvent readFromLog(InputStream in) throws EInvalidLogEvent, IOException, EMgramFormatError {
        long seqno = StreamUtil.readLong(in);
        short type = StreamUtil.readShort(in);
        LogEvent evt = LogEvent.getEventObject(type);
        evt.m_logged = true;
        evt.m_seqno = seqno;
        evt.readBodyFromLog(in);
        if (StreamUtil.readInt(in) != (int)seqno) {
            throw new ECorruptLogEvent();
        }
        if (evt.CALLBACK) {
            Object[] params = new Object[]{evt};
            evt.callback("Log Event Read", 2, params);
        }
        return evt;
    }

    public static LogEvent getEventObject(short type) throws EUnknownLogEventType {
        LogEvent evt = null;
        switch (type) {
            case 1: {
                evt = new GuarMsgEvt(1);
                break;
            }
            case 48: {
                evt = new GuarMsgEvt(48);
                break;
            }
            case 69: {
                evt = new GuarMsgEvt(69);
                break;
            }
            case 110: {
                evt = new GuarMsgEvt(110);
                break;
            }
            case 155: {
                evt = new GuarMsgEvt(155);
                break;
            }
            case 180: {
                evt = new GuarMsgEvt(180);
                break;
            }
            case 2: {
                evt = new MsgDeliveredEvt();
                break;
            }
            case 3: {
                evt = new SubscribeEvt(3);
                break;
            }
            case 42: {
                evt = new SubscribeEvtForSelector(42);
                break;
            }
            case 59: {
                evt = new SubscribeEvt(59);
                break;
            }
            case 60: {
                evt = new SubscribeEvtForSelector(60);
                break;
            }
            case 107: {
                evt = new SubscribeEvt(107);
                break;
            }
            case 108: {
                evt = new SubscribeEvtForSelector(108);
                break;
            }
            case 112: {
                evt = new SubscribeEvt(112);
                break;
            }
            case 113: {
                evt = new SubscribeEvtForSelector(113);
                break;
            }
            case 57: {
                evt = new GSSubscribeEvt(57);
                break;
            }
            case 109: {
                evt = new GSSubscribeEvt(109);
                break;
            }
            case 114: {
                evt = new GSSubscribeEvt(114);
                break;
            }
            case 4: {
                evt = new UnsubscribeAllEvt();
                break;
            }
            case -2: {
                evt = new EOFEvent();
                break;
            }
            case -1: {
                evt = new EOLEvent();
                break;
            }
            case 5: {
                evt = new SyncBeginEvt();
                break;
            }
            case 6: {
                evt = new SyncEndEvt();
                break;
            }
            case 7: {
                evt = new SyncGuarMsgEvt(7);
                break;
            }
            case 106: {
                evt = new SyncGuarMsgEvt(106);
                break;
            }
            case 17: {
                evt = new SyncTxnEvt(17);
                break;
            }
            case 32: {
                evt = new SyncTxnEvt(32);
                break;
            }
            case 50: {
                evt = new SyncTxnEvt(50);
                break;
            }
            case 89: {
                evt = new SyncTxnEvt(89);
                break;
            }
            case 15: {
                evt = new TxnBeginEvt(15);
                break;
            }
            case 85: {
                evt = new TxnBeginEvt(85);
                break;
            }
            case 14: {
                evt = new TxnPrepareEvt(14);
                break;
            }
            case 53: {
                evt = new TxnPrepareEvt(53);
                break;
            }
            case 84: {
                evt = new TxnPrepareEvt(84);
                break;
            }
            case 12: {
                evt = new TxnPrecommitEvt(12);
                break;
            }
            case 55: {
                evt = new TxnPrecommitEvt(55);
                break;
            }
            case 82: {
                evt = new TxnPrecommitEvt(82);
                break;
            }
            case 13: {
                evt = new TxnCommitEvt(13);
                break;
            }
            case 83: {
                evt = new TxnCommitEvt(83);
                break;
            }
            case 16: {
                evt = new TxnAbortEvt(16);
                break;
            }
            case 86: {
                evt = new TxnAbortEvt(86);
                break;
            }
            case 33: {
                evt = new GlobalTxnBeginEvt(33);
                break;
            }
            case 91: {
                evt = new GlobalTxnBeginEvt(91);
                break;
            }
            case 35: {
                evt = new GlobalTxnPrepareEvt(35);
                break;
            }
            case 54: {
                evt = new GlobalTxnPrepareEvt(54);
                break;
            }
            case 96: {
                evt = new GlobalTxnPrepareEvt(96);
                break;
            }
            case 36: {
                evt = new GlobalTxnPrecommitEvt(36);
                break;
            }
            case 56: {
                evt = new GlobalTxnPrecommitEvt(56);
                break;
            }
            case 97: {
                evt = new GlobalTxnPrecommitEvt(97);
                break;
            }
            case 37: {
                evt = new GlobalTxnCommitEvt(37);
                break;
            }
            case 98: {
                evt = new GlobalTxnCommitEvt(98);
                break;
            }
            case 38: {
                evt = new GlobalTxnAbortEvt(38);
                break;
            }
            case 99: {
                evt = new GlobalTxnAbortEvt(99);
                break;
            }
            case 93: {
                evt = new GlobalTxnJoinEvt(93);
                break;
            }
            case 92: {
                evt = new GlobalTxnEndEvt(92);
                break;
            }
            case 94: {
                evt = new GlobalTxnSuspendEvt(94);
                break;
            }
            case 95: {
                evt = new GlobalTxnResumeEvt(95);
                break;
            }
            case 39: {
                evt = new GlobalTxnSyncEvt(39);
                break;
            }
            case 51: {
                evt = new GlobalTxnSyncEvt(51);
                break;
            }
            case 100: {
                evt = new GlobalTxnSyncEvt(100);
                break;
            }
            case 41: {
                evt = new ChannelTxnSyncEvt(41);
                break;
            }
            case 52: {
                evt = new ChannelTxnSyncEvt(52);
                break;
            }
            case 90: {
                evt = new ChannelTxnSyncEvt(90);
                break;
            }
            case 115: {
                evt = new UnsubscribeEvt(115);
                break;
            }
            case 18: {
                evt = new UnsubscribeEvt(18);
                break;
            }
            case 19: {
                evt = new ConnectEvt();
                break;
            }
            case 20: {
                evt = new UnregisterEvt();
                break;
            }
            case 23: {
                evt = new ClientAckEvt(23);
                break;
            }
            case 68: {
                evt = new ClientAckEvt(68);
                break;
            }
            case 105: {
                evt = new ClientAckEvt(105);
                break;
            }
            case 117: {
                evt = new ClientAckEvt(117);
                break;
            }
            case 24: 
            case 25: {
                evt = InterbrokerHook.constructIBLogEvent(type);
                break;
            }
            case 8: 
            case 58: 
            case 75: {
                evt = new QueueMsgEvt(type);
                break;
            }
            case 70: {
                evt = new QueueMsgEvt(70);
                break;
            }
            case 11: 
            case 49: 
            case 71: 
            case 77: {
                evt = new SyncQueueMsgEvt(type);
                break;
            }
            case 10: 
            case 104: {
                evt = new QueueMsgAckedEvt(type);
                break;
            }
            case 27: 
            case 78: {
                evt = new QueueMsgMoveEvt(type);
                break;
            }
            case 116: {
                evt = new QueueMsgMoveToTopicEvt(type);
                break;
            }
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 76: {
                evt = RouterManager.constructGRLogEvent(type);
                break;
            }
            case 31: {
                evt = new NoDupCommitBegEvt(31);
                break;
            }
            case 40: {
                evt = new NoDupCommitBegEvt(40);
                break;
            }
            case 88: {
                evt = new NoDupCommitBegEvt(88);
                break;
            }
            case 43: {
                evt = new UnfilteredEvt();
                break;
            }
            case 45: {
                evt = new ConnectionIdEvt();
                break;
            }
            case 102: {
                evt = new CounterEvt();
                break;
            }
            case 103: {
                evt = new SyncCounterEvt();
                break;
            }
            case 61: {
                evt = new DurableDisconnectEvt();
                break;
            }
            case 73: {
                evt = new DurableSMOUpdateEvt();
                break;
            }
            case 63: {
                evt = new DeliveryListEvt(63);
                break;
            }
            case 111: {
                evt = new DeliveryListEvt(111);
                break;
            }
            case 156: {
                evt = new DeliveryListEvt(156);
                break;
            }
            case 181: {
                evt = new DeliveryListEvt(181);
                break;
            }
            case 64: {
                evt = new TxnAbortBeginEvt(64);
                break;
            }
            case 87: {
                evt = new TxnAbortBeginEvt(87);
                break;
            }
            case 65: {
                evt = new DurableStatsEvent();
                break;
            }
            case 66: {
                evt = new DeleteEndEvt();
                break;
            }
            case 67: {
                evt = new SyncSubscriptionDeleteEvt();
                break;
            }
            case 62: {
                evt = new ProxyDoubtResolvedEvt();
                break;
            }
            case 72: {
                evt = new BatchSplitEvt();
                break;
            }
            case 74: {
                evt = new SyncDeleteMsgEvt(74);
                break;
            }
            case 118: {
                evt = new SyncDeleteMsgEvt(118);
                break;
            }
            case 79: {
                evt = new TempQueueCreationEvt();
                break;
            }
            case 80: {
                evt = new TempQueueDeletionEvt();
                break;
            }
            case 81: {
                evt = new SyncTempQueueEvt();
                break;
            }
            case 101: {
                evt = new ReplyAckEvt();
                break;
            }
            case -3: {
                evt = new DummyNonLoggableEvt();
                break;
            }
            case 119: {
                evt = new RMInboundEvt(119);
                break;
            }
            case 120: {
                evt = new RMInboundEndEvt(120);
                break;
            }
            case 121: {
                evt = new SyncRMInboundEvt(121);
                break;
            }
            case 122: {
                evt = new RMOutboundEvt(122);
                break;
            }
            case 123: {
                evt = new RMOutboundEndEvt(123);
                break;
            }
            case 124: {
                evt = new SyncRMOutboundEvt(124);
                break;
            }
            case 128: {
                evt = new RMInboundEvt(128);
                break;
            }
            case 129: {
                evt = new RMInboundEndEvt(129);
                break;
            }
            case 130: {
                evt = new SyncRMInboundEvt(130);
                break;
            }
            case 131: {
                evt = new RMOutboundEvt(131);
                break;
            }
            case 132: {
                evt = new RMOutboundEndEvt(132);
                break;
            }
            case 133: {
                evt = new SyncRMOutboundEvt(133);
                break;
            }
            case 125: 
            case 134: {
                evt = new OperationContextAddEvt(type);
                break;
            }
            case 126: {
                evt = new OperationContextRemoveEvt(126);
                break;
            }
            case 127: 
            case 135: {
                evt = new SyncOperationContextEvt(127);
                break;
            }
            case 151: {
                evt = new DurableTrimEvt();
                break;
            }
            case 152: {
                evt = new MsgRestoreBeginEvt();
                break;
            }
            case 153: {
                evt = new MsgRestoreEndEvt();
                break;
            }
            case 154: {
                evt = new SyncMsgRestoreEvt();
                break;
            }
            case 182: {
                evt = new GroupMsgAllocationEvt();
                break;
            }
            case 183: {
                evt = new GroupMsgDeallocationEvt();
                break;
            }
            case 184: {
                evt = new SyncGroupMsgAllocationEvt();
                break;
            }
            case 185: {
                evt = new SyncQueueMsgMoveEvt();
                break;
            }
            case 186: {
                evt = new SyncQueueMsgMoveToTopicEvt();
                break;
            }
            case 187: {
                evt = new QueueMsgGroupAssignEvt();
                break;
            }
            case 188: {
                evt = new QueueMsgGroupUnassignEvt();
                break;
            }
            case 189: {
                evt = new SyncQueueMsgGroupsEvt();
                break;
            }
            default: {
                throw new EUnknownLogEventType(type + "");
            }
        }
        return evt;
    }

    @Override
    public final void write2log(OutputStream out, long maxbytesParam) throws IOException, ELogEventTooLong {
        long maxbytes = maxbytesParam;
        if (this.DEBUG) {
            this.debug("WRITING");
        }
        if ((maxbytes -= 14L) < 0L) {
            throw new ELogEventTooLong(this);
        }
        short type = this.type();
        StreamUtil.writeLong(this.m_seqno, out);
        StreamUtil.writeShort(type, out);
        this.writeBodyToLog(out, maxbytes);
        StreamUtil.writeInt((int)this.m_seqno, out);
        if (this.CALLBACK) {
            Object[] params = new Object[]{new Short(type), out, this};
            this.callback("Log Event Written", 0, params);
        }
    }

    @Override
    public synchronized boolean startLog() {
        if (this.m_canceled) {
            return false;
        }
        this.m_inQueue = false;
        this.m_flushState = 0;
        this.m_logged = true;
        return true;
    }

    @Override
    public void prepareToFire() {
    }

    @Override
    public void exec() {
        if (this.CALLBACK) {
            Object[] params = new Object[]{this};
            this.callback("Log Event Flushed", 1, params);
        }
        AgentRegistrar.getAgentRegistrar().getLogManager().releaseLimiter(this);
        this.notifyFlushed();
        this.onFlush();
    }

    @Override
    public boolean utilizeActionProcessor() {
        return false;
    }

    @Override
    public int memsize() {
        if (this.m_memsize == 0) {
            this.m_memsize = 26 + this.memSizeBody();
        }
        return this.m_memsize;
    }

    public final int serializedLength() {
        return 14 + this.serializedSizeBody();
    }

    protected abstract int serializedSizeBody();

    public final void writeToStream(OutputStream os) throws IOException {
        this.writeToStream(os, true);
    }

    @Override
    public final void writeToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        os.write(2);
        StreamUtil.writeLong(this.getSeqNo(), os);
        StreamUtil.writeShort(this.type(), os);
        StreamUtil.writeBoolean(this.m_replicateOnly, os);
        this.writeBodyToStream(os, tteTTLConvert);
    }

    protected abstract void writeBodyToStream(OutputStream var1, boolean var2) throws IOException;

    public static final IStateEvent readFromStream(InputStream is, boolean tteTTLConvert) throws IOException, EMgramFormatError {
        LogEvent le = null;
        byte version = StreamUtil.readByte(is);
        long seqno = StreamUtil.readLong(is);
        short type = StreamUtil.readShort(is);
        boolean isReplicateOnly = false;
        if (version >= 2) {
            isReplicateOnly = StreamUtil.readBoolean(is);
        }
        le = LogEvent.getEventObject(type);
        le.readBodyFromStream(is, tteTTLConvert);
        le.setSeqNo(seqno);
        le.setReplicateOnly(isReplicateOnly);
        return le;
    }

    protected abstract void readBodyFromStream(InputStream var1, boolean var2) throws IOException, EMgramFormatError;

    @Override
    public String toString() {
        String s = this.getClass().getName();
        return s.substring(s.lastIndexOf(".") + 1) + " seqno = " + this.m_seqno + " : ";
    }

    @Override
    public final int length() {
        return this.streamLength();
    }

    public int streamLength() {
        return 11 + this.streamSizeBody();
    }

    protected abstract int streamSizeBody();
}

