/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import progress.message.broker.LogEvent;
import progress.message.broker.LogTrace;

public class LogFilter {
    private int m_passcount = 1;
    private int m_countdown = 1;
    private int m_firecount = -1;
    private int m_firings = 0;
    private String m_appid = null;
    private String m_rw = null;
    private String m_transacted = null;
    private Hashtable m_filters = new Hashtable();
    private HashSet m_types = null;
    private String[] m_actions = null;
    private String[] m_nomatch = null;
    private String[] m_matchbutpass = new String[]{"pass"};

    public LogFilter(String s) {
        StringTokenizer strtok = new StringTokenizer(s, ";", true);
        String tok = this.nextOrZeroLenString(strtok, ";");
        this.initFilters(tok);
        tok = this.nextOrZeroLenString(strtok, ";");
        this.initPassCount(tok);
        tok = this.nextOrZeroLenString(strtok, ";");
        this.initFireCount(tok);
        tok = this.nextOrZeroLenString(strtok, ";");
        this.initActions(tok);
    }

    final String nextOrZeroLenString(StringTokenizer strtok, String delim) {
        if (!strtok.hasMoreTokens()) {
            return "";
        }
        String tok = strtok.nextToken(delim);
        if (tok.equals(delim)) {
            return "";
        }
        if (strtok.hasMoreTokens()) {
            strtok.nextToken(delim);
        }
        return tok;
    }

    private void initFilters(String list) {
        StringTokenizer strtok = new StringTokenizer(list, ",");
        String tok = null;
        String key = null;
        String value = null;
        while (strtok.hasMoreTokens()) {
            tok = strtok.nextToken();
            int idx = tok.indexOf(":");
            if (idx == -1) continue;
            key = tok.substring(0, idx);
            value = tok.substring(idx + 1);
            this.m_filters.put(key, value);
        }
        this.m_appid = (String)this.m_filters.get("appid");
        this.m_rw = (String)this.m_filters.get("rw");
        this.m_transacted = (String)this.m_filters.get("transacted");
        String s = (String)this.m_filters.get("ltype");
        if (s != null) {
            this.m_types = new HashSet();
            strtok = new StringTokenizer(s, "|");
            while (strtok.hasMoreTokens()) {
                tok = strtok.nextToken();
                this.m_types.add(tok);
            }
        }
    }

    private void initPassCount(String s) {
        int idx = s.indexOf("passcount:");
        if (idx == -1) {
            return;
        }
        String passcount = s.substring(idx + "passcount:".length());
        try {
            this.m_countdown = this.m_passcount = Integer.parseInt(passcount);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initFireCount(String s) {
        int idx = s.indexOf("firecount:");
        if (idx == -1) {
            return;
        }
        String firecount = s.substring(idx + "firecount:".length());
        try {
            this.m_firecount = Integer.parseInt(firecount);
            this.m_firings = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initActions(String actions) {
        int idx = actions.indexOf("action:");
        if (idx == -1) {
            return;
        }
        String list = actions.substring(idx + "action:".length());
        if (list == null) {
            return;
        }
        StringTokenizer strtok = new StringTokenizer(list, ",");
        String tok = null;
        Vector<String> v = new Vector<String>();
        while (strtok.hasMoreTokens()) {
            tok = strtok.nextToken();
            v.add(tok);
        }
        this.m_actions = new String[v.size()];
        v.toArray(this.m_actions);
    }

    private boolean matchType(LogEvent m) {
        if (this.m_types == null) {
            return true;
        }
        String s = LogTrace.typeToString(m.type());
        return this.m_types.contains(s);
    }

    public String[] match(String rw, LogEvent m) {
        String s;
        boolean ok = true;
        if (this.m_firecount != -1 && this.m_firings >= this.m_firecount) {
            ok = false;
        } else if (ok && !this.matchType(m)) {
            ok = false;
        }
        if (ok && this.m_transacted != null) {
            boolean tx = Boolean.valueOf(this.m_transacted);
            boolean bl = ok = tx == LogTrace.isTransacted(m);
        }
        if (ok && this.m_appid != null && ((s = LogTrace.getAppid(m)) == null || s.indexOf(this.m_appid) == -1)) {
            ok = false;
        }
        if (ok && this.m_rw != null && (rw == null || this.m_rw.indexOf(rw) == -1)) {
            ok = false;
        }
        if (!ok) {
            return this.m_nomatch;
        }
        if (this.m_passcount <= 0) {
            return this.m_actions;
        }
        --this.m_countdown;
        if (this.m_countdown == 0) {
            ++this.m_firings;
            this.m_countdown = this.m_passcount;
            return this.m_actions;
        }
        return this.m_matchbutpass;
    }

    public int getCountdown() {
        return this.m_countdown;
    }

    public int getPasscount() {
        return this.m_passcount;
    }

    public int getFirings() {
        return this.m_firings;
    }
}

