/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import progress.message.broker.ECorruptLogEvent;
import progress.message.broker.EInvalidLogEvent;
import progress.message.broker.ELogOutOfSequence;
import progress.message.broker.EStartupFailure;
import progress.message.broker.EUnknownLogEventType;
import progress.message.broker.EventListener;
import progress.message.broker.LogEvent;
import progress.message.broker.LogFile;
import progress.message.broker.LogInputStream;
import progress.message.broker.SyncpointLoc;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;
import progress.message.zclient.EMgramFormatError;

class LogReader
extends DebugObject {
    private EventListener m_listener = null;
    private LogFile m_log = null;
    private LogInputStream m_logis = null;

    LogReader(LogFile log, EventListener listener) {
        super(DebugState.GLOBAL_DEBUG_ON ? "LogReader" : null);
        this.m_log = log;
        this.m_listener = listener;
        if (this.DEBUG) {
            this.debug("Constructing LogReader on " + log);
        }
    }

    synchronized long read(SyncpointLoc sp) throws EInvalidLogEvent, EStartupFailure, IOException {
        long count;
        long lastloc;
        block20: {
            lastloc = 0L;
            long nextseq = 1L;
            count = 0L;
            try {
                this.m_logis = this.m_log.beginRead(sp);
                DataInputStream dis = new DataInputStream(this.m_logis);
                if (this.DEBUG) {
                    this.debug("Starting to read log; position= " + this.m_logis.getFilePointer());
                }
                while (true) {
                    lastloc = this.m_logis.getFilePointer();
                    LogEvent evt = LogEvent.readFromLog(dis);
                    ++count;
                    if (this.DEBUG) {
                        this.debug("read " + evt.toString() + " ;lastloc= " + lastloc);
                    }
                    if (evt.type() == -2) {
                        LogInputStream cont;
                        if (this.DEBUG) {
                            this.debug("Reached EOF " + this.m_logis + " " + lastloc);
                        }
                        if ((cont = this.m_log.continuation()) != null) {
                            this.m_logis = cont;
                            dis = new DataInputStream(this.m_logis);
                            if (!this.DEBUG) continue;
                            this.debug("Continuing " + this.m_logis);
                            continue;
                        }
                        break;
                    }
                    if (evt.type() == 6 && this.m_log.inSync() && this.DEBUG) {
                        this.debug("SyncEndEvt " + this.m_logis + " " + lastloc);
                    }
                    if (evt.type() == -1) {
                        if (this.DEBUG) {
                            this.debug("Reached EOL " + this.m_logis + " " + lastloc);
                        }
                        break;
                    }
                    nextseq = evt.getSeqNo() + (long)evt.getNumSeqNos();
                    this.m_listener.onLogEventRead(evt, lastloc, nextseq);
                }
            }
            catch (EOFException e) {
                if (this.DEBUG) {
                    this.debug("caught " + e);
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                }
            }
            catch (ECorruptLogEvent e) {
                if (this.DEBUG) {
                    this.debug("caught " + e);
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                }
            }
            catch (EUnknownLogEventType e) {
                if (this.DEBUG) {
                    this.debug("caught " + e);
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                }
            }
            catch (ELogOutOfSequence e) {
                if (this.DEBUG) {
                    this.debug("caught " + e);
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                }
            }
            catch (EMgramFormatError e) {
                if (!this.DEBUG) break block20;
                this.debug("caught " + e);
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
        if (this.DEBUG) {
            this.debug("Calling onEndLog " + lastloc);
        }
        this.m_listener.onEndLog(lastloc);
        return count;
    }

    synchronized LogInputStream getLogInputStream() {
        return this.m_logis;
    }
}

