/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import progress.message.broker.Config;
import progress.message.broker.ELogOutOfSequence;
import progress.message.broker.EProtectedBlockReached;
import progress.message.broker.ILogRandomAccessFile;
import progress.message.broker.LogBlockBuffer;
import progress.message.broker.LogBuffer;
import progress.message.broker.LogInputStream;
import progress.message.broker.LogOutputStream;
import progress.message.broker.NativeRandomAccessFile;
import progress.message.broker.WrappedRandomAccessFile;
import progress.message.util.ArrayUtil;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;

public final class LogStreamFile
extends DebugObject {
    private static final String ACCESS_MODE_RW = "rw";
    private static final String ACCESS_MODE_RWD = "rwd";
    private static final String ACCESS_MODE_RWS = "rws";
    private LogInputStream m_logis;
    private LogOutputStream m_logos;
    private ILogRandomAccessFile m_file;
    private LogBlockBuffer m_readbuf;
    private LogBlockBuffer m_writebuf;
    private long m_rpos;
    private long m_wpos;
    private int m_blockSize;
    private boolean m_needSync;
    private byte[] m_workbuf = new byte[8];

    public LogStreamFile(String filename) throws IOException {
        this(filename, Config.LOG_BLOCK_SIZE, 1);
    }

    public LogStreamFile(String filename, int blockSize, int memoryBlocks) throws IOException {
        super(DebugState.GLOBAL_DEBUG_ON ? "LogStreamFile " + filename : null);
        String accessMode = Config.LOG_OPEN_MODE;
        if (Config.EVALUATION_MODE) {
            accessMode = ACCESS_MODE_RW;
        }
        if (!(accessMode.equals(ACCESS_MODE_RWD) || accessMode.equals(ACCESS_MODE_RWS) || accessMode.equals(ACCESS_MODE_RW))) {
            accessMode = ACCESS_MODE_RWD;
        }
        String str = "";
        this.m_needSync = false;
        if (accessMode.equals(ACCESS_MODE_RW)) {
            this.m_needSync = true;
            str = " Config.LOG_FORCE_SYNC= " + Config.LOG_FORCE_SYNC;
        }
        if (Config.LOG_NATIVE_FILE) {
            this.m_file = new NativeRandomAccessFile(filename, accessMode);
        } else {
            this.m_file = new WrappedRandomAccessFile(filename, accessMode);
            if (this.DEBUG) {
                this.debug("Created file " + filename + " accessMode= " + accessMode + " len= " + this.m_file.length() + " blockSize= " + blockSize + " memoryBlocks= " + memoryBlocks + str);
            }
        }
        this.m_blockSize = blockSize;
        File fn = new File(filename);
        if (memoryBlocks < 1) {
            memoryBlocks = 1;
        }
        LogBuffer rbuf = new LogBuffer(fn.getName() + "*r*", this.m_file, this.m_blockSize, 1);
        this.m_readbuf = new LogBlockBuffer(fn.getName() + "*r*", rbuf, this.m_blockSize, true);
        LogBuffer wbuf = new LogBuffer(fn.getName() + "*w*", this.m_file, this.m_blockSize, memoryBlocks);
        this.m_writebuf = new LogBlockBuffer(fn.getName() + "*w*", wbuf, this.m_blockSize, false);
        try {
            this.m_writebuf.setBlockPos(this.m_file, 0L, true);
        }
        catch (ELogOutOfSequence eLogOutOfSequence) {
            // empty catch block
        }
        this.m_rpos = 0L;
        this.m_wpos = 0L;
        this.m_logis = new LogInputStream(this);
        this.m_logos = new LogOutputStream(this);
    }

    public static void copy(String sourcePath, String targetPath, int blockSize) throws FileNotFoundException, IOException {
        int bytesRead;
        FileInputStream fis = new FileInputStream(sourcePath);
        BufferedInputStream source = new BufferedInputStream(fis);
        FileOutputStream fos = new FileOutputStream(targetPath);
        BufferedOutputStream target = new BufferedOutputStream(fos);
        byte[] block = new byte[blockSize];
        while ((bytesRead = source.read(block)) != -1) {
            target.write(block, 0, bytesRead);
        }
        target.close();
        source.close();
    }

    public LogInputStream getInputStream() throws IOException {
        return this.m_logis;
    }

    public LogOutputStream getOutputStream() throws IOException {
        return this.m_logos;
    }

    public void close() throws IOException {
        this.m_file.close();
        this.m_readbuf = null;
        this.m_writebuf = null;
    }

    void flush() {
        try {
            this.m_writebuf.flush(this.m_file);
            if (this.m_needSync) {
                this.m_file.sync();
            }
        }
        catch (IOException ex) {
            System.out.println("IO Exception flushing log file");
        }
    }

    void lazyFlush() {
        try {
            this.m_writebuf.flush(this.m_file);
        }
        catch (IOException ex) {
            System.out.println("IO Exception flushing log file");
        }
    }

    public void sync() {
        if (this.m_needSync) {
            try {
                this.m_file.sync();
            }
            catch (IOException ex) {
                System.out.println("IO Exception syncing log file");
            }
        }
    }

    public long LogicalSize(long physicalsize) {
        return this.m_writebuf.LogicalSize(physicalsize);
    }

    public long getFilePointerRead() throws IOException {
        return this.m_rpos;
    }

    public void seekRead(long pos) throws IOException, ELogOutOfSequence {
        this.m_readbuf.setBlockPos(this.m_file, pos);
        this.m_rpos = pos;
    }

    public long getFilePointerWrite() throws IOException {
        return this.m_wpos;
    }

    public void seekWrite(long pos) throws IOException {
        if (this.DEBUG && pos < 10L) {
            this.debug("seekWrite; oldpos= " + this.m_wpos + " newpos= " + pos);
        }
        try {
            this.m_writebuf.setBlockPos(this.m_file, pos, true);
        }
        catch (EProtectedBlockReached e) {
            this.m_wpos = pos;
            throw e;
        }
        this.m_wpos = pos;
    }

    public synchronized int read() throws EOFException, IOException, ELogOutOfSequence {
        this.m_readbuf.setBlockPos(this.m_file, this.m_rpos);
        int ret = this.m_readbuf.read();
        ++this.m_rpos;
        return ret;
    }

    public void read(byte[] b, int off, int len) throws IOException, EOFException {
        int tcount = 0;
        int rcount = 0;
        while (tcount < len) {
            boolean eof = this.m_readbuf.setBlockPos(this.m_file, this.m_rpos);
            if (eof) {
                throw new EOFException("EOF getting next block for read");
            }
            rcount = this.m_readbuf.read(b, off + tcount, len - tcount);
            tcount += rcount;
            this.m_rpos += (long)rcount;
        }
    }

    public void write(int b) throws IOException {
        this.m_writebuf.setBlockPos(this.m_file, this.m_wpos);
        this.m_writebuf.write(b);
        ++this.m_wpos;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        int tcount = 0;
        int rcount = 0;
        while (tcount < len) {
            this.m_writebuf.setBlockPos(this.m_file, this.m_wpos);
            rcount = this.m_writebuf.write(b, off + tcount, len - tcount);
            tcount += rcount;
            this.m_wpos += (long)rcount;
        }
    }

    public synchronized void incSequenceNumber() {
        long writeSequenceNumber;
        long readSequenceNumber = this.getCurrentReadSequenceNumber();
        long sequenceNumber = readSequenceNumber > (writeSequenceNumber = this.getCurrentWriteSequenceNumber()) ? readSequenceNumber : writeSequenceNumber;
        this.m_writebuf.setSequenceNumber(++sequenceNumber);
    }

    public void protectFilePos(long pos) {
        this.m_writebuf.protectFilePos(pos);
    }

    public void unprotect() {
        this.m_writebuf.unprotect();
    }

    public long getCurrentReadSequenceNumber() {
        return this.m_readbuf.getCurrentSequenceNumber();
    }

    public long getCurrentWriteSequenceNumber() {
        return this.m_writebuf.getCurrentSequenceNumber();
    }

    public void setWriteSequenceNumber(long number) {
        this.m_writebuf.setSequenceNumber(number);
    }

    public void setReadSequenceNumber(long number) {
        this.m_readbuf.setSequenceNumber(number);
    }

    public void setSize(long physicalSize) throws IOException {
        long psize = physicalSize / (long)this.m_blockSize * (long)this.m_blockSize;
        long fsize = this.m_file.length();
        if (fsize < psize) {
            if (this.DEBUG) {
                this.debug("setSize " + physicalSize + " ; about to call setLength() to " + psize + " previous length= " + fsize);
            }
            this.m_file.setLength(psize);
            this.m_file.sync();
            if (this.DEBUG) {
                this.debug("setSize; set length to " + psize + " previous length= " + fsize);
            }
        }
    }

    public void writeInt(int i) throws IOException {
        this.m_writebuf.setBlockPos(this.m_file, this.m_wpos);
        if (this.m_writebuf.tryWriteInt(i)) {
            this.m_wpos += 4L;
            return;
        }
        ArrayUtil.writeInt(this.m_workbuf, 0, i);
        this.write(this.m_workbuf, 0, 4);
    }

    public void writeLong(long i) throws IOException {
        this.m_writebuf.setBlockPos(this.m_file, this.m_wpos);
        if (this.m_writebuf.tryWriteLong(i)) {
            this.m_wpos += 8L;
            return;
        }
        ArrayUtil.writeLong(this.m_workbuf, 0, i);
        this.write(this.m_workbuf, 0, 8);
    }
}

