/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.InterruptedIOException;
import java.util.HashSet;
import java.util.List;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BrokerDatabase;
import progress.message.broker.ICCGuarDoubtManager;
import progress.message.broker.IClientContext;
import progress.message.broker.InterbrokerHook;
import progress.message.broker.MsgRestorer;
import progress.message.broker.MsgSaver;
import progress.message.broker.TrackedSubjectFilter;
import progress.message.db.EDatabaseException;
import progress.message.dbq.IQueryCancelCheck;
import progress.message.dbsc.data.IDbUndelData;
import progress.message.msg.IMgram;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;
import progress.message.zclient.SessionConfig;

public class MgRsContainer
extends DebugObject {
    int i;
    int s_length;
    List m_clientMsgs;
    BrokerDatabase broker_db;
    long client_id;
    IClientContext m_cc;
    MsgRestorer m_restorer = null;
    MsgSaver msgSaver;
    boolean DEBUG1 = (this.debugFlags & 0x40) > 0;

    public MgRsContainer(IClientContext cc, List clientMsgs) {
        super(DebugState.GLOBAL_DEBUG_ON ? "MgRsContainer " + cc.getId() : null);
        this.m_clientMsgs = clientMsgs;
        this.s_length = this.m_clientMsgs.size();
        this.m_cc = cc;
        this.client_id = cc.getId();
        this.msgSaver = AgentRegistrar.getAgentRegistrar().getMsgSaver();
        this.broker_db = AgentRegistrar.getAgentRegistrar().getBrokerDatabase();
        this.i = 0;
    }

    void setMsgRestorer(MsgRestorer restorer) {
        this.m_restorer = restorer;
    }

    long getCurrentMsgID() {
        if (this.i <= this.s_length && this.i > 0) {
            IDbUndelData undel = (IDbUndelData)this.m_clientMsgs.get(this.i - 1);
            return undel.getMessageId();
        }
        return -1L;
    }

    IMgram getNextMgram(IQueryCancelCheck chk) throws EDatabaseException, InterruptedIOException, InterruptedException {
        IMgram m = null;
        IClientContext cc = this.m_restorer == null ? null : this.m_restorer.getCC();
        ICCGuarDoubtManager dm = this.getDm(cc);
        while (m == null && this.i < this.s_length) {
            IDbUndelData undel = (IDbUndelData)this.m_clientMsgs.get(this.i);
            long seq = undel.getSequenceNumber();
            long mid = undel.getMessageId();
            boolean set_successor = undel.getRedelivery();
            boolean fromRemoteBroker = undel.getFromRemoteBroker();
            int size = undel.getMessageSize();
            boolean skip = false;
            m = this.retrieveMgramPopulateSuccess(cc, chk, dm, fromRemoteBroker, mid, seq, set_successor, size, skip, undel);
        }
        return m;
    }

    private IMgram retrieveMgramPopulateSuccess(IClientContext cc, IQueryCancelCheck chk, ICCGuarDoubtManager dm, boolean fromRemoteBroker, long mid, long seq, boolean set_successor, int size, boolean skipParam, IDbUndelData undel) throws InterruptedException, InterruptedIOException, EDatabaseException {
        boolean skip = skipParam;
        IMgram m = null;
        if (!((skip = this.isSkip(mid, seq, skip)) || cc != null && cc.getPendingGuar(mid) != null)) {
            m = this.broker_db.getMgram(chk, undel.getDbRef(), seq, mid, undel.getMgram());
            if (m != null) {
                m.getBrokerHandle().setTrackedSize(size);
                boolean needsGuaranteed = this.isNeedsGuaranteed(m);
                this.populateGuarFormatIncorrect(m, needsGuaranteed);
            }
        } else {
            m = null;
            this.m_restorer.messageSkipped(mid, seq);
        }
        this.populateSuccessorBroker(dm, fromRemoteBroker, m, set_successor, undel);
        return m;
    }

    private boolean isNeedsGuaranteed(IMgram m) {
        boolean needsGuaranteed = this.m_cc.isDurable() ? true : (SessionConfig.isNonDurableSubscriber(this.m_cc.getAppid()) ? this.m_cc.isXOnce() && this.m_cc.getClientSessionVer() >= 28 && m.isNonPersistentReplicated() : (InterbrokerHook.isSet() && InterbrokerHook.isNeighbor(this.client_id) ? true : true));
        return needsGuaranteed;
    }

    private void populateSuccessorBroker(ICCGuarDoubtManager dm, boolean fromRemoteBroker, IMgram m, boolean set_successor, IDbUndelData undel) {
        if (m != null) {
            if (set_successor) {
                m.setSuccessor(true);
            } else if (dm != null) {
                dm.addRestoredFromDb(undel.getMessageId());
            }
            HashSet undelSubjectsIds = undel.getUndelSubjectIds();
            if (undelSubjectsIds != null) {
                m.getBrokerHandle().addSubjectFilter(this.m_cc.getSubjectFilterId(), new TrackedSubjectFilter(undelSubjectsIds));
            }
            if (fromRemoteBroker) {
                m.getBrokerHandle().setFromRemoteBroker(fromRemoteBroker);
            }
        }
        undel.setMgram(null);
        ++this.i;
    }

    private boolean isSkip(long mid, long seq, boolean skipParam) {
        boolean skip = skipParam;
        long maxDBSequenceNumber = this.m_restorer.getMaxDBSequenceNumber();
        if (maxDBSequenceNumber > -1L && maxDBSequenceNumber < seq) {
            if (this.DEBUG) {
                this.debug("Skipping msgId= " + mid + " seq= " + seq + " > max db seq#");
            }
            skip = true;
        }
        return skip;
    }

    private void populateGuarFormatIncorrect(IMgram m, boolean needsGuaranteed) {
        if (needsGuaranteed) {
            if (!m.isGuarenteed()) {
                m.getBrokerHandle().setGuarFormatIncorrect(true);
            }
        } else if (m.isGuarenteed()) {
            m.getBrokerHandle().setGuarFormatIncorrect(true);
        }
    }

    private ICCGuarDoubtManager getDm(IClientContext cc) {
        ICCGuarDoubtManager dm = null;
        if (cc != null) {
            dm = cc.getGuarDoubtManager();
        }
        return dm;
    }

    void close() {
        if (this.DEBUG1) {
            this.debug("NumMessages= " + this.s_length);
        }
        this.m_cc = null;
    }

    int length() {
        return this.s_length;
    }
}

