/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.security.pcs.AbstractCipherSuite;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import progress.message.client.EUnsupportedMgramException;
import progress.message.client.prAccessor;
import progress.message.msg.IMgram;
import progress.message.msg.IMgramConverter;
import progress.message.msg.MgramConstants;
import progress.message.msg.MgramFactory;
import progress.message.resources.prMessageFormat;
import progress.message.util.EAssertFailure;
import progress.message.util.StreamUtil;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.IMessageProtection;

public class MgramSerializer {
    private Hashtable m_converters = new Hashtable();
    private static volatile MgramSerializer s_mgramSerializer = null;
    private IMgramConverter m_currentSerializeConverter = MgramFactory.getMgramConverter(26);
    private IMgramConverter m_currentCreateMgramConverter = MgramFactory.getMgramConverter(26);
    private int m_trackTransactedVersion = 0;

    public static synchronized MgramSerializer getMgramSerializer() {
        if (s_mgramSerializer == null) {
            s_mgramSerializer = new MgramSerializer();
        }
        return s_mgramSerializer;
    }

    private MgramSerializer() {
        Hashtable<String, Boolean> p = new Hashtable<String, Boolean>();
        p.put(MgramConstants.TTE_TTL_CONVERT, new Boolean(true));
        p.put(MgramConstants.IGNORE_SECURITY, new Boolean(true));
        this.m_currentCreateMgramConverter.initializeConverter(p);
    }

    public IMgram unserialize(InputStream is) throws IOException, EMgramFormatError {
        return this.unserialize(is, false, false, false);
    }

    public IMgram unserialize(InputStream is, boolean tteTTLConvert) throws IOException, EMgramFormatError {
        return this.unserialize(is, false, tteTTLConvert, false);
    }

    public IMgram unserializeTransacted(InputStream is) throws IOException, EMgramFormatError {
        return this.unserialize(is, false, false, true);
    }

    private IMgram unserialize(InputStream is, boolean canBeEncryptedParam, boolean tteTTLConvert, boolean transacted) throws IOException, EMgramFormatError {
        boolean canBeEncrypted = canBeEncryptedParam;
        int version = StreamUtil.readByte(is);
        if (transacted && version != 0) {
            this.m_trackTransactedVersion = version;
        }
        if (version == 26) {
            return this.m_currentSerializeConverter.unserialize(is, tteTTLConvert);
        }
        if (transacted) {
            if (version == 0 && (this.m_trackTransactedVersion == 0 || this.m_trackTransactedVersion == 24)) {
                version = 24;
            } else if (version == 0) {
                throw new EOFException();
            }
        }
        if (version > 24) {
            canBeEncrypted = false;
        }
        if (version < 24) {
            String msgFmt = prAccessor.getString("UNSUPPORTED_MGRAM");
            Object[] mObj = new String[]{"" + version};
            String msg = prMessageFormat.format(msgFmt, mObj);
            throw new EUnsupportedMgramException(msg);
        }
        String key = "Unserialize" + version + canBeEncrypted;
        IMgramConverter converter = (IMgramConverter)this.m_converters.get(key);
        if (converter == null) {
            converter = MgramFactory.getMgramConverter(version);
            Hashtable<String, Object> p = new Hashtable<String, Object>();
            if (canBeEncrypted) {
                p.put(MgramConstants.CAN_BE_ENCRYPTED, new Boolean(true));
            }
            IMessageProtection mp = null;
            try {
                mp = AbstractCipherSuite.getNewMessageProtectionInstance();
                mp.init(1, new byte[mp.getSecretKeyLength()]);
                p.put(MgramConstants.MESSAGE_PROTECTION, mp);
            }
            catch (Exception e) {
                throw new EAssertFailure(e);
            }
            try {
                mp = AbstractCipherSuite.getNewMessageProtectionInstance();
                mp.init(2, new byte[mp.getSecretKeyLength()]);
                p.put(MgramConstants.DECRYPT_MESSAGE_PROTECTION, mp);
            }
            catch (Exception e) {
                throw new EAssertFailure(e);
            }
            converter.initializeConverter(p);
            this.m_converters.put(key, converter);
        }
        return converter.unserialize(is, tteTTLConvert);
    }

    public void serialize(OutputStream os, IMgram m, boolean tteTTLConvert) throws IOException {
        byte version = m.getVersion();
        if (version == 26) {
            this.m_currentSerializeConverter.serialize(os, m, tteTTLConvert);
            return;
        }
        throw new EAssertFailure("SonicMQ can only serialize mgrams of the current version to the log or database");
    }
}

