/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.util.StreamUtil;

class MsgDeliveredEvt
extends LogEvent {
    private long m_tracking;

    MsgDeliveredEvt(long tracking) {
        this.m_tracking = tracking;
    }

    MsgDeliveredEvt() {
    }

    long getTracking() {
        return this.m_tracking;
    }

    @Override
    public short type() {
        return 2;
    }

    @Override
    protected int memSizeBody() {
        return 8;
    }

    @Override
    public int streamSizeBody() {
        return this.serializedSizeBody();
    }

    @Override
    public int serializedSizeBody() {
        return 8;
    }

    @Override
    protected void writeBodyToLog(OutputStream os, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        this.writeBodyToStream(os, false);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        StreamUtil.writeLong(this.m_tracking, os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        this.m_tracking = StreamUtil.readLong(in);
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoMsgDelivered(this.m_tracking);
    }

    @Override
    public String toString() {
        return super.toString() + "Message " + this.m_tracking + " delivered";
    }
}

