/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import progress.message.msg.IMgram;

public class MsgRestorePos {
    private long m_maxRestoredMsgId = -1L;
    private long m_maxRestoredMsgSqnNo = -1L;

    public void update(IMgram mg) {
        this.m_maxRestoredMsgId = Math.max(mg.getGuarenteedTrackingNum(), this.m_maxRestoredMsgId);
        this.m_maxRestoredMsgSqnNo = Math.max(mg.getBrokerHandle().getSequenceNumber(), this.m_maxRestoredMsgSqnNo);
    }

    public void update(long msgId, long msgSeqno) {
        this.m_maxRestoredMsgId = Math.max(msgId, this.m_maxRestoredMsgId);
        this.m_maxRestoredMsgSqnNo = Math.max(msgSeqno, this.m_maxRestoredMsgSqnNo);
    }

    public void update(MsgRestorePos pos) {
        this.m_maxRestoredMsgId = Math.max(pos.getMessageId(), this.m_maxRestoredMsgId);
        this.m_maxRestoredMsgSqnNo = Math.max(pos.getSeqno(), this.m_maxRestoredMsgSqnNo);
    }

    public void reset() {
        this.m_maxRestoredMsgId = -1L;
        this.m_maxRestoredMsgSqnNo = -1L;
    }

    public long getMessageId() {
        return this.m_maxRestoredMsgId;
    }

    public long getSeqno() {
        return this.m_maxRestoredMsgSqnNo;
    }

    public String toString() {
        return "MsgRestorePos: MsgId= " + this.m_maxRestoredMsgId + " ;seqno= " + this.m_maxRestoredMsgSqnNo;
    }
}

