/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.broker.Transaction;
import progress.message.util.StreamUtil;
import progress.message.util.StringUtil;

public class NoDupCommitBegEvt
extends LogEvent {
    private String m_noDupCommitId;
    private int m_tid;
    private int m_uid;
    private long m_timestamp;
    private int m_channelStatus = 14;
    private boolean m_isChannel = false;
    private String m_channelId = "";
    private short m_eventType = (short)88;
    private long m_requestId = -1L;
    private boolean m_chained = false;
    private long m_lifespan = 0L;

    NoDupCommitBegEvt(short type) {
        this.m_eventType = type;
    }

    NoDupCommitBegEvt(int tid, int uid, String noDupCommitId, long timestamp, long requestId, boolean chained, long lifespan) {
        this(tid, uid, noDupCommitId, timestamp, false, "", 14, lifespan, requestId, chained);
    }

    NoDupCommitBegEvt(int tid, int uid, String noDupCommitId, long timestamp, boolean isChannel, String channelId, int channelStatus, long lifespan, long requestId, boolean chained) {
        this.m_tid = tid;
        this.m_uid = uid;
        this.m_noDupCommitId = noDupCommitId;
        this.m_timestamp = timestamp;
        this.m_channelStatus = channelStatus;
        this.m_isChannel = isChannel;
        if (channelId != null) {
            this.m_channelId = channelId;
        }
        this.m_requestId = requestId;
        this.m_chained = chained;
        this.m_lifespan = lifespan;
    }

    @Override
    public short type() {
        return 88;
    }

    public int getTid() {
        return this.m_tid;
    }

    public String getNoDupCommitId() {
        return this.m_noDupCommitId;
    }

    public long getTimestamp() {
        return this.m_timestamp;
    }

    public int getChannelStatus() {
        return this.m_channelStatus;
    }

    public String getChannelId() {
        return this.m_channelId;
    }

    public boolean isChannel() {
        return this.m_isChannel;
    }

    long getRequestId() {
        return this.m_requestId;
    }

    boolean getChained() {
        return this.m_chained;
    }

    long getLifespan() {
        return this.m_lifespan;
    }

    @Override
    protected int memSizeBody() {
        return 51 + (this.m_noDupCommitId.length() << 1) + this.m_channelId.length() + 8 + 1 + 8;
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedLength()) {
            throw new ELogEventTooLong(this);
        }
        this.writeBody(out);
    }

    private void writeBody(OutputStream os) throws IOException {
        byte[] utfNoDupCommitId = StringUtil.stringToUTF(this.m_noDupCommitId);
        byte[] utfChannelId = StringUtil.stringToUTF(this.m_channelId);
        StreamUtil.writeInt(this.m_tid, os);
        StreamUtil.writeInt(this.m_uid, os);
        StreamUtil.writeLong(this.m_timestamp, os);
        os.write(utfNoDupCommitId, 0, utfNoDupCommitId.length);
        StreamUtil.writeBoolean(this.m_isChannel, os);
        StreamUtil.writeInt(this.m_channelStatus, os);
        os.write(utfChannelId, 0, utfChannelId.length);
        StreamUtil.writeLong(this.m_requestId, os);
        StreamUtil.writeBoolean(this.m_chained, os);
        StreamUtil.writeLong(this.m_lifespan, os);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeBody(os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        if (this.m_eventType == 31) {
            this.readFields(in);
        } else if (this.m_eventType == 40) {
            this.readChannelFields(in);
        }
        if (this.m_eventType == 88) {
            this.readChannelFields(in);
            this.m_requestId = StreamUtil.readLong(in);
            this.m_chained = StreamUtil.readBoolean(in);
            this.m_lifespan = StreamUtil.readLong(in);
        }
    }

    private void readChannelFields(InputStream in) throws IOException {
        this.readFields(in);
        this.m_isChannel = StreamUtil.readBoolean(in);
        this.m_channelStatus = StreamUtil.readInt(in);
        this.m_channelId = StreamUtil.readUTF(in);
    }

    private void readFields(InputStream in) throws IOException {
        this.m_tid = StreamUtil.readInt(in);
        this.m_uid = StreamUtil.readInt(in);
        this.m_timestamp = StreamUtil.readLong(in);
        this.m_noDupCommitId = StreamUtil.readUTF(in);
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoNoDupCommitBeg(this);
    }

    @Override
    public String toString() {
        return super.toString() + "no duplicate commit of transaction " + this.m_tid + " with transaction id " + this.m_noDupCommitId + " for client " + this.m_uid + ", requestId " + this.m_requestId + ", chained " + this.m_chained + ", lifespan " + this.m_lifespan + ": begin";
    }

    @Override
    public int streamSizeBody() {
        return this.serializedSizeBody();
    }

    @Override
    public int serializedSizeBody() {
        byte[] utfChannelId;
        byte[] utfNoDupCommitId;
        block2: {
            utfNoDupCommitId = null;
            utfChannelId = null;
            try {
                utfNoDupCommitId = StringUtil.stringToUTF(this.m_noDupCommitId);
                utfChannelId = StringUtil.stringToUTF(this.m_channelId);
            }
            catch (UTFDataFormatException e) {
                if (!this.DEBUG) break block2;
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
        return 21 + utfNoDupCommitId.length + utfChannelId.length + 8 + 1 + 8;
    }

    void startNoDupCommit(Transaction txn) {
        txn.startNoDupCommit(this.getNoDupCommitId(), this.getTimestamp(), this.isChannel(), this.getChannelStatus(), this.getChannelId(), this.getLifespan(), this.getRequestId(), this.getChained());
    }
}

