/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.wsp.OperationContext;
import com.sonicsw.wsp.OperationContextManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.util.StreamUtil;
import progress.message.util.StringUtil;

public class OperationContextAddEvt
extends LogEvent {
    private String m_id = null;
    private String m_replyPolicy = null;
    private String m_keyStoreAlias = null;
    private String m_keyPassword = null;
    private String m_jmsCorrelationID = null;
    private short m_type = (short)134;

    public String getId() {
        return this.m_id;
    }

    public String getReplyPolicy() {
        return this.m_replyPolicy;
    }

    public String getKeyStoreAlias() {
        return this.m_keyStoreAlias;
    }

    public String getKeyPassword() {
        return this.m_keyPassword;
    }

    public String getJMSCorrelationID() {
        return this.m_jmsCorrelationID;
    }

    OperationContextAddEvt(short type) {
        this.m_type = type;
    }

    public OperationContextAddEvt(OperationContext oc) {
        this.m_id = oc.getKey();
        this.m_replyPolicy = oc.getResponsePolicy();
        this.m_keyStoreAlias = oc.getSigningCertAlias();
        this.m_keyPassword = oc.getSigningCertPassword();
        this.m_jmsCorrelationID = oc.getJMSCorrelationID();
    }

    @Override
    public short type() {
        return 125;
    }

    @Override
    protected void writeBodyToLog(OutputStream os, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedLength()) {
            throw new ELogEventTooLong(this);
        }
        this.writeBody(os);
    }

    private int memSize(String s) {
        if (s == null) {
            return 0;
        }
        return s.length();
    }

    @Override
    protected int memSizeBody() {
        return this.memSize(this.m_id) + this.memSize(this.m_replyPolicy) + this.memSize(this.m_keyStoreAlias) + this.memSize(this.m_keyPassword) + this.memSize(this.m_jmsCorrelationID);
    }

    @Override
    public void redo(RecoveryMgr rm) {
        OperationContextManager.getOperationContextManager().redoAdd(this);
    }

    @Override
    protected int serializedSizeBody() {
        return this.serializedSizeNullOrUTF(this.m_id) + this.serializedSizeNullOrUTF(this.m_replyPolicy) + this.serializedSizeNullOrUTF(this.m_keyStoreAlias) + this.serializedSizeNullOrUTF(this.m_keyPassword) + this.serializedSizeNullOrUTF(this.m_jmsCorrelationID);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeBody(os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        this.m_id = this.readNullOrUTF(in);
        this.m_replyPolicy = this.readNullOrUTF(in);
        if (this.m_type == 125 || this.m_type == 127) {
            return;
        }
        this.m_keyStoreAlias = this.readNullOrUTF(in);
        this.m_keyPassword = this.readNullOrUTF(in);
        this.m_jmsCorrelationID = this.readNullOrUTF(in);
    }

    @Override
    protected int streamSizeBody() {
        return this.serializedSizeBody();
    }

    private void writeNullOrUTF(String s, OutputStream os) throws IOException {
        byte[] b = StringUtil.stringToUTF("");
        if (s == null) {
            os.write(b, 0, b.length);
        } else {
            b = StringUtil.stringToUTF(s);
            os.write(b, 0, b.length);
        }
    }

    private int serializedSizeNullOrUTF(String s) {
        try {
            byte[] b = StringUtil.stringToUTF("");
            if (s != null) {
                b = StringUtil.stringToUTF(s);
            }
            return b.length;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private String readNullOrUTF(InputStream is) throws IOException {
        String s = StreamUtil.readUTF(is);
        if (s.length() == 0) {
            return null;
        }
        return s;
    }

    private void writeBody(OutputStream os) throws IOException {
        this.writeNullOrUTF(this.m_id, os);
        this.writeNullOrUTF(this.m_replyPolicy, os);
        this.writeNullOrUTF(this.m_keyStoreAlias, os);
        this.writeNullOrUTF(this.m_keyPassword, os);
        this.writeNullOrUTF(this.m_jmsCorrelationID, os);
    }
}

