/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.wsp.OperationContext;
import com.sonicsw.wsp.OperationContextManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.util.StreamUtil;
import progress.message.util.StringUtil;

public class OperationContextRemoveEvt
extends LogEvent {
    private String m_id;
    private short m_type = (short)126;

    OperationContextRemoveEvt(short type) {
        this.m_type = type;
    }

    public OperationContextRemoveEvt(OperationContext oc) {
        this.m_id = oc.getKey();
    }

    public String getId() {
        return this.m_id;
    }

    @Override
    public short type() {
        return 126;
    }

    @Override
    protected void writeBodyToLog(OutputStream os, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedLength()) {
            throw new ELogEventTooLong(this);
        }
        this.writeBody(os);
    }

    @Override
    protected int memSizeBody() {
        return this.m_id.length();
    }

    @Override
    public void redo(RecoveryMgr rm) {
        OperationContextManager.getOperationContextManager().redoRemove(this);
    }

    @Override
    protected int serializedSizeBody() {
        byte[] id;
        block2: {
            id = null;
            try {
                id = StringUtil.stringToUTF(this.m_id);
            }
            catch (UTFDataFormatException e) {
                if (!this.DEBUG) break block2;
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
        return id.length;
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeBody(os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        this.m_id = StreamUtil.readUTF(in);
    }

    @Override
    protected int streamSizeBody() {
        return this.serializedSizeBody();
    }

    private void writeBody(OutputStream os) throws IOException {
        byte[] utfId = StringUtil.stringToUTF(this.m_id);
        os.write(utfId, 0, utfId.length);
    }
}

